
/*
 * 
 * $Log: konnekt.c,v $
 * Revision 1.2  1993/07/01  14:07:07  wade
 * RT clean compilation
 *
 * Revision 1.1  1993/04/21  20:39:20  wade
 * Initial revision
 *
 * 
 * a timed connect from Bob Manchek
 */

#include <sys/time.h>
#include <signal.h>
#include <setjmp.h>

static jmp_buf env;

eek()
{
	longjmp(env, 1);
}


/*	konnekt()
*
*	Returns 0 if ok, -1 if error, -2 if timed out.
*/

konnekt(s, ad, l, nsec)
	int s;
	struct sockaddr *ad;
	int l;
	int nsec;
{
	int cc;
	struct itimerval timeout, oval;
#ifdef ibm032
	int (*oldh)();
#else
	void (*oldh)();
#endif

	timeout.it_interval.tv_sec = timeout.it_interval.tv_usec = 0;
	timeout.it_value.tv_sec = nsec;
	timeout.it_value.tv_usec = 0;
	oldh = signal(SIGALRM, eek);
	(void)setitimer(ITIMER_REAL, &timeout, &oval);

	if (!setjmp(env)) {
		cc = connect(s, ad, l);

		timeout.it_interval.tv_sec = timeout.it_interval.tv_usec = 0;
		timeout.it_value.tv_sec = 0;
		timeout.it_value.tv_usec = 0;
		(void)setitimer(ITIMER_REAL, &timeout, &oval);

	} else {
		cc = -2;
	}
	signal(SIGALRM, oldh);

	return cc;
}



