

/*
 *
 * $Log: index.c,v $
 * Revision 1.5  1993/05/24  17:38:57  wade
 * misc typecasting cleanup
 *
 * Revision 1.4  1993/04/21  15:23:00  wade
 * turned off hot flash checking
 *
 * Revision 1.3  1992/12/15  21:06:05  wade
 * using text instead of bitmaps for contextual help
 *
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 *
 */

#include "xnl.h"

int currentUpIndex_thatwasreallyup;

static Widget *menuItem;

indexCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
        Mode_desired = MODE_INDEX;
        currentUpIndex = (int)call_data;
        
        Handle_state(w, NULL, NULL);
}


Popup_index(w)
Widget w;
{
    currentUpIndex_thatwasreallyup = currentUpIndex;

	currentDisplayText = indexPop[currentUpIndex];

	LibOrClass = Mode = MODE_INDEX;
    
    XtManageChild(indexPop[currentUpIndex]);

    set_status(INDEX_HEADER, GREEN);
	return 1;
}

restart_index(num_servers)
int num_servers;
{
	register int i;

	/* destroy items in menu */
	for (i=0; i < num_servers; i++) 
	  if (menuItem[i] != NULL) {
		XtDestroyWidget(menuItem[i]);
		XtDestroyWidget(indexPop[i]);
	  }
	/* free indexPop, menuItem */
	free(indexPop);
	free(menuItem);

	make_index(toplevel);
}

make_index(w)
Widget w;
{
    Arg args[20];
    register int n, i;
    char filename[MAXLINE];
    FILE *fp;
    Boolean fileAvailable, anyNew;
    Widget entry;
	int file_age;
	char name[255];
	int IDX_LIFE_save;

    /* always check for new index */
    IDX_LIFE_save = IDX_LIFE;
    IDX_LIFE = 0;

	con_help[MODE_INDEX] = "\n\
The Index for each server lists site specific libraries\n\
and other information.\n";


	anyNew = False;

    indexPop = (Widget*)malloc(Many_servers * sizeof(Widget) );
    menuItem = (Widget*)malloc(Many_servers * sizeof(Widget) );
    
    for (i=0; i < Many_servers; i++) {
        
        sprintf(filename, "%s/%s/%s", XNL_PATH, server_list[i], INDEX_FILE);
    
        file_age = confirmFile(filename, (PUBDATA) ? 1 : 0, False, True);

        /* first check to see if the file is there */
        if (fp = fopen(filename, "r")) {
            fileAvailable = True;
			fclose(fp);
        } else
            fileAvailable = False;

        if (fileAvailable) {

			if (file_age == 2) {
				strcpy(name, "* ");
				anyNew = True; /* at least one new file (mark button) */
			} else {
				name[0] = '\0';
			}
			strcat(name, server_list[i]);
        
            /* add the entry in the index menu */
            menuItem[i] = entry = XtCreateManagedWidget(name, smeBSBObjectClass,
				 indexMenu, NULL, 0);
            XtAddCallback(entry, XtNcallback, (XtCallbackProc)indexCB, 
				(XtPointer)i);

            
            /* now make the index */
			n = 0;
            XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways);
                                                            n++;
            XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollWhenNeeded);
                                                            n++;
            XtSetArg(args[n], XtNtype, XawUtkasciiFile); n++;
            XtSetArg(args[n], XtNstring, filename); n++;
            indexPop[i] = XtCreateWidget("indexPop", utkasciiTextWidgetClass, 
            topPane, args, n);
        } else {
			indexPop[i] = menuItem[i] = (Widget)NULL;
        }
    } /* for each server */

#ifdef NOWAYINHELL
	/* check for hot flash files only on primary server */
	sprintf(filename, "%s/%s/%s", XNL_PATH, server_list[0], HOT_FLASH);

	file_age = confirmFile(filename, (PUBDATA) ? 1 : 0, False, True);

	if (fp = fopen(filename, "r")) {
		fclose(fp);
		showFile(toplevel, filename);
		unlink(filename);
	}
#endif

    IDX_LIFE = IDX_LIFE_save;

	if (anyNew) {	/* mark the index button */
		XtSetArg(args[0], XtNlabel, "* Index");
		XtSetValues(indexButton, args, 1);
	}

    return 1;
}

Popdown_index(w)
Widget w;
{
    XtUnmanageChild(indexPop[currentUpIndex_thatwasreallyup]);

	currentDisplayText = NULL;

    return 1;
}

