/* database_submit.c */

/* submit() - called when user clicks on "submit" on Conference Submission
 *            form
 * submitOK() - called when user confirms submit on "Is all the information
 *              correct? dialog
 */

#include "database.h"

void
submit(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
	Widget fromdateWidget, todateWidget, titleWidget, locationWidget, 
               descWidget;
	String fromdate, todate, title, location, desc;
	Widget popup = XtParent(XtParent(XtParent(w)));
	Boolean failed = False;
	int s;
        char fromDateStr[12], toDateStr[12];
        char *pos;
        char submitter[1024];

        set_status(DATABASE_HEADER, GREEN);
	if ( (fromdateWidget = XtNameToWidget(popup, "*fromTextPopup")) &&
	     (todateWidget = XtNameToWidget(popup, "*toTextPopup")) &&
	     (titleWidget = XtNameToWidget(popup, "*titleText")) &&
	     (locationWidget = XtNameToWidget(popup, "*locationText")) &&
	     (descWidget = XtNameToWidget(popup, "*description"))
		) {
		XtVaGetValues(fromdateWidget, XtNstring, &fromdate, NULL);
		XtVaGetValues(todateWidget, XtNstring, &todate, NULL);
		XtVaGetValues(titleWidget, XtNstring, &title, NULL);
		XtVaGetValues(locationWidget, XtNstring, &location, NULL);
		XtVaGetValues(descWidget, XtNstring, &desc, NULL);


		XtVaSetValues(databaseDisplayText, XtNstring, "", NULL);

		if (0==strlen(title)) {
			add_text_lit(databaseDisplayText, 
                             "\nMissing conference title.\n");
			failed = True;
		}
		if (0==strlen(location)) {
			add_text_lit(databaseDisplayText, 
                          "\nMissing conference location.\n");
			failed = True;
		}
		if (0==strlen(desc)) {
                  desc = "Description not available.";
                  XtVaSetValues(descWidget, XtNstring, desc, NULL); 
		}
		if ((0==strlen(fromdate)) ||
                   (parse_date(fromdate,fromDateStr) == -1)) {
			add_text_lit(databaseDisplayText, 
 "\nInvalid conference start date. (mmm dd yyyy  example - Jan 1 1993)\n");
			failed = True;
		}
                else
                    XtVaSetValues(fromdateWidget, XtNstring, fromDateStr,
                                  NULL);
		if ((0==strlen(todate)) ||
                   (parse_date(todate,toDateStr) == -1)) {
			add_text_lit(databaseDisplayText, 
 "\nInvalid conference end date. (mmm dd yyyy  example - Jan 1 1993)\n");
			failed = True;
		}
                else
                    XtVaSetValues(todateWidget, XtNstring, toDateStr,
                                  NULL);

		if (failed) {
			add_text_lit(databaseDisplayText, 
                     "\nCouldn't submit conference.\n");
		} else {
        
			char *line, *tmp, *tmp2;
			int i,j,l,num_lines;

	/* find num_lines from string size with escaped newlines */
			for (num_lines=i=0; desc[i]; i++)
			    if ((desc[i] == '\n') || (desc[i] == '\t') ||
                                (desc[i] == '"') )	num_lines++;

			i = strlen(desc)+ 2 * (strlen(title)+ strlen(EMAIL_ADDRESS)+
				strlen(fromDateStr)+ strlen(toDateStr)+
                                strlen(location)+100+num_lines) ;

                        if (failed) {
			    add_text_lit(databaseDisplayText, 
                         "\nCouldn't submit conference.\n");
                       } else {
#ifdef DEBUG
    printf("desc:\n%s\n");
#endif
                        l = strlen(desc) + 100 + num_lines;
			line = (char*)XtMalloc(i);
                        
			tmp = (char*)XtMalloc(l);

			for (num_lines=i=0; title[i]; i++)
			    if ((title[i] == '\n') || (title[i] == '\t') ||
                                (title[i] == '"') )	num_lines++;
                        l = strlen(title) + 100 + num_lines;
                        tmp2 = (char *)XtMalloc(l);

			/* now replace the newlines with \n's */
			for (j=i=0; desc[i]; i++,j++)
				if (desc[i] == '\n') {
					tmp[j++] = '\\';
					tmp[j] = 'n';
				}  else if (desc[i] == '\t') {
					tmp[j++] = '\\';
					tmp[j] = 't'; 
                                }  else if (desc[i] == '"') {
                                        tmp[j++] = '\\';
                                        tmp[j] = '"';
				}  else 
					tmp[j] = desc[i];
                        tmp[j] = '\0';
			/* now replace the newlines with \n's */
			for (j=i=0; title[i]; i++,j++)
				if (title[i] == '\n') {
					tmp2[j++] = '\\';
					tmp2[j] = 'n';
				}  else if (title[i] == '\t') {
					tmp2[j++] = '\\';
					tmp2[j] = 't'; 
                                }  else if (title[i] == '"') {
                                        tmp2[j++] = '\\';
                                        tmp2[j] = '"';
				}  else 
					tmp2[j] = title[i];
                        tmp2[j] = '\0';
                        strcpy(submitter, EMAIL_ADDRESS);
                        pos = strchr(submitter,' ');
                        *pos = '\0';
			sprintf(line, 
"title=\"%s\"\tsubmitter=\"%s\"\tdescription=\"Title: %s\\nSubmitted by: %s\\nStart Date: %s\\nEnd Date: %s\\nLocation: %s\\n\\n%s\"\tstart_date=\"%s\"\tend_date=\"%s\"\tlocation=\"%s\"",
				tmp2, EMAIL_ADDRESS, 
				tmp2, submitter, fromDateStr, toDateStr, location,
				tmp, fromDateStr, 
                                toDateStr, location);

			XtFree(tmp);
			XtFree(tmp2);
#ifdef DEBUG
printf("submit--<%s>\n", line);
#endif
                        SubmitLine = line;

{
    Arg     args[5];
    Widget  popup;
    Position    x, y;
    Dimension   width, height;
    register int n;


    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(w, args, n);
    XtTranslateCoords(w, (Position) -20,
            (Position) -30, &x, &y);


    n = 0;
    XtSetArg(args[n], XtNx, x);             n++;
    XtSetArg(args[n], XtNy, y);             n++;

    popup = XtCreatePopupShell("databaseSubmitOkPopup",
        transientShellWidgetClass, w, args, n);

    databaseSubmitOkDialog = 
        XtCreateManagedWidget("databaseSubmitOkDialog",
        dialogWidgetClass, popup,NULL, 0);
    XtVaSetValues(databaseSubmitOkDialog, XtNlabel,
            "Is all of the information correct?", NULL);

    XawDialogAddButton(databaseSubmitOkDialog, "yes, submit", submitOkCB,
        (XtPointer) NULL);
    XawDialogAddButton(databaseSubmitOkDialog, "no, return to edit mode",
        Destroy_form,
        (XtPointer)databaseSubmitOkDialog);

    XtPopup(popup, XtGrabExclusive);
}

		        }
               }
	} else {
		fprintf(stderr, "Couldn't lookup widget names--shouldn't happen!!\n");
	}

/*	if (!failed)
		XtDestroyWidget(popup); */

        if (failed)
{
    Arg     args[5];
    Widget  popup, button, last;
    Position    x, y;
    Dimension   width, height;
    register int n;


    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(w, args, n);
    XtTranslateCoords(w, (Position) (width / 2),
            (Position) (height / 2), &x, &y);


    n = 0;
    XtSetArg(args[n], XtNx, x);             n++;
    XtSetArg(args[n], XtNy, y);             n++;

    popup = XtCreatePopupShell("failedPopup",
        transientShellWidgetClass, w, args, n);

    databaseSubmitFailedDialog = 
        XtCreateManagedWidget("databaseSubmitFailedDialog",
        formWidgetClass, popup,NULL, 0);

    n = 0;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel,
      "Submission failed -- ");  n++;
    last = XtCreateManagedWidget("subfailedlabel1",
            labelWidgetClass, databaseSubmitFailedDialog, args, n);

    n = 0;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel,
      "see main window for explanation");  n++;
    XtSetArg(args[n], XtNfromVert, last);  n++;
    last = XtCreateManagedWidget("subfailedlabel2",
            labelWidgetClass, databaseSubmitFailedDialog, args, n);

    n = 0;
    XtSetArg(args[n], XtNfromVert, last);  n++;
    button = XtCreateManagedWidget("dismiss", commandWidgetClass,
        databaseSubmitFailedDialog, args, n);
    XtAddCallback(button, XtNcallback, Destroy_form, 
        (XtPointer) databaseSubmitFailedDialog);

    XtPopup(popup, XtGrabExclusive);
}

		        
}

void
submitOkCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    int s;


        if ((s=SubmitEntry(DBNAME, RELATION, SubmitLine, 
		"title\tlocation\tdescription")) > 0) {

/*    swrite(s,DBNAME);
    swrite(s,"\tsubmitentry\t");
    swrite(s,RELATION);
    swrite(s,"\t");
    swrite(s,SubmitLine);
    swrite(s,"\tend\tbegin\ttitle\tlocation\tdescription\tend\n");
*/
		add_text_lit(databaseDisplayText, 
			"\nConference submitted.\n");
	} else {
		add_text_lit(databaseDisplayText, 
		"\nConference not submitted; couldn't contact server.\n");
	}

	XtFree(SubmitLine);
        XtDestroyWidget(XtParent(w));
        XtDestroyWidget(SubmitPopup);
}

