/*************************************************************************/
/*                  VChat interactive IP-level chat system               */
/*-----------------------------------------------------------------------*/
/*  (c) '93/'94 by Andreas S. Wetzel (mickey@deadline.panic.bln.sub.org  */
/*                 All rights reserverd.                                 */ 
/*-----------------------------------------------------------------------*/
/* See the file COPYRIGHT in the top level directory of VChat for        */
/* copyright notices and further disclaimers.                            */ 
/*************************************************************************/

#include "../config.h"
#include "../global.h"
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#include "proto.h"

/********** Code **********/

int edline(char *line, int len)
{
	/* Hier haben wir nun also unsere Eingaberoutine */
	/* Aufrufparameter sind der Zeiger auf den Text- */
	/* buffer und die maximale Eingabelaenge.        */
	/* Als returnwert erhalten wir die Anzahl der    */
	/* eingelesenen Zeichen zurueck.                 */

	char c;
	int i, space, j;
	int pos = 0;
	int result;
	static char wrap[80];
	static int first;
	char tmp[255];
	char command[3];
	char receiver[80];
	struct timeval tout;
	extern int t_rows;
	extern int sock;
	extern char csi[];
	extern int errno;
	fd_set rfdset;
	fd_set errset;

	for(i=0; i<len; i++)
		line[i] = '\0';

	if(first)
	{
		first = 0;
		wrap[0] = '\0';
	}

	if(wrap[0] != '\0')
	{
		strcpy(line, wrap);
		cprintf(2,"%s",line);
		
		pos = strlen(line);
		wrap[0] = '\0';
	}

	for (;;)
	{
		FD_ZERO(&rfdset);
		FD_ZERO(&errset);
		FD_SET(sock, &rfdset);
		FD_SET(sock, &errset);
		FD_SET(1, &rfdset);
		FD_SET(1, &errset);

		if((result=select(FD_SETSIZE, &rfdset, (fd_set *) 0, &errset, NULL) < 0))
		{
			switch(result)
			{
				case EINTR:	break;
				case EINVAL:
				case EBADF:	quit(1,(char *)strerror(errno));
						break;
			}
			continue;
		}

		if(FD_ISSET(sock, &errset))
		{
			quit(2,"Server connection breakdown.\n");
		}
		if(FD_ISSET(sock, &rfdset))
		{
			rcv_sv_msg();
		}
		if(FD_ISSET(1, &rfdset))
		{
			c = getchar();
		}
		else
		{
			continue;	
		}

		line[pos] = '\0';

		if (c < ' ' || c == DEL)
		{
			switch (c)
			{
				case DEL:
				case BS:	if (pos)
						{
							putchar(8);
							putchar(32);
							putchar(8);
							fflush(stdout);
							line[--pos] = '\0';
						}
						break;
				case CTLU:	mv(1, t_rows);
						cprintf(2, "%sK", csi);
						pos = 0;
						for (i=0; i<len; i++) line[i] = '\0';
						break;
				case CTLW:	while ((pos) && (line[pos-1] == ' '))
						{
							line[--pos] = '\0';
						}
						while ((pos) && (line[pos-1] != ' '))
						{
							line[--pos] = '\0';
						}
						mv(pos, t_rows);
						cprintf(2,"%sK", csi);
						break;
				case CTLR:	mv(1, t_rows);
						cprintf(2,"%sK%s", csi, line);
						break;
				case CR:
				case LF:	if (pos)
						{
							mv(1,t_rows);
							cprintf(2, "%s%sK", vt(0, OFF | BOLD), csi);
							line[pos] = '\0';
							return(strlen(line));
						}
						else
						{
							break;
						}
				default:	chat_beep();
						break;
			}
		}
		else
		{
			if (pos < len)
			{
				line[pos++] = c;
			        putchar(c);

				fflush(stdout);
			}
			else
			{
				if (!strchr(":/.", line[0]) || (strchr("/.:", line[0]) &&
				line[1] == 'm'))
				{
					i = pos;
					j=0;

					if((strrchr(line,' ') - sizeof(line)) > len/3)
					{
						while (i && (line[i] != ' '))
						{
							i--;
						}
						space = i;
						while (++i < len) tmp[j++] = line[i];
						tmp[j++] = c;
						tmp[j] = '\0';
						line[space] = '\0';
					}
					else
					{
						tmp[0] = c;
						line[pos] = tmp[1] = '\0';
					}
					if (strchr(":./", line[0]) && line[1] == 'm')
					{
						sscanf(line, "%2s%s", command, receiver);
						sprintf(wrap, "%s %s + %s", command, receiver, tmp);
					}
					else
					{
						sprintf(wrap, "+ %s", tmp);
					}
					strcat(line, " +");
					mv(1, t_rows);
					cprintf(2, "%sK", csi);
					return(strlen(line));
				}
				else
				{
					chat_beep();
				}
			}
		}
	}
}

void chat_beep(void)
{
	putchar(7);
}
