#! /bin/sh
#
# DIP		The Dialup-IP Connection Handler program.
#
# Usage:	Install.sh [--firsttime] [--nobackup]
#
# Version:	@(#)Install.sh  1.50	12/13/93
#
# Authors:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
#		Johannes Grosen, <grosen@argv.cs.ndsu.nodak.edu>
#		Copyright 1988-1993 MicroWalt Corporation
#
#		This program is free software; you can redistribute it
#		and/or  modify it under  the terms of  the GNU General
#		Public  License as  published  by  the  Free  Software
#		Foundation;  either  version 2 of the License, or  (at
#		your option) any later version.
#
PATH=/bin:/usr/bin:/sbin:/usr/sbin
export PATH
NROFF="groff -Tascii"	# how to format man pages for catman

  backup()
  {
	if [ "${nobackup}" = "NO" ]; then
		if [ -s $1 ]; then
			mv $1 $1.old
		fi
	fi
  }

  firsttime=NO
  nobackup=NO
  while [ $# != 0 ]; do
	case $1 in
		--firsttime)
			firsttime="YES"
			shift
			;;

		--nobackup)
			nobackup="YES"
			shift
			;;

		-*)
			echo "Usage: Install.sh [--firsttime] [--nobackup]" >&2
			exit 1
			;;

		*)
			shift
			;;
	esac
  done
  echo "Installing DIP..."

  # Check if this is either SLS, Pro or something unknown.
  if [ -d /conf/net ]; then	# Linux/PRO
	ETC="/etc"
	SBIN="/sbin"
	USBIN="/usr/sbin"
	CONF="/conf/net"
	DOLINK=1
    else			# SLS or vanilla
	ETC="/etc"
	SBIN="/etc"
	USBIN="/usr/etc"
	CONF="/etc"
	DOLINK=0
  fi

  # Are we expected to install preformatted manual pages?
  if [ -d /usr/man/cat1 ]; then
	CATMAN=1
    else
	CATMAN=0
  fi

  # Install the CONFIG files.
  if [ "${firsttime}" = "YES" ]; then
	echo ; echo "Installing CONFIG files..."
	cp -a samples/etc/* ${ETC}
	echo ; echo "Installing CONFIG (${CONF}) files..."
	cp -a samples/conf/* ${CONF}
	CONFIG=1

	# Set up those damn symbolic links.
	if [ ${DOLINK} -eq 1 ]; then
		echo ; echo "Setting up symbolic links..."
		links="`cd ${CONF}; echo *`"
		for i in ${links}
		do
			ln -sf ${CONF}/$i ${ETC}/$i
		done
	fi
    else
	CONFIG=0
  fi

  # Install the DIP program.
  echo ; echo "Installing binary..."
  backup ${USBIN}/dip
  cp dip ${USBIN}/dip
  chmod 6750 ${USBIN}/dip
  chown root.dip ${USBIN}/dip
  (cd ${USBIN} ; ln -sf dip diplogin)

  # Install manual page.
  echo ; echo "Installing manual page..."
  cp man/dip.8 /usr/man/man8
  chmod 644 /usr/man/man8/dip.8
  chown bin.bin /usr/man/man8/dip.8
  (cd /usr/man/man8 ; ln -sf dip.8 diplogin.8)

  if [ ${CATMAN} -eq 1 ]; then
	rm -f /usr/man/cat8/dip.8
	${NROFF} -man man/dip.8 > /usr/man/cat8/dip.8
	chmod 644 /usr/man/cat8/dip.8
	chown bin.bin /usr/man/cat8/dip.8
	(cd /usr/man/cat8 ; ln -sf dip.8 diplogin.8)
  fi

  echo ; echo "Installation completed."
  if [ ${CONFIG} -eq 1 ]; then
	echo
	echo "Do NOT forget to edit the files in ${CONF} just installed."
	echo "or the NET-2 system will not operate correctly!"
  fi
  if [ "${nobackup}" = "NO" ]; then
	echo
	echo "Your old binaries (if they existed) were backed up to <name>.old."
	echo "You may safely delete them once you are satisfied that the new"
	echo "setup is working correctly."
  fi
  echo

  exit 0
