/*
 * Utilities to read and write the .gopherrc file 
 */

#include "gopher.h"
#include <fcntl.h>
#include <pwd.h>

int
rcopen(flags) 
  int flags;
{
     struct passwd *pwdentry;
     char rcfilename[MAXPATHLEN];
     int rcfile;
     
     pwdentry = getpwuid(geteuid());

     if (pwdentry == NULL)
	  return;

     /** First, let's find out if there is a bookmark file **/

     strcpy(rcfilename,pwdentry->pw_dir);   /* Home directory */
     strcat(rcfilename,"/.gopherrc");

     rcfile = open(rcfilename, flags);

     return(rcfile);
}     

void
read_rc()
{
     int rcfile;
     char rcfilename[512];
     char inputline[512];
     struct passwd *pwdentry;

     pwdentry = getpwuid(geteuid());

     if (pwdentry == NULL)
	  return;

     rcfile = rcopen(O_RDONLY);

     if (rcfile < 0)
	  return;    /*** No such file ***/

     while (readline(rcfile, inputline, sizeof(inputline))) {

	  if (*inputline == '#')
	       continue;

	  ZapCRLF(inputline);
	  if (strncasecmp(inputline, "bookmarks:", 9)==0) {
	      
	       if (BookmarkDir == NULL)
		    BookmarkDir = GDnew(32);
	       
	       GDfromLink(BookmarkDir, rcfile, "localhost", 70);
	       
	       GDsetTitle(BookmarkDir, "Bookmarks");
	  }
	  else if (strncasecmp(inputline, "Printercmd: ", 12) == 0) {
	       STRset(PrinterCommand, inputline + 12);
	  }
	  else if (strncasecmp(inputline, "Telnetcmd: ", 11) == 0) {
	       STRset(TelnetCommand, inputline + 11);
	  }
	  else if (strncasecmp(inputline, "Mailcmd: ", 9) == 0) {
	       STRset(MailCommand, inputline + 9);
	  }
	  else if (strncasecmp(inputline, "Playcmd: ", 9) == 0) {
	       STRset(PlayCommand, inputline + 9);
	  }
	  else if (strncasecmp(inputline, "TN3270cmd: ", 11) == 0) {
	       STRset(TN3270Command, inputline + 11);
	  }
	  else if (strncasecmp(inputline, "MIMEcmd: ", 11) == 0) {
	       STRset(MIMECommand, inputline + 9);
	  }

     }

     close(rcfile);
}

void
set_defs()
{
     STRset(MailCommand, MAIL_COMMAND);
     STRset(PrinterCommand, PRINTER_COMMAND);
     STRset(TelnetCommand, TELNET_COMMAND);
     STRset(PlayCommand, PLAY_COMMAND);
     STRset(TN3270Command, TN3270_COMMAND);
     STRset(MIMECommand, MIME_COMMAND);
}     


void
read_env()
{
     /** Get the pager command **/
     
     if (getenv("PAGER") == NULL)
	  STRset(PagerCommand, PAGER_COMMAND);
     else
	  STRset(PagerCommand, getenv("PAGER"));

     if (getenv("EDITOR") == NULL)
	  STRset(EditorCommand, "vi ");
     else
	  STRset(EditorCommand, getenv("EDITOR"));
     
     if (getenv("GOPHER_MAIL") != NULL)
           STRset(MailCommand, getenv("GOPHER_MAIL"));

      if (getenv("GOPHER_PRINTER") != NULL)
           STRset(PrinterCommand, getenv("GOPHER_PRINTER"));

     if (getenv("GOPHER_TELNET") != NULL)
	  STRset(TelnetCommand, getenv("GOPHER_TELNET"));

     if (getenv("GOPHER_PLAY") != NULL)
	  STRset(PlayCommand, getenv("GOPHER_PLAY"));

     if (getenv("GOPHER_TN3270") != NULL)
	  STRset(TN3270Command, getenv("GOPHER_TN3270"));

     if (getenv("GOPHER_MIME") != NULL)
	  STRset(MIMECommand, getenv("GOPHER_MIME"));
}


void
write_rc()
{
     int rcfile;
     char rcfilename[512];
     char oldrcfilename[512];
     char inputline[512];
     struct passwd *pwdentry;

     pwdentry = getpwuid(geteuid());

     if (pwdentry == NULL)
	  return;

     if (SecureMode)
	  return;

     /** First, let's find out if there is a rc file **/

     strcpy(rcfilename,pwdentry->pw_dir);   /* Home directory */
     strcat(rcfilename,"/.gopherrc");
     strcpy(oldrcfilename,pwdentry->pw_dir); 
     strcat(oldrcfilename,"/.gopherrc~");

     rcfile = open(rcfilename, O_RDONLY);

     if (rcfile > -1)
	  if (rename(rcfilename, oldrcfilename)<0) {
	       CursesErrorMsg("Aborting gopher configuration save!!");
	       return;
	  }

     close(rcfile);

     rcfile = open(rcfilename, O_WRONLY|O_CREAT|O_TRUNC, 0755);

     if (rcfile < 0) {
	  CursesErrorMsg("Can't write gopher configuration file!!");
	  return;    
     }

     writestring(rcfile, "Printercmd: ");
     writestring(rcfile, STRget(PrinterCommand));
     writestring(rcfile, "\nTelnetcmd: ");
     writestring(rcfile, STRget(TelnetCommand));
     writestring(rcfile, "\nMailcmd: ");
     writestring(rcfile, STRget(MailCommand));
     writestring(rcfile, "\nPlaycmd: ");
     writestring(rcfile, STRget(PlayCommand));
     writestring(rcfile, "\nTN3270cmd: ");
     writestring(rcfile, STRget(TN3270Command));
     writestring(rcfile, "\nMIMEcmd: ");
     writestring(rcfile, STRget(MIMECommand));
     
     if (BookmarkDir != NULL) {
	  writestring(rcfile, "\nbookmarks:\n");
	  GDtoLink(BookmarkDir, rcfile);
     }

     close(rcfile);
}

