/*
 * ppp.c - ppp and pppd control.
 *
 * Copyright (c) 1994 Eric Schenk.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL ERIC SCHENK BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ERIC
 * SCHENK HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ERIC SCHENK SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND ERIC SCHENK HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include <linux/ppp.h>
#include "diald.h"

void fork_pppd()
{
    int mask, pgrpid;

    /* Run pppd directly here and set up to wait for the iface */
    pppd_pid = fork();

    if (pppd_pid < 0) {
	syslog(LOG_ERR, "failed to fork pppd: %m");
	die(1);
    }

    if (pppd_pid == 0) {
	char **argv = (char **)malloc(sizeof(char *)*(pppd_argc+7));
	int i = 0, j;;

	argv[i++] = PATH_PPPD;
	argv[i++] = "-detach";
	if (modem) argv[i++] = "modem";
	if (crtscts) argv[i++] = "crtscts";
	if (netmask) {
	    argv[i++] = "netmask";
	    argv[i++] = netmask;
	}
	for (j = 0; j < pppd_argc; j++)
	    argv[i++] = pppd_argv[j];
	argv[i++] = 0;

	/* make sure pppd is the session leader and has the controlling
         * terminal so it gets the SIGHUP's
         */
	pgrpid = setsid();
        ioctl(modem_fd, TIOCSCTTY, 1);
	tcsetpgrp(modem_fd, pgrpid);

	setreuid(getuid(), getuid());
	setregid(getgid(), getgid());
	sigemptyset(&mask);
	sigaddset(&mask, SIGINT);
	sigaddset(&mask, SIGHUP);
	sigprocmask(SIG_SETMASK, &mask, NULL);

	dup2(modem_fd, 0);
	dup2(modem_fd, 1);

	execv(PATH_PPPD,argv);

	syslog(LOG_ERR, "could not exec %s: %m",PATH_PPPD);
	_exit(99);
	/* NOTREACHED */
    }
    syslog(LOG_ERR,"Running pppd (pid = %d).",pppd_pid);
}

/*
 * SET_SA_FAMILY - set the sa_family field of a struct sockaddr,
 * if it exists.
 */

#define SET_SA_FAMILY(addr, family)                     \
    memset ((char *) &(addr), '\0', sizeof(addr));      \
    addr.sa_family = (family);

/*
 * Find the interface number of the ppp device that pppd opened up.
 * If pppd has not yet opened the device, then return -1.
 */

int find_ppp_iface()
{
    ulong laddr = 0, raddr = 0;

    /* Try to get the interface number if we don't know it yet. */
    if (ppp_iface == -1) ioctl(modem_fd, PPPIOCGUNIT, &ppp_iface);
    if (!dynamic_addrs && ppp_iface != -1) return 1;
    /* Ok then, see if pppd has set the addresses yet. */
    if (ppp_iface != -1) {
	struct ifreq   ifr; 
	
	SET_SA_FAMILY (ifr.ifr_addr,    AF_INET); 
	SET_SA_FAMILY (ifr.ifr_dstaddr, AF_INET); 
	SET_SA_FAMILY (ifr.ifr_netmask, AF_INET); 
	sprintf(ifr.ifr_name,"ppp%d",ppp_iface);
        if (ioctl(skfd, SIOCGIFADDR, (caddr_t) &ifr) == -1)
	   syslog(LOG_ERR,"failed to get ppp local address: %m");
	else
	   laddr = ((struct sockaddr_in *) &ifr.ifr_addr)->sin_addr.s_addr;

        if (ioctl(skfd, SIOCGIFDSTADDR, (caddr_t) &ifr) == -1) 
	   syslog(LOG_ERR,"failed to get ppp remote address: %m");
	else
	   raddr = ((struct sockaddr_in *) &ifr.ifr_addr)->sin_addr.s_addr;

	if (raddr != 0 && laddr != 0) {
	    struct in_addr addr;
	    addr.s_addr = raddr;
	    strcpy(remote_ip,inet_ntoa(addr));
	    addr.s_addr = laddr;
	    strcpy(local_ip,inet_ntoa(addr));
	    syslog(LOG_INFO,"New addresses: local %s, remote %s.",
		local_ip,remote_ip);
	    proxy_config();
	    return 1;
	}
    }
    return 0;
}
