#define ID_LENGTH 16		/* number of bytes in a connection id */
#define MAX_RULES 16		/* max number of rules to match on */
#define CHASH_SIZE 256		/* number of hash table entries for id's */
#define TIME_SLOTS 600		/* ten minutes of distinct time slots */

struct match_rule {
    unsigned char equal:1;	/* should the match be equal or not equal */
    unsigned char bytes:3;	/* number of bytes this test applies to */
    unsigned char shift;	/* number of bits to shift */
    int offset;		/* the offset of the value to compare.
   				 * 0..23 is 0..23 in the IP header
   				 * 24 up is 0 up in the packet contents
   				 */
    int mask;			/* bit mask to apply before test */
    int val;			/* value to match */
};

typedef struct filter {
    unsigned char id_rule[ID_LENGTH];
    int protocol;	/* protocol to match, -1 means any */
    char match_rules;
    struct match_rule rule[MAX_RULES];
    int timeout;	/* timeout 0 means don't track this type of packet */
    struct filter *next;
} Filter;

typedef struct connection {
    int time_to_live;		/* how long does this entry have to live */
    unsigned char id[ID_LENGTH];
    int queuepos, hash;
    struct connection *qnext, *qprev;
    struct connection *hnext, *hprev;
} Connection;

Connection *connections[CHASH_SIZE];		/* hash table */
Connection *timeout_queue[TIME_SLOTS];		/* circular queue */
Filter *filters = 0;				/* list of filters */
int timeout_offset = 0;		/* current position in circular queue */
int total_connections = 0;	/* current count of connections */

struct {
    char *s;
    unsigned char id_rule[ID_LENGTH];
} filter_ids[] = {
    "tcp", 9, 12,13,14,15, 16,17,18,19, 24,25,  26,27, 255,255,255,
    "udp", 9, 12,13,14,15, 16,17,18,19, 24,25,  26,27, 255,255,255,
    "icmp",  9, 12,13,14,15, 16,17,18,19, 255,255,255,255,255,255,255,
    "any",  9, 12,13,14,15, 16,17,18,19, 255,255,255,255,255,255,255,
    0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
};

struct {
    char *s;
    int offset;
    int bytes;
    int shift;
    int mask;
} filter_vars[] = {
    "ip.ihl",		0, 1, 0, 0xf,
    "ip.version",	0, 1, 4, 0xf,
    "ip.tos",		1, 1, 0, 0xff,
    "ip.tot_len",	2, 2, 0, 0xffff,
    "ip.id",		4, 2, 0, 0xffff,
    "ip.frag_off",	6, 2, 0, 0xffff,
    "ip.ttl",		8, 1, 0, 0xff,
    "ip.protocol",	9, 1, 0, 0xff,
    "ip.check",		10, 2, 0, 0xffff,
    "ip.saddr",		12, 4, 0, 0xffffffff,
    "ip.daddr",		16, 4, 0, 0xffffffff,
    "tcp.source",	24, 2, 0, 0xffff,
    "tcp.dest",		26, 2, 0, 0xffff,
    "tcp.seq",		28, 4, 0, 0xffffffff,
    "tcp.ack_seq",	32, 4, 0, 0xffffffff,
    "tcp.res1",		36, 1, 0, 0xf,
    "tcp.doff",		36, 1, 4, 0xf,
    "tcp.fin",		37, 1, 0, 0x1,
    "tcp.syn",		37, 1, 1, 0x1,
    "tcp.rst",		37, 1, 2, 0x1,
    "tcp.psh",		37, 1, 3, 0x1,
    "tcp.ack",		37, 1, 4, 0x1,
    "tcp.urg",		37, 1, 5, 0x1,
    "tcp.res2",		37, 1, 6, 0x3,
    "udp.source",	24, 2, 0, 0xffff,
    "udp.dest",		26, 2, 0, 0xffff,
    "udp.len",		28, 2, 0, 0xffff,
    "udp.check",	30, 2, 0, 0xffff,
    "icmp.type",	24, 1, 0, 0xff,
    "icmp.code",	25, 1, 0, 0xff,
    "icmp.checksum",	26, 2, 0, 0xffff,
    "icmp.echo.id",	  28, 2, 0, 0xffff,
    "icmp.echo.sequence", 30, 2, 0, 0xffff,
    "icmp.gateway",	28, 4, 0, 0xffffffff,
    0,0,0,0,0
};
