/*
 * filter.c - Packet filtering for diald.
 *
 * Copyright (c) 1994 Eric Schenk.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL ERIC SCHENK BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ERIC
 * SCHENK HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ERIC SCHENK SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND ERIC SCHENK HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include "diald.h"

/*
 * Open up the various files we use to monitor network activity.
 */
void filter_setup()
{
    /* get a socket to the INET kernel */ 
    if ((skfd = socket(AF_INET, SOCK_PACKET, htons(0x0003))) < 0) {
        syslog(LOG_ERR, "Could not get socket to do packet monitoring: %m");
        die(1);
    }
}

/*
 * Set up the idle filter mechanism for a connected link.
 */
void idle_filter_init()
{
    if (mode == MODE_SLIP) {
	sprintf(snoop_dev,"sl%d",proxy_iface);
    } else {
	sprintf(snoop_dev,"ppp%d",ppp_iface);
    }
    if (debug) syslog(LOG_INFO,"Changed snoop device to %s",snoop_dev);
    txtotal = rxtotal = 0;
}

/*
 * Point the idle filter to proxy link.
 */
void idle_filter_proxy()
{
    sprintf(snoop_dev,"sl%d",proxy_iface);
    if (debug) syslog(LOG_INFO,"Changed snoop device to %s",snoop_dev);
}

/*
 * We got a packet on the snooping socket.
 * Read the packet. Return 1 if the packet means the link should be up 0
 * otherwise. At the same time record the packet in the idle filter structure.
 */
void filter_read()
{
    struct sockaddr from;
    int from_len = sizeof(struct sockaddr);
    int len;

    if ((len = recvfrom(skfd,packet,4096,0,&from,&from_len)) > 0) {
	if (strcmp(snoop_dev,from.sa_data) == 0) {
	    rxtotal += len;
            if ((ntohs(((struct iphdr *)packet)->frag_off) & 0x1fff) == 0) {
	        /* Mark passage of first packet */
	        if (check_firewall(fwunit,0,packet,len) && state == STATE_UP)
	            state_timeout = -1;
	    }
	}
    }
}

void flush_timeout_queue()
{
    struct firewall_req req;
    req.unit = fwunit;
    ctl_firewall(IP_FW_QFLUSH,&req);
}

int queue_empty()
{
    struct firewall_req req;
    req.unit = fwunit;
    return ctl_firewall(IP_FW_QCHECK,&req);
}

void print_filter_queue(int sig)
{
    struct firewall_req req;
    syslog(LOG_INFO,"User requested dump of firewall queue.");
    syslog(LOG_INFO,"--------------------------------------");
    req.unit = fwunit;
    ctl_firewall(IP_FW_PCONN,&req);
    syslog(LOG_INFO,"--------------------------------------");
}
