/*
 *	Configuration options for diald.
 */

/* You're lock files are probably somewhere else unless you
 * happen to be running something based on the BOGUS release.
 * usually they are in /var/spool/uucp or /usr/spool/uucp.
 */
#define LOCK_PREFIX	"/var/lock/LCK.."

/*
 * If you're lock files should contain binary PID's then
 * comment the following line out. I think most linux
 * distributions want ASCII PID's in the lock files.
 */
#define PIDSTRING

/*
 * Diald needs to be able to find its default configuration files.
 * These paths should match the installation path in the Makefile!
 */
#define DIALD_CONFIG_FILE "/etc/diald.conf"
#define DIALD_DEFS_FILE "/etc/diald.defs"

/*
 * Diald needs to use the route and ifconfig binaries to set up
 * routing tables and to bring up the proxy device. Check where
 * these executables are on your system and set these paths to match.
 */
#define PATH_ROUTE	"/sbin/route"
#define PATH_IFCONFIG	"/sbin/ifconfig"

/*
 * I you're never going to use pppd don't worry if this is wrong.
 * Otherwise, find your pppd executable and set this path to match its
 * location.
 */
#define PATH_PPPD	"/usr/sbin/pppd"
