/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AtomizableIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.xpath.XPathException;

public final class Atomizer
extends ComputedExpression
implements MappingFunction {
    private Expression sequence;

    public Atomizer(Expression expression) {
        this.sequence = expression;
    }

    public Expression simplify() throws XPathException {
        this.sequence = this.sequence.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.sequence = this.sequence.analyze(staticContext);
        if (Type.isSubType(this.sequence.getItemType(), Type.ATOMIC_TYPE)) {
            return this.sequence;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.sequence = this.sequence.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.sequence};
        return expressionArray;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        if (sequenceIterator instanceof AtomizableIterator) {
            ((AtomizableIterator)sequenceIterator).setIsAtomizing(true);
        }
        return new MappingIterator(sequenceIterator, this, null, null);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.sequence.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        if (item instanceof NodeInfo) {
            SequenceIterator sequenceIterator = item.getTypedValue();
            return sequenceIterator.next();
        }
        return item;
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        if (item instanceof NodeInfo) {
            return item.getTypedValue();
        }
        return item;
    }

    public ItemType getItemType() {
        return Type.ATOMIC_TYPE;
    }

    public int computeCardinality() {
        return 1792;
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "atomize");
        this.sequence.display(n + 1, namePool);
    }
}

