// SPDX-License-Identifier: GPL-2.0
/*
 * Support for Intel Camera Imaging ISP subsystem.
 * Copyright (c) 2015, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 */

#define IA_CSS_INCLUDE_PARAMETERS
#include "sh_css_params.h"
#include "isp/kernels/aa/aa_2/ia_css_aa2.host.h"
#include "isp/kernels/anr/anr_1.0/ia_css_anr.host.h"
#include "isp/kernels/anr/anr_2/ia_css_anr2.host.h"
#include "isp/kernels/bh/bh_2/ia_css_bh.host.h"
#include "isp/kernels/bnr/bnr_1.0/ia_css_bnr.host.h"
#include "isp/kernels/bnr/bnr2_2/ia_css_bnr2_2.host.h"
#include "isp/kernels/cnr/cnr_2/ia_css_cnr2.host.h"
#include "isp/kernels/crop/crop_1.0/ia_css_crop.host.h"
#include "isp/kernels/csc/csc_1.0/ia_css_csc.host.h"
#include "isp/kernels/ctc/ctc_1.0/ia_css_ctc.host.h"
#include "isp/kernels/ctc/ctc1_5/ia_css_ctc1_5.host.h"
#include "isp/kernels/ctc/ctc2/ia_css_ctc2.host.h"
#include "isp/kernels/de/de_1.0/ia_css_de.host.h"
#include "isp/kernels/de/de_2/ia_css_de2.host.h"
#include "isp/kernels/dp/dp_1.0/ia_css_dp.host.h"
#include "isp/kernels/fixedbds/fixedbds_1.0/ia_css_fixedbds_param.h"
#include "isp/kernels/fpn/fpn_1.0/ia_css_fpn.host.h"
#include "isp/kernels/gc/gc_1.0/ia_css_gc.host.h"
#include "isp/kernels/gc/gc_2/ia_css_gc2.host.h"
#include "isp/kernels/macc/macc_1.0/ia_css_macc.host.h"
#include "isp/kernels/macc/macc1_5/ia_css_macc1_5.host.h"
#include "isp/kernels/ob/ob_1.0/ia_css_ob.host.h"
#include "isp/kernels/ob/ob2/ia_css_ob2.host.h"
#include "isp/kernels/output/output_1.0/ia_css_output.host.h"
#include "isp/kernels/raw_aa_binning/raw_aa_binning_1.0/ia_css_raa.host.h"
#include "isp/kernels/s3a/s3a_1.0/ia_css_s3a.host.h"
#include "isp/kernels/sc/sc_1.0/ia_css_sc.host.h"
#include "isp/kernels/sdis/sdis_1.0/ia_css_sdis.host.h"
#include "isp/kernels/sdis/sdis_2/ia_css_sdis2.host.h"
#include "isp/kernels/tnr/tnr_1.0/ia_css_tnr.host.h"
#include "isp/kernels/uds/uds_1.0/ia_css_uds_param.h"
#include "isp/kernels/wb/wb_1.0/ia_css_wb.host.h"
#include "isp/kernels/xnr/xnr_1.0/ia_css_xnr.host.h"
#include "isp/kernels/xnr/xnr_3.0/ia_css_xnr3.host.h"
#include "isp/kernels/ynr/ynr_1.0/ia_css_ynr.host.h"
#include "isp/kernels/ynr/ynr_2/ia_css_ynr2.host.h"
#include "isp/kernels/fc/fc_1.0/ia_css_formats.host.h"
#include "isp/kernels/tdf/tdf_1.0/ia_css_tdf.host.h"
#include "isp/kernels/dpc2/ia_css_dpc2.host.h"
#include "isp/kernels/eed1_8/ia_css_eed1_8.host.h"
#include "isp/kernels/bnlm/ia_css_bnlm.host.h"
#include "isp/kernels/conversion/conversion_1.0/ia_css_conversion.host.h"
/* Generated code: do not edit or commmit. */

#include "ia_css_pipeline.h"
#include "ia_css_isp_params.h"
#include "ia_css_debug.h"
#include "assert_support.h"

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_aa(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	unsigned int size   =
	    stage->binary->info->mem_offsets.offsets.param->dmem.aa.size;
	unsigned int offset =
	    stage->binary->info->mem_offsets.offsets.param->dmem.aa.offset;

	if (size) {
		struct sh_css_isp_aa_params *t =  (struct sh_css_isp_aa_params *)
						  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset];
		t->strength = params->aa_config.strength;
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_anr(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.anr.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.anr.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_anr() enter:\n");

			ia_css_anr_encode((struct sh_css_isp_anr_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->anr_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_anr() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_anr2(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->vmem.anr2.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->vmem.anr2.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_anr2() enter:\n");

			ia_css_anr2_vmem_encode((struct ia_css_isp_anr2_params *)
						&stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_VMEM].address[offset],
						&params->anr_thres,
						size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_VMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_anr2() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_bh(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.bh.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.bh.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_bh() enter:\n");

			ia_css_bh_encode((struct sh_css_isp_bh_params *)
					 &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					 &params->s3a_config,
					 size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_bh() leave:\n");
		}
	}
	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->hmem0.bh.size;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_bh() enter:\n");

			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_HMEM0] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_bh() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_cnr(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.cnr.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.cnr.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_cnr() enter:\n");

			ia_css_cnr_encode((struct sh_css_isp_cnr_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->cnr_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_cnr() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_crop(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.crop.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.crop.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_crop() enter:\n");

			ia_css_crop_encode((struct sh_css_isp_crop_isp_params *)
					   &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					   &params->crop_config,
					   size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_crop() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_csc(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.csc.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.csc.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_csc() enter:\n");

			ia_css_csc_encode((struct sh_css_isp_csc_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->cc_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_csc() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_dp(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.dp.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.dp.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_dp() enter:\n");

			ia_css_dp_encode((struct sh_css_isp_dp_params *)
					 &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					 &params->dp_config,
					 size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_dp() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_bnr(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.bnr.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.bnr.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_bnr() enter:\n");

			ia_css_bnr_encode((struct sh_css_isp_bnr_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->nr_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_bnr() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_de(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.de.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.de.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_de() enter:\n");

			ia_css_de_encode((struct sh_css_isp_de_params *)
					 &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					 &params->de_config,
					 size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_de() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_ecd(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.ecd.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.ecd.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_ecd() enter:\n");

			ia_css_ecd_encode((struct sh_css_isp_ecd_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->ecd_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_ecd() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_formats(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.formats.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.formats.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_formats() enter:\n");

			ia_css_formats_encode((struct sh_css_isp_formats_params *)
					      &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					      &params->formats_config,
					      size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_formats() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_fpn(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.fpn.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.fpn.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_fpn() enter:\n");

			ia_css_fpn_encode((struct sh_css_isp_fpn_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->fpn_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_fpn() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_gc(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.gc.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.gc.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_gc() enter:\n");

			ia_css_gc_encode((struct sh_css_isp_gc_params *)
					 &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					 &params->gc_config,
					 size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_gc() leave:\n");
		}
	}
	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->vamem1.gc.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->vamem1.gc.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_gc() enter:\n");

			ia_css_gc_vamem_encode((struct sh_css_isp_gc_vamem_params *)
					       &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_VAMEM1].address[offset],
					       &params->gc_table,
					       size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_VAMEM1] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_gc() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_ce(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.ce.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.ce.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_ce() enter:\n");

			ia_css_ce_encode((struct sh_css_isp_ce_params *)
					 &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					 &params->ce_config,
					 size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_ce() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_yuv2rgb(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.yuv2rgb.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.yuv2rgb.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_yuv2rgb() enter:\n");

			ia_css_yuv2rgb_encode((struct sh_css_isp_csc_params *)
					      &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					      &params->yuv2rgb_cc_config,
					      size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_yuv2rgb() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_rgb2yuv(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.rgb2yuv.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.rgb2yuv.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_rgb2yuv() enter:\n");

			ia_css_rgb2yuv_encode((struct sh_css_isp_csc_params *)
					      &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					      &params->rgb2yuv_cc_config,
					      size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_rgb2yuv() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_r_gamma(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->vamem0.r_gamma.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->vamem0.r_gamma.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_r_gamma() enter:\n");

			ia_css_r_gamma_vamem_encode((struct sh_css_isp_rgb_gamma_vamem_params *)
						    &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_VAMEM0].address[offset],
						    &params->r_gamma_table,
						    size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_VAMEM0] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_r_gamma() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_g_gamma(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->vamem1.g_gamma.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->vamem1.g_gamma.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_g_gamma() enter:\n");

			ia_css_g_gamma_vamem_encode((struct sh_css_isp_rgb_gamma_vamem_params *)
						    &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_VAMEM1].address[offset],
						    &params->g_gamma_table,
						    size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_VAMEM1] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_g_gamma() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_b_gamma(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->vamem2.b_gamma.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->vamem2.b_gamma.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_b_gamma() enter:\n");

			ia_css_b_gamma_vamem_encode((struct sh_css_isp_rgb_gamma_vamem_params *)
						    &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_VAMEM2].address[offset],
						    &params->b_gamma_table,
						    size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_VAMEM2] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_b_gamma() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_uds(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.uds.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.uds.offset;

		if (size) {
			struct sh_css_sp_uds_params *p;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_uds() enter:\n");

			p = (struct sh_css_sp_uds_params *)
			    &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset];
			p->crop_pos = params->uds_config.crop_pos;
			p->uds = params->uds_config.uds;

			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_uds() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_raa(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.raa.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.raa.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_raa() enter:\n");

			ia_css_raa_encode((struct sh_css_isp_aa_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->raa_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_raa() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_s3a(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.s3a.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.s3a.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_s3a() enter:\n");

			ia_css_s3a_encode((struct sh_css_isp_s3a_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->s3a_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_s3a() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_ob(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.ob.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.ob.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_ob() enter:\n");

			ia_css_ob_encode((struct sh_css_isp_ob_params *)
					 &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					 &params->ob_config,
					 &params->stream_configs.ob, size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_ob() leave:\n");
		}
	}
	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->vmem.ob.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->vmem.ob.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_ob() enter:\n");

			ia_css_ob_vmem_encode((struct sh_css_isp_ob_vmem_params *)
					      &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_VMEM].address[offset],
					      &params->ob_config,
					      &params->stream_configs.ob, size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_VMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_ob() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_output(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.output.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.output.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_output() enter:\n");

			ia_css_output_encode((struct sh_css_isp_output_params *)
					     &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					     &params->output_config,
					     size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_output() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_sc(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.sc.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.sc.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_sc() enter:\n");

			ia_css_sc_encode((struct sh_css_isp_sc_params *)
					 &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					 &params->sc_config,
					 size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_sc() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_bds(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.bds.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.bds.offset;

		if (size) {
			struct sh_css_isp_bds_params *p;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_bds() enter:\n");

			p = (struct sh_css_isp_bds_params *)
			    &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset];
			p->baf_strength = params->bds_config.strength;

			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_bds() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_tnr(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.tnr.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.tnr.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_tnr() enter:\n");

			ia_css_tnr_encode((struct sh_css_isp_tnr_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->tnr_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_tnr() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_macc(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.macc.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.macc.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_macc() enter:\n");

			ia_css_macc_encode((struct sh_css_isp_macc_params *)
					   &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					   &params->macc_config,
					   size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_macc() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_sdis_horicoef(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->vmem.sdis_horicoef.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->vmem.sdis_horicoef.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis_horicoef() enter:\n");

			ia_css_sdis_horicoef_vmem_encode((struct sh_css_isp_sdis_hori_coef_tbl *)
							 &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_VMEM].address[offset],
							 &params->dvs_coefs,
							 size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_VMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis_horicoef() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_sdis_vertcoef(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->vmem.sdis_vertcoef.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->vmem.sdis_vertcoef.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis_vertcoef() enter:\n");

			ia_css_sdis_vertcoef_vmem_encode((struct sh_css_isp_sdis_vert_coef_tbl *)
							 &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_VMEM].address[offset],
							 &params->dvs_coefs,
							 size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_VMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis_vertcoef() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_sdis_horiproj(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.sdis_horiproj.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.sdis_horiproj.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis_horiproj() enter:\n");

			ia_css_sdis_horiproj_encode((struct sh_css_isp_sdis_hori_proj_tbl *)
						    &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
						    &params->dvs_coefs,
						    size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis_horiproj() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_sdis_vertproj(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.sdis_vertproj.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.sdis_vertproj.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis_vertproj() enter:\n");

			ia_css_sdis_vertproj_encode((struct sh_css_isp_sdis_vert_proj_tbl *)
						    &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
						    &params->dvs_coefs,
						    size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis_vertproj() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_sdis2_horicoef(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->vmem.sdis2_horicoef.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->vmem.sdis2_horicoef.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis2_horicoef() enter:\n");

			ia_css_sdis2_horicoef_vmem_encode((struct sh_css_isp_sdis_hori_coef_tbl *)
							  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_VMEM].address[offset],
							  &params->dvs2_coefs,
							  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_VMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis2_horicoef() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_sdis2_vertcoef(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->vmem.sdis2_vertcoef.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->vmem.sdis2_vertcoef.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis2_vertcoef() enter:\n");

			ia_css_sdis2_vertcoef_vmem_encode((struct sh_css_isp_sdis_vert_coef_tbl *)
							  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_VMEM].address[offset],
							  &params->dvs2_coefs,
							  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_VMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis2_vertcoef() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_sdis2_horiproj(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.sdis2_horiproj.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.sdis2_horiproj.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis2_horiproj() enter:\n");

			ia_css_sdis2_horiproj_encode((struct sh_css_isp_sdis_hori_proj_tbl *)
						     &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
						     &params->dvs2_coefs,
						     size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis2_horiproj() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_sdis2_vertproj(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.sdis2_vertproj.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.sdis2_vertproj.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis2_vertproj() enter:\n");

			ia_css_sdis2_vertproj_encode((struct sh_css_isp_sdis_vert_proj_tbl *)
						     &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
						     &params->dvs2_coefs,
						     size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_sdis2_vertproj() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_wb(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.wb.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.wb.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_wb() enter:\n");

			ia_css_wb_encode((struct sh_css_isp_wb_params *)
					 &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					 &params->wb_config,
					 size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_wb() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_nr(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.nr.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.nr.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_nr() enter:\n");

			ia_css_nr_encode((struct sh_css_isp_ynr_params *)
					 &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					 &params->nr_config,
					 size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_nr() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_yee(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.yee.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.yee.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_yee() enter:\n");

			ia_css_yee_encode((struct sh_css_isp_yee_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->yee_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_yee() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_ynr(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.ynr.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.ynr.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_ynr() enter:\n");

			ia_css_ynr_encode((struct sh_css_isp_yee2_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->ynr_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_ynr() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_fc(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.fc.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.fc.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_fc() enter:\n");

			ia_css_fc_encode((struct sh_css_isp_fc_params *)
					 &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					 &params->fc_config,
					 size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE, "ia_css_process_fc() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_ctc(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.ctc.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.ctc.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_ctc() enter:\n");

			ia_css_ctc_encode((struct sh_css_isp_ctc_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->ctc_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_ctc() leave:\n");
		}
	}
	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->vamem0.ctc.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->vamem0.ctc.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_ctc() enter:\n");

			ia_css_ctc_vamem_encode((struct sh_css_isp_ctc_vamem_params *)
						&stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_VAMEM0].address[offset],
						&params->ctc_table,
						size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_VAMEM0] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_ctc() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_xnr_table(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->vamem1.xnr_table.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->vamem1.xnr_table.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_xnr_table() enter:\n");

			ia_css_xnr_table_vamem_encode((struct sh_css_isp_xnr_vamem_params *)
						      &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_VAMEM1].address[offset],
						      &params->xnr_table,
						      size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_VAMEM1] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_xnr_table() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_xnr(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.xnr.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.xnr.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_xnr() enter:\n");

			ia_css_xnr_encode((struct sh_css_isp_xnr_params *)
					  &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					  &params->xnr_config,
					  size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_xnr() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_process_function() */

static void
ia_css_process_xnr3(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params)
{
	assert(params);

	{
		unsigned int size   =
		    stage->binary->info->mem_offsets.offsets.param->dmem.xnr3.size;

		unsigned int offset =
		    stage->binary->info->mem_offsets.offsets.param->dmem.xnr3.offset;

		if (size) {
			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_xnr3() enter:\n");

			ia_css_xnr3_encode((struct sh_css_isp_xnr3_params *)
					   &stage->binary->mem_params.params[IA_CSS_PARAM_CLASS_PARAM][IA_CSS_ISP_DMEM].address[offset],
					   &params->xnr3_config,
					   size);
			params->isp_params_changed = true;
			params->isp_mem_params_changed[pipe_id][stage->stage_num][IA_CSS_ISP_DMEM] =
			    true;

			ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
					    "ia_css_process_xnr3() leave:\n");
		}
	}
}

/* Code generated by genparam/gencode.c:gen_param_process_table() */

void (*ia_css_kernel_process_param[IA_CSS_NUM_PARAMETER_IDS])(
    unsigned int pipe_id,
    const struct ia_css_pipeline_stage *stage,
    struct ia_css_isp_parameters *params) = {
	ia_css_process_aa,
	ia_css_process_anr,
	ia_css_process_anr2,
	ia_css_process_bh,
	ia_css_process_cnr,
	ia_css_process_crop,
	ia_css_process_csc,
	ia_css_process_dp,
	ia_css_process_bnr,
	ia_css_process_de,
	ia_css_process_ecd,
	ia_css_process_formats,
	ia_css_process_fpn,
	ia_css_process_gc,
	ia_css_process_ce,
	ia_css_process_yuv2rgb,
	ia_css_process_rgb2yuv,
	ia_css_process_r_gamma,
	ia_css_process_g_gamma,
	ia_css_process_b_gamma,
	ia_css_process_uds,
	ia_css_process_raa,
	ia_css_process_s3a,
	ia_css_process_ob,
	ia_css_process_output,
	ia_css_process_sc,
	ia_css_process_bds,
	ia_css_process_tnr,
	ia_css_process_macc,
	ia_css_process_sdis_horicoef,
	ia_css_process_sdis_vertcoef,
	ia_css_process_sdis_horiproj,
	ia_css_process_sdis_vertproj,
	ia_css_process_sdis2_horicoef,
	ia_css_process_sdis2_vertcoef,
	ia_css_process_sdis2_horiproj,
	ia_css_process_sdis2_vertproj,
	ia_css_process_wb,
	ia_css_process_nr,
	ia_css_process_yee,
	ia_css_process_ynr,
	ia_css_process_fc,
	ia_css_process_ctc,
	ia_css_process_xnr_table,
	ia_css_process_xnr,
	ia_css_process_xnr3,
};

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_dp_config(const struct ia_css_isp_parameters *params,
		     struct ia_css_dp_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_dp_config() enter: config=%p\n",
			    config);

	*config = params->dp_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_dp_config() leave\n");
	ia_css_dp_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_dp_config(struct ia_css_isp_parameters *params,
		     const struct ia_css_dp_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_dp_config() enter:\n");
	ia_css_dp_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->dp_config = *config;
	params->config_changed[IA_CSS_DP_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_dp_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_wb_config(const struct ia_css_isp_parameters *params,
		     struct ia_css_wb_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_wb_config() enter: config=%p\n",
			    config);

	*config = params->wb_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_wb_config() leave\n");
	ia_css_wb_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_wb_config(struct ia_css_isp_parameters *params,
		     const struct ia_css_wb_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_wb_config() enter:\n");
	ia_css_wb_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->wb_config = *config;
	params->config_changed[IA_CSS_WB_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_wb_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_tnr_config(const struct ia_css_isp_parameters *params,
		      struct ia_css_tnr_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_tnr_config() enter: config=%p\n",
			    config);

	*config = params->tnr_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_tnr_config() leave\n");
	ia_css_tnr_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_tnr_config(struct ia_css_isp_parameters *params,
		      const struct ia_css_tnr_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_tnr_config() enter:\n");
	ia_css_tnr_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->tnr_config = *config;
	params->config_changed[IA_CSS_TNR_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_tnr_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_ob_config(const struct ia_css_isp_parameters *params,
		     struct ia_css_ob_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_ob_config() enter: config=%p\n",
			    config);

	*config = params->ob_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_ob_config() leave\n");
	ia_css_ob_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_ob_config(struct ia_css_isp_parameters *params,
		     const struct ia_css_ob_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_ob_config() enter:\n");
	ia_css_ob_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->ob_config = *config;
	params->config_changed[IA_CSS_OB_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_ob_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_de_config(const struct ia_css_isp_parameters *params,
		     struct ia_css_de_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_de_config() enter: config=%p\n",
			    config);

	*config = params->de_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_de_config() leave\n");
	ia_css_de_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_de_config(struct ia_css_isp_parameters *params,
		     const struct ia_css_de_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_de_config() enter:\n");
	ia_css_de_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->de_config = *config;
	params->config_changed[IA_CSS_DE_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_de_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_anr_config(const struct ia_css_isp_parameters *params,
		      struct ia_css_anr_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_anr_config() enter: config=%p\n",
			    config);

	*config = params->anr_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_anr_config() leave\n");
	ia_css_anr_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_anr_config(struct ia_css_isp_parameters *params,
		      const struct ia_css_anr_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_anr_config() enter:\n");
	ia_css_anr_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->anr_config = *config;
	params->config_changed[IA_CSS_ANR_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_anr_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_anr2_config(const struct ia_css_isp_parameters *params,
		       struct ia_css_anr_thres *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_anr2_config() enter: config=%p\n",
			    config);

	*config = params->anr_thres;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_anr2_config() leave\n");
	ia_css_anr2_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_anr2_config(struct ia_css_isp_parameters *params,
		       const struct ia_css_anr_thres *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_anr2_config() enter:\n");
	ia_css_anr2_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->anr_thres = *config;
	params->config_changed[IA_CSS_ANR2_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_anr2_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_ce_config(const struct ia_css_isp_parameters *params,
		     struct ia_css_ce_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_ce_config() enter: config=%p\n",
			    config);

	*config = params->ce_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_ce_config() leave\n");
	ia_css_ce_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_ce_config(struct ia_css_isp_parameters *params,
		     const struct ia_css_ce_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_ce_config() enter:\n");
	ia_css_ce_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->ce_config = *config;
	params->config_changed[IA_CSS_CE_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_ce_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_ecd_config(const struct ia_css_isp_parameters *params,
		      struct ia_css_ecd_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_ecd_config() enter: config=%p\n",
			    config);

	*config = params->ecd_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_ecd_config() leave\n");
	ia_css_ecd_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_ecd_config(struct ia_css_isp_parameters *params,
		      const struct ia_css_ecd_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_ecd_config() enter:\n");
	ia_css_ecd_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->ecd_config = *config;
	params->config_changed[IA_CSS_ECD_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_ecd_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_ynr_config(const struct ia_css_isp_parameters *params,
		      struct ia_css_ynr_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_ynr_config() enter: config=%p\n",
			    config);

	*config = params->ynr_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_ynr_config() leave\n");
	ia_css_ynr_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_ynr_config(struct ia_css_isp_parameters *params,
		      const struct ia_css_ynr_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_ynr_config() enter:\n");
	ia_css_ynr_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->ynr_config = *config;
	params->config_changed[IA_CSS_YNR_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_ynr_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_fc_config(const struct ia_css_isp_parameters *params,
		     struct ia_css_fc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_fc_config() enter: config=%p\n",
			    config);

	*config = params->fc_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_fc_config() leave\n");
	ia_css_fc_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_fc_config(struct ia_css_isp_parameters *params,
		     const struct ia_css_fc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_fc_config() enter:\n");
	ia_css_fc_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->fc_config = *config;
	params->config_changed[IA_CSS_FC_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_fc_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_cnr_config(const struct ia_css_isp_parameters *params,
		      struct ia_css_cnr_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_cnr_config() enter: config=%p\n",
			    config);

	*config = params->cnr_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_cnr_config() leave\n");
	ia_css_cnr_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_cnr_config(struct ia_css_isp_parameters *params,
		      const struct ia_css_cnr_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_cnr_config() enter:\n");
	ia_css_cnr_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->cnr_config = *config;
	params->config_changed[IA_CSS_CNR_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_cnr_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_macc_config(const struct ia_css_isp_parameters *params,
		       struct ia_css_macc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_macc_config() enter: config=%p\n",
			    config);

	*config = params->macc_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_macc_config() leave\n");
	ia_css_macc_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_macc_config(struct ia_css_isp_parameters *params,
		       const struct ia_css_macc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_macc_config() enter:\n");
	ia_css_macc_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->macc_config = *config;
	params->config_changed[IA_CSS_MACC_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_macc_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_ctc_config(const struct ia_css_isp_parameters *params,
		      struct ia_css_ctc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_ctc_config() enter: config=%p\n",
			    config);

	*config = params->ctc_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_ctc_config() leave\n");
	ia_css_ctc_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_ctc_config(struct ia_css_isp_parameters *params,
		      const struct ia_css_ctc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_ctc_config() enter:\n");
	ia_css_ctc_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->ctc_config = *config;
	params->config_changed[IA_CSS_CTC_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_ctc_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_aa_config(const struct ia_css_isp_parameters *params,
		     struct ia_css_aa_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_aa_config() enter: config=%p\n",
			    config);

	*config = params->aa_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_aa_config() leave\n");
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_aa_config(struct ia_css_isp_parameters *params,
		     const struct ia_css_aa_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_aa_config() enter:\n");
	params->aa_config = *config;
	params->config_changed[IA_CSS_AA_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_aa_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_yuv2rgb_config(const struct ia_css_isp_parameters *params,
			  struct ia_css_cc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_yuv2rgb_config() enter: config=%p\n",
			    config);

	*config = params->yuv2rgb_cc_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_yuv2rgb_config() leave\n");
	ia_css_yuv2rgb_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_yuv2rgb_config(struct ia_css_isp_parameters *params,
			  const struct ia_css_cc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_yuv2rgb_config() enter:\n");
	ia_css_yuv2rgb_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->yuv2rgb_cc_config = *config;
	params->config_changed[IA_CSS_YUV2RGB_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_yuv2rgb_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_rgb2yuv_config(const struct ia_css_isp_parameters *params,
			  struct ia_css_cc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_rgb2yuv_config() enter: config=%p\n",
			    config);

	*config = params->rgb2yuv_cc_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_rgb2yuv_config() leave\n");
	ia_css_rgb2yuv_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_rgb2yuv_config(struct ia_css_isp_parameters *params,
			  const struct ia_css_cc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_rgb2yuv_config() enter:\n");
	ia_css_rgb2yuv_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->rgb2yuv_cc_config = *config;
	params->config_changed[IA_CSS_RGB2YUV_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_rgb2yuv_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_csc_config(const struct ia_css_isp_parameters *params,
		      struct ia_css_cc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_csc_config() enter: config=%p\n",
			    config);

	*config = params->cc_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_csc_config() leave\n");
	ia_css_csc_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_csc_config(struct ia_css_isp_parameters *params,
		      const struct ia_css_cc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_csc_config() enter:\n");
	ia_css_csc_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->cc_config = *config;
	params->config_changed[IA_CSS_CSC_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_csc_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_nr_config(const struct ia_css_isp_parameters *params,
		     struct ia_css_nr_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_nr_config() enter: config=%p\n",
			    config);

	*config = params->nr_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_nr_config() leave\n");
	ia_css_nr_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_nr_config(struct ia_css_isp_parameters *params,
		     const struct ia_css_nr_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_nr_config() enter:\n");
	ia_css_nr_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->nr_config = *config;
	params->config_changed[IA_CSS_BNR_ID] = true;
	params->config_changed[IA_CSS_NR_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_nr_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_gc_config(const struct ia_css_isp_parameters *params,
		     struct ia_css_gc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_gc_config() enter: config=%p\n",
			    config);

	*config = params->gc_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_gc_config() leave\n");
	ia_css_gc_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_gc_config(struct ia_css_isp_parameters *params,
		     const struct ia_css_gc_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_gc_config() enter:\n");
	ia_css_gc_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->gc_config = *config;
	params->config_changed[IA_CSS_GC_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_gc_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_sdis_horicoef_config(const struct ia_css_isp_parameters *params,
				struct ia_css_dvs_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis_horicoef_config() enter: config=%p\n",
			    config);

	*config = params->dvs_coefs;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis_horicoef_config() leave\n");
	ia_css_sdis_horicoef_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_sdis_horicoef_config(struct ia_css_isp_parameters *params,
				const struct ia_css_dvs_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE,
			    "ia_css_set_sdis_horicoef_config() enter:\n");
	ia_css_sdis_horicoef_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->dvs_coefs = *config;
	params->config_changed[IA_CSS_SDIS_HORICOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS_VERTCOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS_HORIPROJ_ID] = true;
	params->config_changed[IA_CSS_SDIS_VERTPROJ_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_sdis_horicoef_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_sdis_vertcoef_config(const struct ia_css_isp_parameters *params,
				struct ia_css_dvs_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis_vertcoef_config() enter: config=%p\n",
			    config);

	*config = params->dvs_coefs;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis_vertcoef_config() leave\n");
	ia_css_sdis_vertcoef_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_sdis_vertcoef_config(struct ia_css_isp_parameters *params,
				const struct ia_css_dvs_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE,
			    "ia_css_set_sdis_vertcoef_config() enter:\n");
	ia_css_sdis_vertcoef_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->dvs_coefs = *config;
	params->config_changed[IA_CSS_SDIS_HORICOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS_VERTCOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS_HORIPROJ_ID] = true;
	params->config_changed[IA_CSS_SDIS_VERTPROJ_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_sdis_vertcoef_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_sdis_horiproj_config(const struct ia_css_isp_parameters *params,
				struct ia_css_dvs_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis_horiproj_config() enter: config=%p\n",
			    config);

	*config = params->dvs_coefs;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis_horiproj_config() leave\n");
	ia_css_sdis_horiproj_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_sdis_horiproj_config(struct ia_css_isp_parameters *params,
				const struct ia_css_dvs_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE,
			    "ia_css_set_sdis_horiproj_config() enter:\n");
	ia_css_sdis_horiproj_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->dvs_coefs = *config;
	params->config_changed[IA_CSS_SDIS_HORICOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS_VERTCOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS_HORIPROJ_ID] = true;
	params->config_changed[IA_CSS_SDIS_VERTPROJ_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_sdis_horiproj_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_sdis_vertproj_config(const struct ia_css_isp_parameters *params,
				struct ia_css_dvs_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis_vertproj_config() enter: config=%p\n",
			    config);

	*config = params->dvs_coefs;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis_vertproj_config() leave\n");
	ia_css_sdis_vertproj_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_sdis_vertproj_config(struct ia_css_isp_parameters *params,
				const struct ia_css_dvs_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE,
			    "ia_css_set_sdis_vertproj_config() enter:\n");
	ia_css_sdis_vertproj_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->dvs_coefs = *config;
	params->config_changed[IA_CSS_SDIS_HORICOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS_VERTCOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS_HORIPROJ_ID] = true;
	params->config_changed[IA_CSS_SDIS_VERTPROJ_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_sdis_vertproj_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_sdis2_horicoef_config(const struct ia_css_isp_parameters *params,
				 struct ia_css_dvs2_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis2_horicoef_config() enter: config=%p\n",
			    config);

	*config = params->dvs2_coefs;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis2_horicoef_config() leave\n");
	ia_css_sdis2_horicoef_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_sdis2_horicoef_config(struct ia_css_isp_parameters *params,
				 const struct ia_css_dvs2_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE,
			    "ia_css_set_sdis2_horicoef_config() enter:\n");
	ia_css_sdis2_horicoef_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->dvs2_coefs = *config;
	params->config_changed[IA_CSS_SDIS2_HORICOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS2_VERTCOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS2_HORIPROJ_ID] = true;
	params->config_changed[IA_CSS_SDIS2_VERTPROJ_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_sdis2_horicoef_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_sdis2_vertcoef_config(const struct ia_css_isp_parameters *params,
				 struct ia_css_dvs2_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis2_vertcoef_config() enter: config=%p\n",
			    config);

	*config = params->dvs2_coefs;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis2_vertcoef_config() leave\n");
	ia_css_sdis2_vertcoef_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_sdis2_vertcoef_config(struct ia_css_isp_parameters *params,
				 const struct ia_css_dvs2_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE,
			    "ia_css_set_sdis2_vertcoef_config() enter:\n");
	ia_css_sdis2_vertcoef_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->dvs2_coefs = *config;
	params->config_changed[IA_CSS_SDIS2_HORICOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS2_VERTCOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS2_HORIPROJ_ID] = true;
	params->config_changed[IA_CSS_SDIS2_VERTPROJ_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_sdis2_vertcoef_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_sdis2_horiproj_config(const struct ia_css_isp_parameters *params,
				 struct ia_css_dvs2_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis2_horiproj_config() enter: config=%p\n",
			    config);

	*config = params->dvs2_coefs;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis2_horiproj_config() leave\n");
	ia_css_sdis2_horiproj_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_sdis2_horiproj_config(struct ia_css_isp_parameters *params,
				 const struct ia_css_dvs2_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE,
			    "ia_css_set_sdis2_horiproj_config() enter:\n");
	ia_css_sdis2_horiproj_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->dvs2_coefs = *config;
	params->config_changed[IA_CSS_SDIS2_HORICOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS2_VERTCOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS2_HORIPROJ_ID] = true;
	params->config_changed[IA_CSS_SDIS2_VERTPROJ_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_sdis2_horiproj_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_sdis2_vertproj_config(const struct ia_css_isp_parameters *params,
				 struct ia_css_dvs2_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis2_vertproj_config() enter: config=%p\n",
			    config);

	*config = params->dvs2_coefs;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_sdis2_vertproj_config() leave\n");
	ia_css_sdis2_vertproj_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_sdis2_vertproj_config(struct ia_css_isp_parameters *params,
				 const struct ia_css_dvs2_coefficients *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE,
			    "ia_css_set_sdis2_vertproj_config() enter:\n");
	ia_css_sdis2_vertproj_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->dvs2_coefs = *config;
	params->config_changed[IA_CSS_SDIS2_HORICOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS2_VERTCOEF_ID] = true;
	params->config_changed[IA_CSS_SDIS2_HORIPROJ_ID] = true;
	params->config_changed[IA_CSS_SDIS2_VERTPROJ_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_sdis2_vertproj_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_r_gamma_config(const struct ia_css_isp_parameters *params,
			  struct ia_css_rgb_gamma_table *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_r_gamma_config() enter: config=%p\n",
			    config);

	*config = params->r_gamma_table;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_r_gamma_config() leave\n");
	ia_css_r_gamma_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_r_gamma_config(struct ia_css_isp_parameters *params,
			  const struct ia_css_rgb_gamma_table *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_r_gamma_config() enter:\n");
	ia_css_r_gamma_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->r_gamma_table = *config;
	params->config_changed[IA_CSS_R_GAMMA_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_r_gamma_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_g_gamma_config(const struct ia_css_isp_parameters *params,
			  struct ia_css_rgb_gamma_table *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_g_gamma_config() enter: config=%p\n",
			    config);

	*config = params->g_gamma_table;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_g_gamma_config() leave\n");
	ia_css_g_gamma_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_g_gamma_config(struct ia_css_isp_parameters *params,
			  const struct ia_css_rgb_gamma_table *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_g_gamma_config() enter:\n");
	ia_css_g_gamma_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->g_gamma_table = *config;
	params->config_changed[IA_CSS_G_GAMMA_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_g_gamma_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_b_gamma_config(const struct ia_css_isp_parameters *params,
			  struct ia_css_rgb_gamma_table *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_b_gamma_config() enter: config=%p\n",
			    config);

	*config = params->b_gamma_table;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_b_gamma_config() leave\n");
	ia_css_b_gamma_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_b_gamma_config(struct ia_css_isp_parameters *params,
			  const struct ia_css_rgb_gamma_table *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_b_gamma_config() enter:\n");
	ia_css_b_gamma_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->b_gamma_table = *config;
	params->config_changed[IA_CSS_B_GAMMA_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_b_gamma_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_xnr_table_config(const struct ia_css_isp_parameters *params,
			    struct ia_css_xnr_table *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_xnr_table_config() enter: config=%p\n",
			    config);

	*config = params->xnr_table;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_xnr_table_config() leave\n");
	ia_css_xnr_table_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_xnr_table_config(struct ia_css_isp_parameters *params,
			    const struct ia_css_xnr_table *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE,
			    "ia_css_set_xnr_table_config() enter:\n");
	ia_css_xnr_table_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->xnr_table = *config;
	params->config_changed[IA_CSS_XNR_TABLE_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_xnr_table_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_formats_config(const struct ia_css_isp_parameters *params,
			  struct ia_css_formats_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_formats_config() enter: config=%p\n",
			    config);

	*config = params->formats_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_formats_config() leave\n");
	ia_css_formats_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_formats_config(struct ia_css_isp_parameters *params,
			  const struct ia_css_formats_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_formats_config() enter:\n");
	ia_css_formats_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->formats_config = *config;
	params->config_changed[IA_CSS_FORMATS_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_formats_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_xnr_config(const struct ia_css_isp_parameters *params,
		      struct ia_css_xnr_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_xnr_config() enter: config=%p\n",
			    config);

	*config = params->xnr_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_xnr_config() leave\n");
	ia_css_xnr_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_xnr_config(struct ia_css_isp_parameters *params,
		      const struct ia_css_xnr_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_xnr_config() enter:\n");
	ia_css_xnr_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->xnr_config = *config;
	params->config_changed[IA_CSS_XNR_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_xnr_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_xnr3_config(const struct ia_css_isp_parameters *params,
		       struct ia_css_xnr3_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_xnr3_config() enter: config=%p\n",
			    config);

	*config = params->xnr3_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_xnr3_config() leave\n");
	ia_css_xnr3_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_xnr3_config(struct ia_css_isp_parameters *params,
		       const struct ia_css_xnr3_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_xnr3_config() enter:\n");
	ia_css_xnr3_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->xnr3_config = *config;
	params->config_changed[IA_CSS_XNR3_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_xnr3_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_s3a_config(const struct ia_css_isp_parameters *params,
		      struct ia_css_3a_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_s3a_config() enter: config=%p\n",
			    config);

	*config = params->s3a_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_s3a_config() leave\n");
	ia_css_s3a_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_s3a_config(struct ia_css_isp_parameters *params,
		      const struct ia_css_3a_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_s3a_config() enter:\n");
	ia_css_s3a_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->s3a_config = *config;
	params->config_changed[IA_CSS_BH_ID] = true;
	params->config_changed[IA_CSS_S3A_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_s3a_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_get_function() */

static void
ia_css_get_output_config(const struct ia_css_isp_parameters *params,
			 struct ia_css_output_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_output_config() enter: config=%p\n",
			    config);

	*config = params->output_config;

	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_get_output_config() leave\n");
	ia_css_output_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
}

/* Code generated by genparam/gencode.c:gen_set_function() */

void
ia_css_set_output_config(struct ia_css_isp_parameters *params,
			 const struct ia_css_output_config *config)
{
	if (!config)
		return;

	assert(params);
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE, "ia_css_set_output_config() enter:\n");
	ia_css_output_debug_dtrace(config, IA_CSS_DEBUG_TRACE);
	params->output_config = *config;
	params->config_changed[IA_CSS_OUTPUT_ID] = true;
	ia_css_debug_dtrace(IA_CSS_DEBUG_TRACE_PRIVATE,
			    "ia_css_set_output_config() leave: return_void\n");
}

/* Code generated by genparam/gencode.c:gen_global_access_function() */

void
ia_css_get_configs(struct ia_css_isp_parameters *params,
		   const struct ia_css_isp_config *config)
{
	ia_css_get_dp_config(params, config->dp_config);
	ia_css_get_wb_config(params, config->wb_config);
	ia_css_get_tnr_config(params, config->tnr_config);
	ia_css_get_ob_config(params, config->ob_config);
	ia_css_get_de_config(params, config->de_config);
	ia_css_get_anr_config(params, config->anr_config);
	ia_css_get_anr2_config(params, config->anr_thres);
	ia_css_get_ce_config(params, config->ce_config);
	ia_css_get_ecd_config(params, config->ecd_config);
	ia_css_get_ynr_config(params, config->ynr_config);
	ia_css_get_fc_config(params, config->fc_config);
	ia_css_get_cnr_config(params, config->cnr_config);
	ia_css_get_macc_config(params, config->macc_config);
	ia_css_get_ctc_config(params, config->ctc_config);
	ia_css_get_aa_config(params, config->aa_config);
	ia_css_get_yuv2rgb_config(params, config->yuv2rgb_cc_config);
	ia_css_get_rgb2yuv_config(params, config->rgb2yuv_cc_config);
	ia_css_get_csc_config(params, config->cc_config);
	ia_css_get_nr_config(params, config->nr_config);
	ia_css_get_gc_config(params, config->gc_config);
	ia_css_get_sdis_horicoef_config(params, config->dvs_coefs);
	ia_css_get_sdis_vertcoef_config(params, config->dvs_coefs);
	ia_css_get_sdis_horiproj_config(params, config->dvs_coefs);
	ia_css_get_sdis_vertproj_config(params, config->dvs_coefs);
	ia_css_get_sdis2_horicoef_config(params, config->dvs2_coefs);
	ia_css_get_sdis2_vertcoef_config(params, config->dvs2_coefs);
	ia_css_get_sdis2_horiproj_config(params, config->dvs2_coefs);
	ia_css_get_sdis2_vertproj_config(params, config->dvs2_coefs);
	ia_css_get_r_gamma_config(params, config->r_gamma_table);
	ia_css_get_g_gamma_config(params, config->g_gamma_table);
	ia_css_get_b_gamma_config(params, config->b_gamma_table);
	ia_css_get_xnr_table_config(params, config->xnr_table);
	ia_css_get_formats_config(params, config->formats_config);
	ia_css_get_xnr_config(params, config->xnr_config);
	ia_css_get_xnr3_config(params, config->xnr3_config);
	ia_css_get_s3a_config(params, config->s3a_config);
	ia_css_get_output_config(params, config->output_config);
}

/* Code generated by genparam/gencode.c:gen_global_access_function() */

void
ia_css_set_configs(struct ia_css_isp_parameters *params,
		   const struct ia_css_isp_config *config)
{
	ia_css_set_dp_config(params, config->dp_config);
	ia_css_set_wb_config(params, config->wb_config);
	ia_css_set_tnr_config(params, config->tnr_config);
	ia_css_set_ob_config(params, config->ob_config);
	ia_css_set_de_config(params, config->de_config);
	ia_css_set_anr_config(params, config->anr_config);
	ia_css_set_anr2_config(params, config->anr_thres);
	ia_css_set_ce_config(params, config->ce_config);
	ia_css_set_ecd_config(params, config->ecd_config);
	ia_css_set_ynr_config(params, config->ynr_config);
	ia_css_set_fc_config(params, config->fc_config);
	ia_css_set_cnr_config(params, config->cnr_config);
	ia_css_set_macc_config(params, config->macc_config);
	ia_css_set_ctc_config(params, config->ctc_config);
	ia_css_set_aa_config(params, config->aa_config);
	ia_css_set_yuv2rgb_config(params, config->yuv2rgb_cc_config);
	ia_css_set_rgb2yuv_config(params, config->rgb2yuv_cc_config);
	ia_css_set_csc_config(params, config->cc_config);
	ia_css_set_nr_config(params, config->nr_config);
	ia_css_set_gc_config(params, config->gc_config);
	ia_css_set_sdis_horicoef_config(params, config->dvs_coefs);
	ia_css_set_sdis_vertcoef_config(params, config->dvs_coefs);
	ia_css_set_sdis_horiproj_config(params, config->dvs_coefs);
	ia_css_set_sdis_vertproj_config(params, config->dvs_coefs);
	ia_css_set_sdis2_horicoef_config(params, config->dvs2_coefs);
	ia_css_set_sdis2_vertcoef_config(params, config->dvs2_coefs);
	ia_css_set_sdis2_horiproj_config(params, config->dvs2_coefs);
	ia_css_set_sdis2_vertproj_config(params, config->dvs2_coefs);
	ia_css_set_r_gamma_config(params, config->r_gamma_table);
	ia_css_set_g_gamma_config(params, config->g_gamma_table);
	ia_css_set_b_gamma_config(params, config->b_gamma_table);
	ia_css_set_xnr_table_config(params, config->xnr_table);
	ia_css_set_formats_config(params, config->formats_config);
	ia_css_set_xnr_config(params, config->xnr_config);
	ia_css_set_xnr3_config(params, config->xnr3_config);
	ia_css_set_s3a_config(params, config->s3a_config);
	ia_css_set_output_config(params, config->output_config);
}
