/*
 * sh73a0 processor support - PFC hardware block
 *
 * Copyright (C) 2010 Renesas Solutions Corp.
 * Copyright (C) 2010 NISHIMOTO Hiroki
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <linux/io.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/pinctrl/pinconf-generic.h>
#include <linux/regulator/driver.h>
#include <linux/regulator/machine.h>
#include <linux/slab.h>

#ifndef CONFIG_ARCH_MULTIPLATFORM
#include <mach/irqs.h>
#endif

#include "core.h"
#include "sh_pfc.h"

#define CPU_ALL_PORT(fn, pfx, sfx)					\
	PORT_10(0,  fn, pfx, sfx), PORT_90(0, fn, pfx, sfx),		\
	PORT_10(100, fn, pfx##10, sfx),					\
	PORT_1(110, fn, pfx##110, sfx), PORT_1(111, fn, pfx##111, sfx),	\
	PORT_1(112, fn, pfx##112, sfx), PORT_1(113, fn, pfx##113, sfx),	\
	PORT_1(114, fn, pfx##114, sfx), PORT_1(115, fn, pfx##115, sfx),	\
	PORT_1(116, fn, pfx##116, sfx), PORT_1(117, fn, pfx##117, sfx),	\
	PORT_1(118, fn, pfx##118, sfx),					\
	PORT_1(128, fn, pfx##128, sfx), PORT_1(129, fn, pfx##129, sfx),	\
	PORT_10(130, fn, pfx##13, sfx), PORT_10(140, fn, pfx##14, sfx),	\
	PORT_10(150, fn, pfx##15, sfx),					\
	PORT_1(160, fn, pfx##160, sfx), PORT_1(161, fn, pfx##161, sfx),	\
	PORT_1(162, fn, pfx##162, sfx), PORT_1(163, fn, pfx##163, sfx),	\
	PORT_1(164, fn, pfx##164, sfx),					\
	PORT_1(192, fn, pfx##192, sfx), PORT_1(193, fn, pfx##193, sfx),	\
	PORT_1(194, fn, pfx##194, sfx), PORT_1(195, fn, pfx##195, sfx),	\
	PORT_1(196, fn, pfx##196, sfx), PORT_1(197, fn, pfx##197, sfx),	\
	PORT_1(198, fn, pfx##198, sfx), PORT_1(199, fn, pfx##199, sfx),	\
	PORT_10(200, fn, pfx##20, sfx), PORT_10(210, fn, pfx##21, sfx),	\
	PORT_10(220, fn, pfx##22, sfx), PORT_10(230, fn, pfx##23, sfx),	\
	PORT_10(240, fn, pfx##24, sfx), PORT_10(250, fn, pfx##25, sfx),	\
	PORT_10(260, fn, pfx##26, sfx), PORT_10(270, fn, pfx##27, sfx),	\
	PORT_1(280, fn, pfx##280, sfx), PORT_1(281, fn, pfx##281, sfx),	\
	PORT_1(282, fn, pfx##282, sfx),					\
	PORT_1(288, fn, pfx##288, sfx), PORT_1(289, fn, pfx##289, sfx),	\
	PORT_10(290, fn, pfx##29, sfx), PORT_10(300, fn, pfx##30, sfx)

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	PORT_ALL(DATA),			/* PORT0_DATA -> PORT309_DATA */
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	PORT_ALL(IN),			/* PORT0_IN -> PORT309_IN */
	PINMUX_INPUT_END,

	PINMUX_OUTPUT_BEGIN,
	PORT_ALL(OUT),			/* PORT0_OUT -> PORT309_OUT */
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	PORT_ALL(FN_IN),		/* PORT0_FN_IN -> PORT309_FN_IN */
	PORT_ALL(FN_OUT),		/* PORT0_FN_OUT -> PORT309_FN_OUT */
	PORT_ALL(FN0),			/* PORT0_FN0 -> PORT309_FN0 */
	PORT_ALL(FN1),			/* PORT0_FN1 -> PORT309_FN1 */
	PORT_ALL(FN2),			/* PORT0_FN2 -> PORT309_FN2 */
	PORT_ALL(FN3),			/* PORT0_FN3 -> PORT309_FN3 */
	PORT_ALL(FN4),			/* PORT0_FN4 -> PORT309_FN4 */
	PORT_ALL(FN5),			/* PORT0_FN5 -> PORT309_FN5 */
	PORT_ALL(FN6),			/* PORT0_FN6 -> PORT309_FN6 */
	PORT_ALL(FN7),			/* PORT0_FN7 -> PORT309_FN7 */

	MSEL2CR_MSEL19_0, MSEL2CR_MSEL19_1,
	MSEL2CR_MSEL18_0, MSEL2CR_MSEL18_1,
	MSEL2CR_MSEL17_0, MSEL2CR_MSEL17_1,
	MSEL2CR_MSEL16_0, MSEL2CR_MSEL16_1,
	MSEL2CR_MSEL14_0, MSEL2CR_MSEL14_1,
	MSEL2CR_MSEL13_0, MSEL2CR_MSEL13_1,
	MSEL2CR_MSEL12_0, MSEL2CR_MSEL12_1,
	MSEL2CR_MSEL11_0, MSEL2CR_MSEL11_1,
	MSEL2CR_MSEL10_0, MSEL2CR_MSEL10_1,
	MSEL2CR_MSEL9_0, MSEL2CR_MSEL9_1,
	MSEL2CR_MSEL8_0, MSEL2CR_MSEL8_1,
	MSEL2CR_MSEL7_0, MSEL2CR_MSEL7_1,
	MSEL2CR_MSEL6_0, MSEL2CR_MSEL6_1,
	MSEL2CR_MSEL4_0, MSEL2CR_MSEL4_1,
	MSEL2CR_MSEL5_0, MSEL2CR_MSEL5_1,
	MSEL2CR_MSEL3_0, MSEL2CR_MSEL3_1,
	MSEL2CR_MSEL2_0, MSEL2CR_MSEL2_1,
	MSEL2CR_MSEL1_0, MSEL2CR_MSEL1_1,
	MSEL2CR_MSEL0_0, MSEL2CR_MSEL0_1,
	MSEL3CR_MSEL28_0, MSEL3CR_MSEL28_1,
	MSEL3CR_MSEL15_0, MSEL3CR_MSEL15_1,
	MSEL3CR_MSEL11_0, MSEL3CR_MSEL11_1,
	MSEL3CR_MSEL9_0, MSEL3CR_MSEL9_1,
	MSEL3CR_MSEL6_0, MSEL3CR_MSEL6_1,
	MSEL3CR_MSEL2_0, MSEL3CR_MSEL2_1,
	MSEL4CR_MSEL29_0, MSEL4CR_MSEL29_1,
	MSEL4CR_MSEL27_0, MSEL4CR_MSEL27_1,
	MSEL4CR_MSEL26_0, MSEL4CR_MSEL26_1,
	MSEL4CR_MSEL22_0, MSEL4CR_MSEL22_1,
	MSEL4CR_MSEL21_0, MSEL4CR_MSEL21_1,
	MSEL4CR_MSEL20_0, MSEL4CR_MSEL20_1,
	MSEL4CR_MSEL19_0, MSEL4CR_MSEL19_1,
	MSEL4CR_MSEL15_0, MSEL4CR_MSEL15_1,
	MSEL4CR_MSEL13_0, MSEL4CR_MSEL13_1,
	MSEL4CR_MSEL12_0, MSEL4CR_MSEL12_1,
	MSEL4CR_MSEL11_0, MSEL4CR_MSEL11_1,
	MSEL4CR_MSEL10_0, MSEL4CR_MSEL10_1,
	MSEL4CR_MSEL9_0, MSEL4CR_MSEL9_1,
	MSEL4CR_MSEL8_0, MSEL4CR_MSEL8_1,
	MSEL4CR_MSEL7_0, MSEL4CR_MSEL7_1,
	MSEL4CR_MSEL4_0, MSEL4CR_MSEL4_1,
	MSEL4CR_MSEL1_0, MSEL4CR_MSEL1_1,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	/* Hardware manual Table 25-1 (Function 0-7) */
	VBUS_0_MARK,
	GPI0_MARK,
	GPI1_MARK,
	GPI2_MARK,
	GPI3_MARK,
	GPI4_MARK,
	GPI5_MARK,
	GPI6_MARK,
	GPI7_MARK,
	SCIFA7_RXD_MARK,
	SCIFA7_CTS__MARK,
	GPO7_MARK, MFG0_OUT2_MARK,
	GPO6_MARK, MFG1_OUT2_MARK,
	GPO5_MARK, SCIFA0_SCK_MARK, FSICOSLDT3_MARK, PORT16_VIO_CKOR_MARK,
	SCIFA0_TXD_MARK,
	SCIFA7_TXD_MARK,
	SCIFA7_RTS__MARK, PORT19_VIO_CKO2_MARK,
	GPO0_MARK,
	GPO1_MARK,
	GPO2_MARK, STATUS0_MARK,
	GPO3_MARK, STATUS1_MARK,
	GPO4_MARK, STATUS2_MARK,
	VINT_MARK,
	TCKON_MARK,
	XDVFS1_MARK, PORT27_I2C_SCL2_MARK, PORT27_I2C_SCL3_MARK, \
	MFG0_OUT1_MARK, PORT27_IROUT_MARK,
	XDVFS2_MARK, PORT28_I2C_SDA2_MARK, PORT28_I2C_SDA3_MARK, \
	PORT28_TPU1TO1_MARK,
	SIM_RST_MARK, PORT29_TPU1TO1_MARK,
	SIM_CLK_MARK, PORT30_VIO_CKOR_MARK,
	SIM_D_MARK, PORT31_IROUT_MARK,
	SCIFA4_TXD_MARK,
	SCIFA4_RXD_MARK, XWUP_MARK,
	SCIFA4_RTS__MARK,
	SCIFA4_CTS__MARK,
	FSIBOBT_MARK, FSIBIBT_MARK,
	FSIBOLR_MARK, FSIBILR_MARK,
	FSIBOSLD_MARK,
	FSIBISLD_MARK,
	VACK_MARK,
	XTAL1L_MARK,
	SCIFA0_RTS__MARK, FSICOSLDT2_MARK,
	SCIFA0_RXD_MARK,
	SCIFA0_CTS__MARK, FSICOSLDT1_MARK,
	FSICOBT_MARK, FSICIBT_MARK, FSIDOBT_MARK, FSIDIBT_MARK,
	FSICOLR_MARK, FSICILR_MARK, FSIDOLR_MARK, FSIDILR_MARK,
	FSICOSLD_MARK, PORT47_FSICSPDIF_MARK,
	FSICISLD_MARK, FSIDISLD_MARK,
	FSIACK_MARK, PORT49_IRDA_OUT_MARK, PORT49_IROUT_MARK, FSIAOMC_MARK,
	FSIAOLR_MARK, BBIF2_TSYNC2_MARK, TPU2TO2_MARK, FSIAILR_MARK,

	FSIAOBT_MARK, BBIF2_TSCK2_MARK, TPU2TO3_MARK, FSIAIBT_MARK,
	FSIAOSLD_MARK, BBIF2_TXD2_MARK,
	FSIASPDIF_MARK, PORT53_IRDA_IN_MARK, TPU3TO3_MARK, FSIBSPDIF_MARK, \
	PORT53_FSICSPDIF_MARK,
	FSIBCK_MARK, PORT54_IRDA_FIRSEL_MARK, TPU3TO2_MARK, FSIBOMC_MARK, \
	FSICCK_MARK, FSICOMC_MARK,
	FSIAISLD_MARK, TPU0TO0_MARK,
	A0_MARK, BS__MARK,
	A12_MARK, PORT58_KEYOUT7_MARK, TPU4TO2_MARK,
	A13_MARK, PORT59_KEYOUT6_MARK, TPU0TO1_MARK,
	A14_MARK, KEYOUT5_MARK,
	A15_MARK, KEYOUT4_MARK,
	A16_MARK, KEYOUT3_MARK, MSIOF0_SS1_MARK,
	A17_MARK, KEYOUT2_MARK, MSIOF0_TSYNC_MARK,
	A18_MARK, KEYOUT1_MARK, MSIOF0_TSCK_MARK,
	A19_MARK, KEYOUT0_MARK, MSIOF0_TXD_MARK,
	A20_MARK, KEYIN0_MARK, MSIOF0_RSCK_MARK,
	A21_MARK, KEYIN1_MARK, MSIOF0_RSYNC_MARK,
	A22_MARK, KEYIN2_MARK, MSIOF0_MCK0_MARK,
	A23_MARK, KEYIN3_MARK, MSIOF0_MCK1_MARK,
	A24_MARK, KEYIN4_MARK, MSIOF0_RXD_MARK,
	A25_MARK, KEYIN5_MARK, MSIOF0_SS2_MARK,
	A26_MARK, KEYIN6_MARK,
	KEYIN7_MARK,
	D0_NAF0_MARK,
	D1_NAF1_MARK,
	D2_NAF2_MARK,
	D3_NAF3_MARK,
	D4_NAF4_MARK,
	D5_NAF5_MARK,
	D6_NAF6_MARK,
	D7_NAF7_MARK,
	D8_NAF8_MARK,
	D9_NAF9_MARK,
	D10_NAF10_MARK,
	D11_NAF11_MARK,
	D12_NAF12_MARK,
	D13_NAF13_MARK,
	D14_NAF14_MARK,
	D15_NAF15_MARK,
	CS4__MARK,
	CS5A__MARK, PORT91_RDWR_MARK,
	CS5B__MARK, FCE1__MARK,
	CS6B__MARK, DACK0_MARK,
	FCE0__MARK, CS6A__MARK,
	WAIT__MARK, DREQ0_MARK,
	RD__FSC_MARK,
	WE0__FWE_MARK, RDWR_FWE_MARK,
	WE1__MARK,
	FRB_MARK,
	CKO_MARK,
	NBRSTOUT__MARK,
	NBRST__MARK,
	BBIF2_TXD_MARK,
	BBIF2_RXD_MARK,
	BBIF2_SYNC_MARK,
	BBIF2_SCK_MARK,
	SCIFA3_CTS__MARK, MFG3_IN2_MARK,
	SCIFA3_RXD_MARK, MFG3_IN1_MARK,
	BBIF1_SS2_MARK, SCIFA3_RTS__MARK, MFG3_OUT1_MARK,
	SCIFA3_TXD_MARK,
	HSI_RX_DATA_MARK, BBIF1_RXD_MARK,
	HSI_TX_WAKE_MARK, BBIF1_TSCK_MARK,
	HSI_TX_DATA_MARK, BBIF1_TSYNC_MARK,
	HSI_TX_READY_MARK, BBIF1_TXD_MARK,
	HSI_RX_READY_MARK, BBIF1_RSCK_MARK, PORT115_I2C_SCL2_MARK, \
	PORT115_I2C_SCL3_MARK,
	HSI_RX_WAKE_MARK, BBIF1_RSYNC_MARK, PORT116_I2C_SDA2_MARK, \
	PORT116_I2C_SDA3_MARK,
	HSI_RX_FLAG_MARK, BBIF1_SS1_MARK, BBIF1_FLOW_MARK,
	HSI_TX_FLAG_MARK,
	VIO_VD_MARK, PORT128_LCD2VSYN_MARK, VIO2_VD_MARK, LCD2D0_MARK,

	VIO_HD_MARK, PORT129_LCD2HSYN_MARK, PORT129_LCD2CS__MARK, \
	VIO2_HD_MARK, LCD2D1_MARK,
	VIO_D0_MARK, PORT130_MSIOF2_RXD_MARK, LCD2D10_MARK,
	VIO_D1_MARK, PORT131_KEYOUT6_MARK, PORT131_MSIOF2_SS1_MARK, \
	PORT131_KEYOUT11_MARK, LCD2D11_MARK,
	VIO_D2_MARK, PORT132_KEYOUT7_MARK, PORT132_MSIOF2_SS2_MARK, \
	PORT132_KEYOUT10_MARK, LCD2D12_MARK,
	VIO_D3_MARK, MSIOF2_TSYNC_MARK, LCD2D13_MARK,
	VIO_D4_MARK, MSIOF2_TXD_MARK, LCD2D14_MARK,
	VIO_D5_MARK, MSIOF2_TSCK_MARK, LCD2D15_MARK,
	VIO_D6_MARK, PORT136_KEYOUT8_MARK, LCD2D16_MARK,
	VIO_D7_MARK, PORT137_KEYOUT9_MARK, LCD2D17_MARK,
	VIO_D8_MARK, PORT138_KEYOUT8_MARK, VIO2_D0_MARK, LCD2D6_MARK,
	VIO_D9_MARK, PORT139_KEYOUT9_MARK, VIO2_D1_MARK, LCD2D7_MARK,
	VIO_D10_MARK, TPU0TO2_MARK, VIO2_D2_MARK, LCD2D8_MARK,
	VIO_D11_MARK, TPU0TO3_MARK, VIO2_D3_MARK, LCD2D9_MARK,
	VIO_D12_MARK, PORT142_KEYOUT10_MARK, VIO2_D4_MARK, LCD2D2_MARK,
	VIO_D13_MARK, PORT143_KEYOUT11_MARK, PORT143_KEYOUT6_MARK, \
	VIO2_D5_MARK, LCD2D3_MARK,
	VIO_D14_MARK, PORT144_KEYOUT7_MARK, VIO2_D6_MARK, LCD2D4_MARK,
	VIO_D15_MARK, TPU1TO3_MARK, PORT145_LCD2DISP_MARK, \
	PORT145_LCD2RS_MARK, VIO2_D7_MARK, LCD2D5_MARK,
	VIO_CLK_MARK, LCD2DCK_MARK, PORT146_LCD2WR__MARK, VIO2_CLK_MARK, \
	LCD2D18_MARK,
	VIO_FIELD_MARK, LCD2RD__MARK, VIO2_FIELD_MARK, LCD2D19_MARK,
	VIO_CKO_MARK,
	A27_MARK, PORT149_RDWR_MARK, MFG0_IN1_MARK, PORT149_KEYOUT9_MARK,
	MFG0_IN2_MARK,
	TS_SPSYNC3_MARK, MSIOF2_RSCK_MARK,
	TS_SDAT3_MARK, MSIOF2_RSYNC_MARK,
	TPU1TO2_MARK, TS_SDEN3_MARK, PORT153_MSIOF2_SS1_MARK,
	SCIFA2_TXD1_MARK, MSIOF2_MCK0_MARK,
	SCIFA2_RXD1_MARK, MSIOF2_MCK1_MARK,
	SCIFA2_RTS1__MARK, PORT156_MSIOF2_SS2_MARK,
	SCIFA2_CTS1__MARK, PORT157_MSIOF2_RXD_MARK,
	DINT__MARK, SCIFA2_SCK1_MARK, TS_SCK3_MARK,
	PORT159_SCIFB_SCK_MARK, PORT159_SCIFA5_SCK_MARK, NMI_MARK,
	PORT160_SCIFB_TXD_MARK, PORT160_SCIFA5_TXD_MARK,
	PORT161_SCIFB_CTS__MARK, PORT161_SCIFA5_CTS__MARK,
	PORT162_SCIFB_RXD_MARK, PORT162_SCIFA5_RXD_MARK,
	PORT163_SCIFB_RTS__MARK, PORT163_SCIFA5_RTS__MARK, TPU3TO0_MARK,
	LCDD0_MARK,
	LCDD1_MARK, PORT193_SCIFA5_CTS__MARK, BBIF2_TSYNC1_MARK,
	LCDD2_MARK, PORT194_SCIFA5_RTS__MARK, BBIF2_TSCK1_MARK,
	LCDD3_MARK, PORT195_SCIFA5_RXD_MARK, BBIF2_TXD1_MARK,
	LCDD4_MARK, PORT196_SCIFA5_TXD_MARK,
	LCDD5_MARK, PORT197_SCIFA5_SCK_MARK, MFG2_OUT2_MARK, TPU2TO1_MARK,
	LCDD6_MARK,
	LCDD7_MARK, TPU4TO1_MARK, MFG4_OUT2_MARK,
	LCDD8_MARK, D16_MARK,
	LCDD9_MARK, D17_MARK,
	LCDD10_MARK, D18_MARK,
	LCDD11_MARK, D19_MARK,
	LCDD12_MARK, D20_MARK,
	LCDD13_MARK, D21_MARK,
	LCDD14_MARK, D22_MARK,
	LCDD15_MARK, PORT207_MSIOF0L_SS1_MARK, D23_MARK,
	LCDD16_MARK, PORT208_MSIOF0L_SS2_MARK, D24_MARK,
	LCDD17_MARK, D25_MARK,
	LCDD18_MARK, DREQ2_MARK, PORT210_MSIOF0L_SS1_MARK, D26_MARK,
	LCDD19_MARK, PORT211_MSIOF0L_SS2_MARK, D27_MARK,
	LCDD20_MARK, TS_SPSYNC1_MARK, MSIOF0L_MCK0_MARK, D28_MARK,
	LCDD21_MARK, TS_SDAT1_MARK, MSIOF0L_MCK1_MARK, D29_MARK,
	LCDD22_MARK, TS_SDEN1_MARK, MSIOF0L_RSCK_MARK, D30_MARK,
	LCDD23_MARK, TS_SCK1_MARK, MSIOF0L_RSYNC_MARK, D31_MARK,
	LCDDCK_MARK, LCDWR__MARK,
	LCDRD__MARK, DACK2_MARK, PORT217_LCD2RS_MARK, MSIOF0L_TSYNC_MARK, \
	VIO2_FIELD3_MARK, PORT217_LCD2DISP_MARK,
	LCDHSYN_MARK, LCDCS__MARK, LCDCS2__MARK, DACK3_MARK, \
	PORT218_VIO_CKOR_MARK,
	LCDDISP_MARK, LCDRS_MARK, PORT219_LCD2WR__MARK, DREQ3_MARK, \
	MSIOF0L_TSCK_MARK, VIO2_CLK3_MARK, LCD2DCK_2_MARK,
	LCDVSYN_MARK, LCDVSYN2_MARK,
	LCDLCLK_MARK, DREQ1_MARK, PORT221_LCD2CS__MARK, PWEN_MARK, \
	MSIOF0L_RXD_MARK, VIO2_HD3_MARK, PORT221_LCD2HSYN_MARK,
	LCDDON_MARK, LCDDON2_MARK, DACK1_MARK, OVCN_MARK, MSIOF0L_TXD_MARK, \
	VIO2_VD3_MARK, PORT222_LCD2VSYN_MARK,

	SCIFA1_TXD_MARK, OVCN2_MARK,
	EXTLP_MARK, SCIFA1_SCK_MARK, PORT226_VIO_CKO2_MARK,
	SCIFA1_RTS__MARK, IDIN_MARK,
	SCIFA1_RXD_MARK,
	SCIFA1_CTS__MARK, MFG1_IN1_MARK,
	MSIOF1_TXD_MARK, SCIFA2_TXD2_MARK,
	MSIOF1_TSYNC_MARK, SCIFA2_CTS2__MARK,
	MSIOF1_TSCK_MARK, SCIFA2_SCK2_MARK,
	MSIOF1_RXD_MARK, SCIFA2_RXD2_MARK,
	MSIOF1_RSCK_MARK, SCIFA2_RTS2__MARK, VIO2_CLK2_MARK, LCD2D20_MARK,
	MSIOF1_RSYNC_MARK, MFG1_IN2_MARK, VIO2_VD2_MARK, LCD2D21_MARK,
	MSIOF1_MCK0_MARK, PORT236_I2C_SDA2_MARK,
	MSIOF1_MCK1_MARK, PORT237_I2C_SCL2_MARK,
	MSIOF1_SS1_MARK, VIO2_FIELD2_MARK, LCD2D22_MARK,
	MSIOF1_SS2_MARK, VIO2_HD2_MARK, LCD2D23_MARK,
	SCIFA6_TXD_MARK,
	PORT241_IRDA_OUT_MARK, PORT241_IROUT_MARK, MFG4_OUT1_MARK, TPU4TO0_MARK,
	PORT242_IRDA_IN_MARK, MFG4_IN2_MARK,
	PORT243_IRDA_FIRSEL_MARK, PORT243_VIO_CKO2_MARK,
	PORT244_SCIFA5_CTS__MARK, MFG2_IN1_MARK, PORT244_SCIFB_CTS__MARK, \
	MSIOF2R_RXD_MARK,
	PORT245_SCIFA5_RTS__MARK, MFG2_IN2_MARK, PORT245_SCIFB_RTS__MARK, \
	MSIOF2R_TXD_MARK,
	PORT246_SCIFA5_RXD_MARK, MFG1_OUT1_MARK, PORT246_SCIFB_RXD_MARK, \
	TPU1TO0_MARK,
	PORT247_SCIFA5_TXD_MARK, MFG3_OUT2_MARK, PORT247_SCIFB_TXD_MARK, \
	TPU3TO1_MARK,
	PORT248_SCIFA5_SCK_MARK, MFG2_OUT1_MARK, PORT248_SCIFB_SCK_MARK, \
	TPU2TO0_MARK, PORT248_I2C_SCL3_MARK, MSIOF2R_TSCK_MARK,
	PORT249_IROUT_MARK, MFG4_IN1_MARK, PORT249_I2C_SDA3_MARK, \
	MSIOF2R_TSYNC_MARK,
	SDHICLK0_MARK,
	SDHICD0_MARK,
	SDHID0_0_MARK,
	SDHID0_1_MARK,
	SDHID0_2_MARK,
	SDHID0_3_MARK,
	SDHICMD0_MARK,
	SDHIWP0_MARK,
	SDHICLK1_MARK,
	SDHID1_0_MARK, TS_SPSYNC2_MARK,
	SDHID1_1_MARK, TS_SDAT2_MARK,
	SDHID1_2_MARK, TS_SDEN2_MARK,
	SDHID1_3_MARK, TS_SCK2_MARK,
	SDHICMD1_MARK,
	SDHICLK2_MARK,
	SDHID2_0_MARK, TS_SPSYNC4_MARK,
	SDHID2_1_MARK, TS_SDAT4_MARK,
	SDHID2_2_MARK, TS_SDEN4_MARK,
	SDHID2_3_MARK, TS_SCK4_MARK,
	SDHICMD2_MARK,
	MMCCLK0_MARK,
	MMCD0_0_MARK,
	MMCD0_1_MARK,
	MMCD0_2_MARK,
	MMCD0_3_MARK,
	MMCD0_4_MARK, TS_SPSYNC5_MARK,
	MMCD0_5_MARK, TS_SDAT5_MARK,
	MMCD0_6_MARK, TS_SDEN5_MARK,
	MMCD0_7_MARK, TS_SCK5_MARK,
	MMCCMD0_MARK,
	RESETOUTS__MARK, EXTAL2OUT_MARK,
	MCP_WAIT__MCP_FRB_MARK,
	MCP_CKO_MARK, MMCCLK1_MARK,
	MCP_D15_MCP_NAF15_MARK,
	MCP_D14_MCP_NAF14_MARK,
	MCP_D13_MCP_NAF13_MARK,
	MCP_D12_MCP_NAF12_MARK,
	MCP_D11_MCP_NAF11_MARK,
	MCP_D10_MCP_NAF10_MARK,
	MCP_D9_MCP_NAF9_MARK,
	MCP_D8_MCP_NAF8_MARK, MMCCMD1_MARK,
	MCP_D7_MCP_NAF7_MARK, MMCD1_7_MARK,

	MCP_D6_MCP_NAF6_MARK, MMCD1_6_MARK,
	MCP_D5_MCP_NAF5_MARK, MMCD1_5_MARK,
	MCP_D4_MCP_NAF4_MARK, MMCD1_4_MARK,
	MCP_D3_MCP_NAF3_MARK, MMCD1_3_MARK,
	MCP_D2_MCP_NAF2_MARK, MMCD1_2_MARK,
	MCP_D1_MCP_NAF1_MARK, MMCD1_1_MARK,
	MCP_D0_MCP_NAF0_MARK, MMCD1_0_MARK,
	MCP_NBRSTOUT__MARK,
	MCP_WE0__MCP_FWE_MARK, MCP_RDWR_MCP_FWE_MARK,

	/* MSEL2 special cases */
	TSIF2_TS_XX1_MARK,
	TSIF2_TS_XX2_MARK,
	TSIF2_TS_XX3_MARK,
	TSIF2_TS_XX4_MARK,
	TSIF2_TS_XX5_MARK,
	TSIF1_TS_XX1_MARK,
	TSIF1_TS_XX2_MARK,
	TSIF1_TS_XX3_MARK,
	TSIF1_TS_XX4_MARK,
	TSIF1_TS_XX5_MARK,
	TSIF0_TS_XX1_MARK,
	TSIF0_TS_XX2_MARK,
	TSIF0_TS_XX3_MARK,
	TSIF0_TS_XX4_MARK,
	TSIF0_TS_XX5_MARK,
	MST1_TS_XX1_MARK,
	MST1_TS_XX2_MARK,
	MST1_TS_XX3_MARK,
	MST1_TS_XX4_MARK,
	MST1_TS_XX5_MARK,
	MST0_TS_XX1_MARK,
	MST0_TS_XX2_MARK,
	MST0_TS_XX3_MARK,
	MST0_TS_XX4_MARK,
	MST0_TS_XX5_MARK,

	/* MSEL3 special cases */
	SDHI0_VCCQ_MC0_ON_MARK,
	SDHI0_VCCQ_MC0_OFF_MARK,
	DEBUG_MON_VIO_MARK,
	DEBUG_MON_LCDD_MARK,
	LCDC_LCDC0_MARK,
	LCDC_LCDC1_MARK,

	/* MSEL4 special cases */
	IRQ9_MEM_INT_MARK,
	IRQ9_MCP_INT_MARK,
	A11_MARK,
	KEYOUT8_MARK,
	TPU4TO3_MARK,
	RESETA_N_PU_ON_MARK,
	RESETA_N_PU_OFF_MARK,
	EDBGREQ_PD_MARK,
	EDBGREQ_PU_MARK,

	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	/* specify valid pin states for each pin in GPIO mode */
	PINMUX_DATA_ALL(),

	/* Table 25-1 (Function 0-7) */
	PINMUX_DATA(VBUS_0_MARK, PORT0_FN1),
	PINMUX_DATA(GPI0_MARK, PORT1_FN1),
	PINMUX_DATA(GPI1_MARK, PORT2_FN1),
	PINMUX_DATA(GPI2_MARK, PORT3_FN1),
	PINMUX_DATA(GPI3_MARK, PORT4_FN1),
	PINMUX_DATA(GPI4_MARK, PORT5_FN1),
	PINMUX_DATA(GPI5_MARK, PORT6_FN1),
	PINMUX_DATA(GPI6_MARK, PORT7_FN1),
	PINMUX_DATA(GPI7_MARK, PORT8_FN1),
	PINMUX_DATA(SCIFA7_RXD_MARK, PORT12_FN2),
	PINMUX_DATA(SCIFA7_CTS__MARK, PORT13_FN2),
	PINMUX_DATA(GPO7_MARK, PORT14_FN1), \
	PINMUX_DATA(MFG0_OUT2_MARK, PORT14_FN4),
	PINMUX_DATA(GPO6_MARK, PORT15_FN1), \
	PINMUX_DATA(MFG1_OUT2_MARK, PORT15_FN4),
	PINMUX_DATA(GPO5_MARK, PORT16_FN1), \
	PINMUX_DATA(SCIFA0_SCK_MARK, PORT16_FN2), \
	PINMUX_DATA(FSICOSLDT3_MARK, PORT16_FN3), \
	PINMUX_DATA(PORT16_VIO_CKOR_MARK, PORT16_FN4),
	PINMUX_DATA(SCIFA0_TXD_MARK, PORT17_FN2),
	PINMUX_DATA(SCIFA7_TXD_MARK, PORT18_FN2),
	PINMUX_DATA(SCIFA7_RTS__MARK, PORT19_FN2), \
	PINMUX_DATA(PORT19_VIO_CKO2_MARK, PORT19_FN3),
	PINMUX_DATA(GPO0_MARK, PORT20_FN1),
	PINMUX_DATA(GPO1_MARK, PORT21_FN1),
	PINMUX_DATA(GPO2_MARK, PORT22_FN1), \
	PINMUX_DATA(STATUS0_MARK, PORT22_FN2),
	PINMUX_DATA(GPO3_MARK, PORT23_FN1), \
	PINMUX_DATA(STATUS1_MARK, PORT23_FN2),
	PINMUX_DATA(GPO4_MARK, PORT24_FN1), \
	PINMUX_DATA(STATUS2_MARK, PORT24_FN2),
	PINMUX_DATA(VINT_MARK, PORT25_FN1),
	PINMUX_DATA(TCKON_MARK, PORT26_FN1),
	PINMUX_DATA(XDVFS1_MARK, PORT27_FN1), \
	PINMUX_DATA(PORT27_I2C_SCL2_MARK, PORT27_FN2, MSEL2CR_MSEL17_0,
		MSEL2CR_MSEL16_1), \
	PINMUX_DATA(PORT27_I2C_SCL3_MARK, PORT27_FN3, MSEL2CR_MSEL19_0,
		MSEL2CR_MSEL18_1), \
	PINMUX_DATA(MFG0_OUT1_MARK, PORT27_FN4), \
	PINMUX_DATA(PORT27_IROUT_MARK, PORT27_FN7),
	PINMUX_DATA(XDVFS2_MARK, PORT28_FN1), \
	PINMUX_DATA(PORT28_I2C_SDA2_MARK, PORT28_FN2, MSEL2CR_MSEL17_0,
		MSEL2CR_MSEL16_1), \
	PINMUX_DATA(PORT28_I2C_SDA3_MARK, PORT28_FN3, MSEL2CR_MSEL19_0,
		MSEL2CR_MSEL18_1), \
	PINMUX_DATA(PORT28_TPU1TO1_MARK, PORT28_FN7),
	PINMUX_DATA(SIM_RST_MARK, PORT29_FN1), \
	PINMUX_DATA(PORT29_TPU1TO1_MARK, PORT29_FN4),
	PINMUX_DATA(SIM_CLK_MARK, PORT30_FN1), \
	PINMUX_DATA(PORT30_VIO_CKOR_MARK, PORT30_FN4),
	PINMUX_DATA(SIM_D_MARK, PORT31_FN1), \
	PINMUX_DATA(PORT31_IROUT_MARK, PORT31_FN4),
	PINMUX_DATA(SCIFA4_TXD_MARK, PORT32_FN2),
	PINMUX_DATA(SCIFA4_RXD_MARK, PORT33_FN2), \
	PINMUX_DATA(XWUP_MARK, PORT33_FN3),
	PINMUX_DATA(SCIFA4_RTS__MARK, PORT34_FN2),
	PINMUX_DATA(SCIFA4_CTS__MARK, PORT35_FN2),
	PINMUX_DATA(FSIBOBT_MARK, PORT36_FN1), \
	PINMUX_DATA(FSIBIBT_MARK, PORT36_FN2),
	PINMUX_DATA(FSIBOLR_MARK, PORT37_FN1), \
	PINMUX_DATA(FSIBILR_MARK, PORT37_FN2),
	PINMUX_DATA(FSIBOSLD_MARK, PORT38_FN1),
	PINMUX_DATA(FSIBISLD_MARK, PORT39_FN1),
	PINMUX_DATA(VACK_MARK, PORT40_FN1),
	PINMUX_DATA(XTAL1L_MARK, PORT41_FN1),
	PINMUX_DATA(SCIFA0_RTS__MARK, PORT42_FN2), \
	PINMUX_DATA(FSICOSLDT2_MARK, PORT42_FN3),
	PINMUX_DATA(SCIFA0_RXD_MARK, PORT43_FN2),
	PINMUX_DATA(SCIFA0_CTS__MARK, PORT44_FN2), \
	PINMUX_DATA(FSICOSLDT1_MARK, PORT44_FN3),
	PINMUX_DATA(FSICOBT_MARK, PORT45_FN1), \
	PINMUX_DATA(FSICIBT_MARK, PORT45_FN2), \
	PINMUX_DATA(FSIDOBT_MARK, PORT45_FN3), \
	PINMUX_DATA(FSIDIBT_MARK, PORT45_FN4),
	PINMUX_DATA(FSICOLR_MARK, PORT46_FN1), \
	PINMUX_DATA(FSICILR_MARK, PORT46_FN2), \
	PINMUX_DATA(FSIDOLR_MARK, PORT46_FN3), \
	PINMUX_DATA(FSIDILR_MARK, PORT46_FN4),
	PINMUX_DATA(FSICOSLD_MARK, PORT47_FN1), \
	PINMUX_DATA(PORT47_FSICSPDIF_MARK, PORT47_FN2),
	PINMUX_DATA(FSICISLD_MARK, PORT48_FN1), \
	PINMUX_DATA(FSIDISLD_MARK, PORT48_FN3),
	PINMUX_DATA(FSIACK_MARK, PORT49_FN1), \
	PINMUX_DATA(PORT49_IRDA_OUT_MARK, PORT49_FN2, MSEL4CR_MSEL19_1), \
	PINMUX_DATA(PORT49_IROUT_MARK, PORT49_FN4), \
	PINMUX_DATA(FSIAOMC_MARK, PORT49_FN5),
	PINMUX_DATA(FSIAOLR_MARK, PORT50_FN1), \
	PINMUX_DATA(BBIF2_TSYNC2_MARK, PORT50_FN2), \
	PINMUX_DATA(TPU2TO2_MARK, PORT50_FN3), \
	PINMUX_DATA(FSIAILR_MARK, PORT50_FN5),

	PINMUX_DATA(FSIAOBT_MARK, PORT51_FN1), \
	PINMUX_DATA(BBIF2_TSCK2_MARK, PORT51_FN2), \
	PINMUX_DATA(TPU2TO3_MARK, PORT51_FN3), \
	PINMUX_DATA(FSIAIBT_MARK, PORT51_FN5),
	PINMUX_DATA(FSIAOSLD_MARK, PORT52_FN1), \
	PINMUX_DATA(BBIF2_TXD2_MARK, PORT52_FN2),
	PINMUX_DATA(FSIASPDIF_MARK, PORT53_FN1), \
	PINMUX_DATA(PORT53_IRDA_IN_MARK, PORT53_FN2, MSEL4CR_MSEL19_1), \
	PINMUX_DATA(TPU3TO3_MARK, PORT53_FN3), \
	PINMUX_DATA(FSIBSPDIF_MARK, PORT53_FN5), \
	PINMUX_DATA(PORT53_FSICSPDIF_MARK, PORT53_FN6),
	PINMUX_DATA(FSIBCK_MARK, PORT54_FN1), \
	PINMUX_DATA(PORT54_IRDA_FIRSEL_MARK, PORT54_FN2, MSEL4CR_MSEL19_1), \
	PINMUX_DATA(TPU3TO2_MARK, PORT54_FN3), \
	PINMUX_DATA(FSIBOMC_MARK, PORT54_FN5), \
	PINMUX_DATA(FSICCK_MARK, PORT54_FN6), \
	PINMUX_DATA(FSICOMC_MARK, PORT54_FN7),
	PINMUX_DATA(FSIAISLD_MARK, PORT55_FN1), \
	PINMUX_DATA(TPU0TO0_MARK, PORT55_FN3),
	PINMUX_DATA(A0_MARK, PORT57_FN1), \
	PINMUX_DATA(BS__MARK, PORT57_FN2),
	PINMUX_DATA(A12_MARK, PORT58_FN1), \
	PINMUX_DATA(PORT58_KEYOUT7_MARK, PORT58_FN2), \
	PINMUX_DATA(TPU4TO2_MARK, PORT58_FN4),
	PINMUX_DATA(A13_MARK, PORT59_FN1), \
	PINMUX_DATA(PORT59_KEYOUT6_MARK, PORT59_FN2), \
	PINMUX_DATA(TPU0TO1_MARK, PORT59_FN4),
	PINMUX_DATA(A14_MARK, PORT60_FN1), \
	PINMUX_DATA(KEYOUT5_MARK, PORT60_FN2),
	PINMUX_DATA(A15_MARK, PORT61_FN1), \
	PINMUX_DATA(KEYOUT4_MARK, PORT61_FN2),
	PINMUX_DATA(A16_MARK, PORT62_FN1), \
	PINMUX_DATA(KEYOUT3_MARK, PORT62_FN2), \
	PINMUX_DATA(MSIOF0_SS1_MARK, PORT62_FN4, MSEL3CR_MSEL11_0),
	PINMUX_DATA(A17_MARK, PORT63_FN1), \
	PINMUX_DATA(KEYOUT2_MARK, PORT63_FN2), \
	PINMUX_DATA(MSIOF0_TSYNC_MARK, PORT63_FN4, MSEL3CR_MSEL11_0),
	PINMUX_DATA(A18_MARK, PORT64_FN1), \
	PINMUX_DATA(KEYOUT1_MARK, PORT64_FN2), \
	PINMUX_DATA(MSIOF0_TSCK_MARK, PORT64_FN4, MSEL3CR_MSEL11_0),
	PINMUX_DATA(A19_MARK, PORT65_FN1), \
	PINMUX_DATA(KEYOUT0_MARK, PORT65_FN2), \
	PINMUX_DATA(MSIOF0_TXD_MARK, PORT65_FN4, MSEL3CR_MSEL11_0),
	PINMUX_DATA(A20_MARK, PORT66_FN1), \
	PINMUX_DATA(KEYIN0_MARK, PORT66_FN2), \
	PINMUX_DATA(MSIOF0_RSCK_MARK, PORT66_FN4, MSEL3CR_MSEL11_0),
	PINMUX_DATA(A21_MARK, PORT67_FN1), \
	PINMUX_DATA(KEYIN1_MARK, PORT67_FN2), \
	PINMUX_DATA(MSIOF0_RSYNC_MARK, PORT67_FN4, MSEL3CR_MSEL11_0),
	PINMUX_DATA(A22_MARK, PORT68_FN1), \
	PINMUX_DATA(KEYIN2_MARK, PORT68_FN2), \
	PINMUX_DATA(MSIOF0_MCK0_MARK, PORT68_FN4, MSEL3CR_MSEL11_0),
	PINMUX_DATA(A23_MARK, PORT69_FN1), \
	PINMUX_DATA(KEYIN3_MARK, PORT69_FN2), \
	PINMUX_DATA(MSIOF0_MCK1_MARK, PORT69_FN4, MSEL3CR_MSEL11_0),
	PINMUX_DATA(A24_MARK, PORT70_FN1), \
	PINMUX_DATA(KEYIN4_MARK, PORT70_FN2), \
	PINMUX_DATA(MSIOF0_RXD_MARK, PORT70_FN4, MSEL3CR_MSEL11_0),
	PINMUX_DATA(A25_MARK, PORT71_FN1), \
	PINMUX_DATA(KEYIN5_MARK, PORT71_FN2), \
	PINMUX_DATA(MSIOF0_SS2_MARK, PORT71_FN4, MSEL3CR_MSEL11_0),
	PINMUX_DATA(A26_MARK, PORT72_FN1), \
	PINMUX_DATA(KEYIN6_MARK, PORT72_FN2),
	PINMUX_DATA(KEYIN7_MARK, PORT73_FN2),
	PINMUX_DATA(D0_NAF0_MARK, PORT74_FN1),
	PINMUX_DATA(D1_NAF1_MARK, PORT75_FN1),
	PINMUX_DATA(D2_NAF2_MARK, PORT76_FN1),
	PINMUX_DATA(D3_NAF3_MARK, PORT77_FN1),
	PINMUX_DATA(D4_NAF4_MARK, PORT78_FN1),
	PINMUX_DATA(D5_NAF5_MARK, PORT79_FN1),
	PINMUX_DATA(D6_NAF6_MARK, PORT80_FN1),
	PINMUX_DATA(D7_NAF7_MARK, PORT81_FN1),
	PINMUX_DATA(D8_NAF8_MARK, PORT82_FN1),
	PINMUX_DATA(D9_NAF9_MARK, PORT83_FN1),
	PINMUX_DATA(D10_NAF10_MARK, PORT84_FN1),
	PINMUX_DATA(D11_NAF11_MARK, PORT85_FN1),
	PINMUX_DATA(D12_NAF12_MARK, PORT86_FN1),
	PINMUX_DATA(D13_NAF13_MARK, PORT87_FN1),
	PINMUX_DATA(D14_NAF14_MARK, PORT88_FN1),
	PINMUX_DATA(D15_NAF15_MARK, PORT89_FN1),
	PINMUX_DATA(CS4__MARK, PORT90_FN1),
	PINMUX_DATA(CS5A__MARK, PORT91_FN1), \
	PINMUX_DATA(PORT91_RDWR_MARK, PORT91_FN2),
	PINMUX_DATA(CS5B__MARK, PORT92_FN1), \
	PINMUX_DATA(FCE1__MARK, PORT92_FN2),
	PINMUX_DATA(CS6B__MARK, PORT93_FN1), \
	PINMUX_DATA(DACK0_MARK, PORT93_FN4),
	PINMUX_DATA(FCE0__MARK, PORT94_FN1), \
	PINMUX_DATA(CS6A__MARK, PORT94_FN2),
	PINMUX_DATA(WAIT__MARK, PORT95_FN1), \
	PINMUX_DATA(DREQ0_MARK, PORT95_FN2),
	PINMUX_DATA(RD__FSC_MARK, PORT96_FN1),
	PINMUX_DATA(WE0__FWE_MARK, PORT97_FN1), \
	PINMUX_DATA(RDWR_FWE_MARK, PORT97_FN2),
	PINMUX_DATA(WE1__MARK, PORT98_FN1),
	PINMUX_DATA(FRB_MARK, PORT99_FN1),
	PINMUX_DATA(CKO_MARK, PORT100_FN1),
	PINMUX_DATA(NBRSTOUT__MARK, PORT101_FN1),
	PINMUX_DATA(NBRST__MARK, PORT102_FN1),
	PINMUX_DATA(BBIF2_TXD_MARK, PORT103_FN3),
	PINMUX_DATA(BBIF2_RXD_MARK, PORT104_FN3),
	PINMUX_DATA(BBIF2_SYNC_MARK, PORT105_FN3),
	PINMUX_DATA(BBIF2_SCK_MARK, PORT106_FN3),
	PINMUX_DATA(SCIFA3_CTS__MARK, PORT107_FN3), \
	PINMUX_DATA(MFG3_IN2_MARK, PORT107_FN4),
	PINMUX_DATA(SCIFA3_RXD_MARK, PORT108_FN3), \
	PINMUX_DATA(MFG3_IN1_MARK, PORT108_FN4),
	PINMUX_DATA(BBIF1_SS2_MARK, PORT109_FN2), \
	PINMUX_DATA(SCIFA3_RTS__MARK, PORT109_FN3), \
	PINMUX_DATA(MFG3_OUT1_MARK, PORT109_FN4),
	PINMUX_DATA(SCIFA3_TXD_MARK, PORT110_FN3),
	PINMUX_DATA(HSI_RX_DATA_MARK, PORT111_FN1), \
	PINMUX_DATA(BBIF1_RXD_MARK, PORT111_FN3),
	PINMUX_DATA(HSI_TX_WAKE_MARK, PORT112_FN1), \
	PINMUX_DATA(BBIF1_TSCK_MARK, PORT112_FN3),
	PINMUX_DATA(HSI_TX_DATA_MARK, PORT113_FN1), \
	PINMUX_DATA(BBIF1_TSYNC_MARK, PORT113_FN3),
	PINMUX_DATA(HSI_TX_READY_MARK, PORT114_FN1), \
	PINMUX_DATA(BBIF1_TXD_MARK, PORT114_FN3),
	PINMUX_DATA(HSI_RX_READY_MARK, PORT115_FN1), \
	PINMUX_DATA(BBIF1_RSCK_MARK, PORT115_FN3), \
	PINMUX_DATA(PORT115_I2C_SCL2_MARK, PORT115_FN5, MSEL2CR_MSEL17_1), \
	PINMUX_DATA(PORT115_I2C_SCL3_MARK, PORT115_FN6, MSEL2CR_MSEL19_1),
	PINMUX_DATA(HSI_RX_WAKE_MARK, PORT116_FN1), \
	PINMUX_DATA(BBIF1_RSYNC_MARK, PORT116_FN3), \
	PINMUX_DATA(PORT116_I2C_SDA2_MARK, PORT116_FN5, MSEL2CR_MSEL17_1), \
	PINMUX_DATA(PORT116_I2C_SDA3_MARK, PORT116_FN6, MSEL2CR_MSEL19_1),
	PINMUX_DATA(HSI_RX_FLAG_MARK, PORT117_FN1), \
	PINMUX_DATA(BBIF1_SS1_MARK, PORT117_FN2), \
	PINMUX_DATA(BBIF1_FLOW_MARK, PORT117_FN3),
	PINMUX_DATA(HSI_TX_FLAG_MARK, PORT118_FN1),
	PINMUX_DATA(VIO_VD_MARK, PORT128_FN1), \
	PINMUX_DATA(PORT128_LCD2VSYN_MARK, PORT128_FN4, MSEL3CR_MSEL2_0), \
	PINMUX_DATA(VIO2_VD_MARK, PORT128_FN6, MSEL4CR_MSEL27_0), \
	PINMUX_DATA(LCD2D0_MARK, PORT128_FN7),

	PINMUX_DATA(VIO_HD_MARK, PORT129_FN1), \
	PINMUX_DATA(PORT129_LCD2HSYN_MARK, PORT129_FN4), \
	PINMUX_DATA(PORT129_LCD2CS__MARK, PORT129_FN5), \
	PINMUX_DATA(VIO2_HD_MARK, PORT129_FN6, MSEL4CR_MSEL27_0), \
	PINMUX_DATA(LCD2D1_MARK, PORT129_FN7),
	PINMUX_DATA(VIO_D0_MARK, PORT130_FN1), \
	PINMUX_DATA(PORT130_MSIOF2_RXD_MARK, PORT130_FN3, MSEL4CR_MSEL11_0,
		MSEL4CR_MSEL10_1), \
	PINMUX_DATA(LCD2D10_MARK, PORT130_FN7),
	PINMUX_DATA(VIO_D1_MARK, PORT131_FN1), \
	PINMUX_DATA(PORT131_KEYOUT6_MARK, PORT131_FN2), \
	PINMUX_DATA(PORT131_MSIOF2_SS1_MARK, PORT131_FN3), \
	PINMUX_DATA(PORT131_KEYOUT11_MARK, PORT131_FN4), \
	PINMUX_DATA(LCD2D11_MARK, PORT131_FN7),
	PINMUX_DATA(VIO_D2_MARK, PORT132_FN1), \
	PINMUX_DATA(PORT132_KEYOUT7_MARK, PORT132_FN2), \
	PINMUX_DATA(PORT132_MSIOF2_SS2_MARK, PORT132_FN3), \
	PINMUX_DATA(PORT132_KEYOUT10_MARK, PORT132_FN4), \
	PINMUX_DATA(LCD2D12_MARK, PORT132_FN7),
	PINMUX_DATA(VIO_D3_MARK, PORT133_FN1), \
	PINMUX_DATA(MSIOF2_TSYNC_MARK, PORT133_FN3, MSEL4CR_MSEL11_0), \
	PINMUX_DATA(LCD2D13_MARK, PORT133_FN7),
	PINMUX_DATA(VIO_D4_MARK, PORT134_FN1), \
	PINMUX_DATA(MSIOF2_TXD_MARK, PORT134_FN3, MSEL4CR_MSEL11_0), \
	PINMUX_DATA(LCD2D14_MARK, PORT134_FN7),
	PINMUX_DATA(VIO_D5_MARK, PORT135_FN1), \
	PINMUX_DATA(MSIOF2_TSCK_MARK, PORT135_FN3, MSEL4CR_MSEL11_0), \
	PINMUX_DATA(LCD2D15_MARK, PORT135_FN7),
	PINMUX_DATA(VIO_D6_MARK, PORT136_FN1), \
	PINMUX_DATA(PORT136_KEYOUT8_MARK, PORT136_FN2), \
	PINMUX_DATA(LCD2D16_MARK, PORT136_FN7),
	PINMUX_DATA(VIO_D7_MARK, PORT137_FN1), \
	PINMUX_DATA(PORT137_KEYOUT9_MARK, PORT137_FN2), \
	PINMUX_DATA(LCD2D17_MARK, PORT137_FN7),
	PINMUX_DATA(VIO_D8_MARK, PORT138_FN1), \
	PINMUX_DATA(PORT138_KEYOUT8_MARK, PORT138_FN2), \
	PINMUX_DATA(VIO2_D0_MARK, PORT138_FN6), \
	PINMUX_DATA(LCD2D6_MARK, PORT138_FN7),
	PINMUX_DATA(VIO_D9_MARK, PORT139_FN1), \
	PINMUX_DATA(PORT139_KEYOUT9_MARK, PORT139_FN2), \
	PINMUX_DATA(VIO2_D1_MARK, PORT139_FN6), \
	PINMUX_DATA(LCD2D7_MARK, PORT139_FN7),
	PINMUX_DATA(VIO_D10_MARK, PORT140_FN1), \
	PINMUX_DATA(TPU0TO2_MARK, PORT140_FN4), \
	PINMUX_DATA(VIO2_D2_MARK, PORT140_FN6), \
	PINMUX_DATA(LCD2D8_MARK, PORT140_FN7),
	PINMUX_DATA(VIO_D11_MARK, PORT141_FN1), \
	PINMUX_DATA(TPU0TO3_MARK, PORT141_FN4), \
	PINMUX_DATA(VIO2_D3_MARK, PORT141_FN6), \
	PINMUX_DATA(LCD2D9_MARK, PORT141_FN7),
	PINMUX_DATA(VIO_D12_MARK, PORT142_FN1), \
	PINMUX_DATA(PORT142_KEYOUT10_MARK, PORT142_FN2), \
	PINMUX_DATA(VIO2_D4_MARK, PORT142_FN6), \
	PINMUX_DATA(LCD2D2_MARK, PORT142_FN7),
	PINMUX_DATA(VIO_D13_MARK, PORT143_FN1), \
	PINMUX_DATA(PORT143_KEYOUT11_MARK, PORT143_FN2), \
	PINMUX_DATA(PORT143_KEYOUT6_MARK, PORT143_FN3), \
	PINMUX_DATA(VIO2_D5_MARK, PORT143_FN6), \
	PINMUX_DATA(LCD2D3_MARK, PORT143_FN7),
	PINMUX_DATA(VIO_D14_MARK, PORT144_FN1), \
	PINMUX_DATA(PORT144_KEYOUT7_MARK, PORT144_FN2), \
	PINMUX_DATA(VIO2_D6_MARK, PORT144_FN6), \
	PINMUX_DATA(LCD2D4_MARK, PORT144_FN7),
	PINMUX_DATA(VIO_D15_MARK, PORT145_FN1), \
	PINMUX_DATA(TPU1TO3_MARK, PORT145_FN3), \
	PINMUX_DATA(PORT145_LCD2DISP_MARK, PORT145_FN4), \
	PINMUX_DATA(PORT145_LCD2RS_MARK, PORT145_FN5), \
	PINMUX_DATA(VIO2_D7_MARK, PORT145_FN6), \
	PINMUX_DATA(LCD2D5_MARK, PORT145_FN7),
	PINMUX_DATA(VIO_CLK_MARK, PORT146_FN1), \
	PINMUX_DATA(LCD2DCK_MARK, PORT146_FN4), \
	PINMUX_DATA(PORT146_LCD2WR__MARK, PORT146_FN5), \
	PINMUX_DATA(VIO2_CLK_MARK, PORT146_FN6, MSEL4CR_MSEL27_0), \
	PINMUX_DATA(LCD2D18_MARK, PORT146_FN7),
	PINMUX_DATA(VIO_FIELD_MARK, PORT147_FN1), \
	PINMUX_DATA(LCD2RD__MARK, PORT147_FN4), \
	PINMUX_DATA(VIO2_FIELD_MARK, PORT147_FN6, MSEL4CR_MSEL27_0), \
	PINMUX_DATA(LCD2D19_MARK, PORT147_FN7),
	PINMUX_DATA(VIO_CKO_MARK, PORT148_FN1),
	PINMUX_DATA(A27_MARK, PORT149_FN1), \
	PINMUX_DATA(PORT149_RDWR_MARK, PORT149_FN2), \
	PINMUX_DATA(MFG0_IN1_MARK, PORT149_FN3), \
	PINMUX_DATA(PORT149_KEYOUT9_MARK, PORT149_FN4),
	PINMUX_DATA(MFG0_IN2_MARK, PORT150_FN3),
	PINMUX_DATA(TS_SPSYNC3_MARK, PORT151_FN4), \
	PINMUX_DATA(MSIOF2_RSCK_MARK, PORT151_FN5),
	PINMUX_DATA(TS_SDAT3_MARK, PORT152_FN4), \
	PINMUX_DATA(MSIOF2_RSYNC_MARK, PORT152_FN5),
	PINMUX_DATA(TPU1TO2_MARK, PORT153_FN3), \
	PINMUX_DATA(TS_SDEN3_MARK, PORT153_FN4), \
	PINMUX_DATA(PORT153_MSIOF2_SS1_MARK, PORT153_FN5),
	PINMUX_DATA(SCIFA2_TXD1_MARK, PORT154_FN2, MSEL3CR_MSEL9_0), \
	PINMUX_DATA(MSIOF2_MCK0_MARK, PORT154_FN5),
	PINMUX_DATA(SCIFA2_RXD1_MARK, PORT155_FN2, MSEL3CR_MSEL9_0), \
	PINMUX_DATA(MSIOF2_MCK1_MARK, PORT155_FN5),
	PINMUX_DATA(SCIFA2_RTS1__MARK, PORT156_FN2, MSEL3CR_MSEL9_0), \
	PINMUX_DATA(PORT156_MSIOF2_SS2_MARK, PORT156_FN5),
	PINMUX_DATA(SCIFA2_CTS1__MARK, PORT157_FN2, MSEL3CR_MSEL9_0), \
	PINMUX_DATA(PORT157_MSIOF2_RXD_MARK, PORT157_FN5, MSEL4CR_MSEL11_0,
		MSEL4CR_MSEL10_0),
	PINMUX_DATA(DINT__MARK, PORT158_FN1), \
	PINMUX_DATA(SCIFA2_SCK1_MARK, PORT158_FN2, MSEL3CR_MSEL9_0), \
	PINMUX_DATA(TS_SCK3_MARK, PORT158_FN4),
	PINMUX_DATA(PORT159_SCIFB_SCK_MARK, PORT159_FN1, MSEL4CR_MSEL22_0), \
	PINMUX_DATA(PORT159_SCIFA5_SCK_MARK, PORT159_FN2, MSEL4CR_MSEL21_1), \
	PINMUX_DATA(NMI_MARK, PORT159_FN3),
	PINMUX_DATA(PORT160_SCIFB_TXD_MARK, PORT160_FN1, MSEL4CR_MSEL22_0), \
	PINMUX_DATA(PORT160_SCIFA5_TXD_MARK, PORT160_FN2, MSEL4CR_MSEL21_1),
	PINMUX_DATA(PORT161_SCIFB_CTS__MARK, PORT161_FN1, MSEL4CR_MSEL22_0), \
	PINMUX_DATA(PORT161_SCIFA5_CTS__MARK, PORT161_FN2, MSEL4CR_MSEL21_1),
	PINMUX_DATA(PORT162_SCIFB_RXD_MARK, PORT162_FN1, MSEL4CR_MSEL22_0), \
	PINMUX_DATA(PORT162_SCIFA5_RXD_MARK, PORT162_FN2, MSEL4CR_MSEL21_1),
	PINMUX_DATA(PORT163_SCIFB_RTS__MARK, PORT163_FN1, MSEL4CR_MSEL22_0), \
	PINMUX_DATA(PORT163_SCIFA5_RTS__MARK, PORT163_FN2, MSEL4CR_MSEL21_1), \
	PINMUX_DATA(TPU3TO0_MARK, PORT163_FN5),
	PINMUX_DATA(LCDD0_MARK, PORT192_FN1),
	PINMUX_DATA(LCDD1_MARK, PORT193_FN1), \
	PINMUX_DATA(PORT193_SCIFA5_CTS__MARK, PORT193_FN3, MSEL4CR_MSEL21_0,
		MSEL4CR_MSEL20_1), \
	PINMUX_DATA(BBIF2_TSYNC1_MARK, PORT193_FN5),
	PINMUX_DATA(LCDD2_MARK, PORT194_FN1), \
	PINMUX_DATA(PORT194_SCIFA5_RTS__MARK, PORT194_FN3, MSEL4CR_MSEL21_0,
		MSEL4CR_MSEL20_1), \
	PINMUX_DATA(BBIF2_TSCK1_MARK, PORT194_FN5),
	PINMUX_DATA(LCDD3_MARK, PORT195_FN1), \
	PINMUX_DATA(PORT195_SCIFA5_RXD_MARK, PORT195_FN3, MSEL4CR_MSEL21_0,
		MSEL4CR_MSEL20_1), \
	PINMUX_DATA(BBIF2_TXD1_MARK, PORT195_FN5),
	PINMUX_DATA(LCDD4_MARK, PORT196_FN1), \
	PINMUX_DATA(PORT196_SCIFA5_TXD_MARK, PORT196_FN3, MSEL4CR_MSEL21_0,
		MSEL4CR_MSEL20_1),
	PINMUX_DATA(LCDD5_MARK, PORT197_FN1), \
	PINMUX_DATA(PORT197_SCIFA5_SCK_MARK, PORT197_FN3, MSEL4CR_MSEL21_0,
		MSEL4CR_MSEL20_1), \
	PINMUX_DATA(MFG2_OUT2_MARK, PORT197_FN5), \
	PINMUX_DATA(TPU2TO1_MARK, PORT197_FN7),
	PINMUX_DATA(LCDD6_MARK, PORT198_FN1),
	PINMUX_DATA(LCDD7_MARK, PORT199_FN1), \
	PINMUX_DATA(TPU4TO1_MARK, PORT199_FN2), \
	PINMUX_DATA(MFG4_OUT2_MARK, PORT199_FN5),
	PINMUX_DATA(LCDD8_MARK, PORT200_FN1), \
	PINMUX_DATA(D16_MARK, PORT200_FN6),
	PINMUX_DATA(LCDD9_MARK, PORT201_FN1), \
	PINMUX_DATA(D17_MARK, PORT201_FN6),
	PINMUX_DATA(LCDD10_MARK, PORT202_FN1), \
	PINMUX_DATA(D18_MARK, PORT202_FN6),
	PINMUX_DATA(LCDD11_MARK, PORT203_FN1), \
	PINMUX_DATA(D19_MARK, PORT203_FN6),
	PINMUX_DATA(LCDD12_MARK, PORT204_FN1), \
	PINMUX_DATA(D20_MARK, PORT204_FN6),
	PINMUX_DATA(LCDD13_MARK, PORT205_FN1), \
	PINMUX_DATA(D21_MARK, PORT205_FN6),
	PINMUX_DATA(LCDD14_MARK, PORT206_FN1), \
	PINMUX_DATA(D22_MARK, PORT206_FN6),
	PINMUX_DATA(LCDD15_MARK, PORT207_FN1), \
	PINMUX_DATA(PORT207_MSIOF0L_SS1_MARK, PORT207_FN2, MSEL3CR_MSEL11_1), \
	PINMUX_DATA(D23_MARK, PORT207_FN6),
	PINMUX_DATA(LCDD16_MARK, PORT208_FN1), \
	PINMUX_DATA(PORT208_MSIOF0L_SS2_MARK, PORT208_FN2, MSEL3CR_MSEL11_1), \
	PINMUX_DATA(D24_MARK, PORT208_FN6),
	PINMUX_DATA(LCDD17_MARK, PORT209_FN1), \
	PINMUX_DATA(D25_MARK, PORT209_FN6),
	PINMUX_DATA(LCDD18_MARK, PORT210_FN1), \
	PINMUX_DATA(DREQ2_MARK, PORT210_FN2), \
	PINMUX_DATA(PORT210_MSIOF0L_SS1_MARK, PORT210_FN5, MSEL3CR_MSEL11_1), \
	PINMUX_DATA(D26_MARK, PORT210_FN6),
	PINMUX_DATA(LCDD19_MARK, PORT211_FN1), \
	PINMUX_DATA(PORT211_MSIOF0L_SS2_MARK, PORT211_FN5, MSEL3CR_MSEL11_1), \
	PINMUX_DATA(D27_MARK, PORT211_FN6),
	PINMUX_DATA(LCDD20_MARK, PORT212_FN1), \
	PINMUX_DATA(TS_SPSYNC1_MARK, PORT212_FN2), \
	PINMUX_DATA(MSIOF0L_MCK0_MARK, PORT212_FN5, MSEL3CR_MSEL11_1), \
	PINMUX_DATA(D28_MARK, PORT212_FN6),
	PINMUX_DATA(LCDD21_MARK, PORT213_FN1), \
	PINMUX_DATA(TS_SDAT1_MARK, PORT213_FN2), \
	PINMUX_DATA(MSIOF0L_MCK1_MARK, PORT213_FN5, MSEL3CR_MSEL11_1), \
	PINMUX_DATA(D29_MARK, PORT213_FN6),
	PINMUX_DATA(LCDD22_MARK, PORT214_FN1), \
	PINMUX_DATA(TS_SDEN1_MARK, PORT214_FN2), \
	PINMUX_DATA(MSIOF0L_RSCK_MARK, PORT214_FN5, MSEL3CR_MSEL11_1), \
	PINMUX_DATA(D30_MARK, PORT214_FN6),
	PINMUX_DATA(LCDD23_MARK, PORT215_FN1), \
	PINMUX_DATA(TS_SCK1_MARK, PORT215_FN2), \
	PINMUX_DATA(MSIOF0L_RSYNC_MARK, PORT215_FN5, MSEL3CR_MSEL11_1), \
	PINMUX_DATA(D31_MARK, PORT215_FN6),
	PINMUX_DATA(LCDDCK_MARK, PORT216_FN1), \
	PINMUX_DATA(LCDWR__MARK, PORT216_FN2),
	PINMUX_DATA(LCDRD__MARK, PORT217_FN1), \
	PINMUX_DATA(DACK2_MARK, PORT217_FN2), \
	PINMUX_DATA(PORT217_LCD2RS_MARK, PORT217_FN3), \
	PINMUX_DATA(MSIOF0L_TSYNC_MARK, PORT217_FN5, MSEL3CR_MSEL11_1), \
	PINMUX_DATA(VIO2_FIELD3_MARK, PORT217_FN6, MSEL4CR_MSEL27_1,
		MSEL4CR_MSEL26_1), \
	PINMUX_DATA(PORT217_LCD2DISP_MARK, PORT217_FN7),
	PINMUX_DATA(LCDHSYN_MARK, PORT218_FN1), \
	PINMUX_DATA(LCDCS__MARK, PORT218_FN2), \
	PINMUX_DATA(LCDCS2__MARK, PORT218_FN3), \
	PINMUX_DATA(DACK3_MARK, PORT218_FN4), \
	PINMUX_DATA(PORT218_VIO_CKOR_MARK, PORT218_FN5),
	PINMUX_DATA(LCDDISP_MARK, PORT219_FN1), \
	PINMUX_DATA(LCDRS_MARK, PORT219_FN2), \
	PINMUX_DATA(PORT219_LCD2WR__MARK, PORT219_FN3), \
	PINMUX_DATA(DREQ3_MARK, PORT219_FN4), \
	PINMUX_DATA(MSIOF0L_TSCK_MARK, PORT219_FN5, MSEL3CR_MSEL11_1), \
	PINMUX_DATA(VIO2_CLK3_MARK, PORT219_FN6, MSEL4CR_MSEL27_1,
		MSEL4CR_MSEL26_1), \
	PINMUX_DATA(LCD2DCK_2_MARK, PORT219_FN7),
	PINMUX_DATA(LCDVSYN_MARK, PORT220_FN1), \
	PINMUX_DATA(LCDVSYN2_MARK, PORT220_FN2),
	PINMUX_DATA(LCDLCLK_MARK, PORT221_FN1), \
	PINMUX_DATA(DREQ1_MARK, PORT221_FN2), \
	PINMUX_DATA(PORT221_LCD2CS__MARK, PORT221_FN3), \
	PINMUX_DATA(PWEN_MARK, PORT221_FN4), \
	PINMUX_DATA(MSIOF0L_RXD_MARK, PORT221_FN5, MSEL3CR_MSEL11_1), \
	PINMUX_DATA(VIO2_HD3_MARK, PORT221_FN6, MSEL4CR_MSEL27_1,
		MSEL4CR_MSEL26_1), \
	PINMUX_DATA(PORT221_LCD2HSYN_MARK, PORT221_FN7),
	PINMUX_DATA(LCDDON_MARK, PORT222_FN1), \
	PINMUX_DATA(LCDDON2_MARK, PORT222_FN2), \
	PINMUX_DATA(DACK1_MARK, PORT222_FN3), \
	PINMUX_DATA(OVCN_MARK, PORT222_FN4), \
	PINMUX_DATA(MSIOF0L_TXD_MARK, PORT222_FN5, MSEL3CR_MSEL11_1), \
	PINMUX_DATA(VIO2_VD3_MARK, PORT222_FN6, MSEL4CR_MSEL27_1,
		MSEL4CR_MSEL26_1), \
	PINMUX_DATA(PORT222_LCD2VSYN_MARK, PORT222_FN7, MSEL3CR_MSEL2_1),

	PINMUX_DATA(SCIFA1_TXD_MARK, PORT225_FN2), \
	PINMUX_DATA(OVCN2_MARK, PORT225_FN4),
	PINMUX_DATA(EXTLP_MARK, PORT226_FN1), \
	PINMUX_DATA(SCIFA1_SCK_MARK, PORT226_FN2), \
	PINMUX_DATA(PORT226_VIO_CKO2_MARK, PORT226_FN5),
	PINMUX_DATA(SCIFA1_RTS__MARK, PORT227_FN2), \
	PINMUX_DATA(IDIN_MARK, PORT227_FN4),
	PINMUX_DATA(SCIFA1_RXD_MARK, PORT228_FN2),
	PINMUX_DATA(SCIFA1_CTS__MARK, PORT229_FN2), \
	PINMUX_DATA(MFG1_IN1_MARK, PORT229_FN3),
	PINMUX_DATA(MSIOF1_TXD_MARK, PORT230_FN1), \
	PINMUX_DATA(SCIFA2_TXD2_MARK, PORT230_FN2, MSEL3CR_MSEL9_1),
	PINMUX_DATA(MSIOF1_TSYNC_MARK, PORT231_FN1), \
	PINMUX_DATA(SCIFA2_CTS2__MARK, PORT231_FN2, MSEL3CR_MSEL9_1),
	PINMUX_DATA(MSIOF1_TSCK_MARK, PORT232_FN1), \
	PINMUX_DATA(SCIFA2_SCK2_MARK, PORT232_FN2, MSEL3CR_MSEL9_1),
	PINMUX_DATA(MSIOF1_RXD_MARK, PORT233_FN1), \
	PINMUX_DATA(SCIFA2_RXD2_MARK, PORT233_FN2, MSEL3CR_MSEL9_1),
	PINMUX_DATA(MSIOF1_RSCK_MARK, PORT234_FN1), \
	PINMUX_DATA(SCIFA2_RTS2__MARK, PORT234_FN2, MSEL3CR_MSEL9_1), \
	PINMUX_DATA(VIO2_CLK2_MARK, PORT234_FN6, MSEL4CR_MSEL27_1,
		MSEL4CR_MSEL26_0), \
	PINMUX_DATA(LCD2D20_MARK, PORT234_FN7),
	PINMUX_DATA(MSIOF1_RSYNC_MARK, PORT235_FN1), \
	PINMUX_DATA(MFG1_IN2_MARK, PORT235_FN3), \
	PINMUX_DATA(VIO2_VD2_MARK, PORT235_FN6, MSEL4CR_MSEL27_1,
		MSEL4CR_MSEL26_0), \
	PINMUX_DATA(LCD2D21_MARK, PORT235_FN7),
	PINMUX_DATA(MSIOF1_MCK0_MARK, PORT236_FN1), \
	PINMUX_DATA(PORT236_I2C_SDA2_MARK, PORT236_FN2, MSEL2CR_MSEL17_0,
		MSEL2CR_MSEL16_0),
	PINMUX_DATA(MSIOF1_MCK1_MARK, PORT237_FN1), \
	PINMUX_DATA(PORT237_I2C_SCL2_MARK, PORT237_FN2, MSEL2CR_MSEL17_0,
		MSEL2CR_MSEL16_0),
	PINMUX_DATA(MSIOF1_SS1_MARK, PORT238_FN1), \
	PINMUX_DATA(VIO2_FIELD2_MARK, PORT238_FN6, MSEL4CR_MSEL27_1,
		MSEL4CR_MSEL26_0), \
	PINMUX_DATA(LCD2D22_MARK, PORT238_FN7),
	PINMUX_DATA(MSIOF1_SS2_MARK, PORT239_FN1), \
	PINMUX_DATA(VIO2_HD2_MARK, PORT239_FN6, MSEL4CR_MSEL27_1,
		MSEL4CR_MSEL26_0), \
	PINMUX_DATA(LCD2D23_MARK, PORT239_FN7),
	PINMUX_DATA(SCIFA6_TXD_MARK, PORT240_FN1),
	PINMUX_DATA(PORT241_IRDA_OUT_MARK, PORT241_FN1, MSEL4CR_MSEL19_0), \
	PINMUX_DATA(PORT241_IROUT_MARK, PORT241_FN2), \
	PINMUX_DATA(MFG4_OUT1_MARK, PORT241_FN3), \
	PINMUX_DATA(TPU4TO0_MARK, PORT241_FN4),
	PINMUX_DATA(PORT242_IRDA_IN_MARK, PORT242_FN1, MSEL4CR_MSEL19_0), \
	PINMUX_DATA(MFG4_IN2_MARK, PORT242_FN3),
	PINMUX_DATA(PORT243_IRDA_FIRSEL_MARK, PORT243_FN1, MSEL4CR_MSEL19_0), \
	PINMUX_DATA(PORT243_VIO_CKO2_MARK, PORT243_FN2),
	PINMUX_DATA(PORT244_SCIFA5_CTS__MARK, PORT244_FN1, MSEL4CR_MSEL21_0,
		MSEL4CR_MSEL20_0), \
	PINMUX_DATA(MFG2_IN1_MARK, PORT244_FN2), \
	PINMUX_DATA(PORT244_SCIFB_CTS__MARK, PORT244_FN3, MSEL4CR_MSEL22_1), \
	PINMUX_DATA(MSIOF2R_RXD_MARK, PORT244_FN7, MSEL4CR_MSEL11_1),
	PINMUX_DATA(PORT245_SCIFA5_RTS__MARK, PORT245_FN1, MSEL4CR_MSEL21_0,
		MSEL4CR_MSEL20_0), \
	PINMUX_DATA(MFG2_IN2_MARK, PORT245_FN2), \
	PINMUX_DATA(PORT245_SCIFB_RTS__MARK, PORT245_FN3, MSEL4CR_MSEL22_1), \
	PINMUX_DATA(MSIOF2R_TXD_MARK, PORT245_FN7, MSEL4CR_MSEL11_1),
	PINMUX_DATA(PORT246_SCIFA5_RXD_MARK, PORT246_FN1, MSEL4CR_MSEL21_0,
		MSEL4CR_MSEL20_0), \
	PINMUX_DATA(MFG1_OUT1_MARK, PORT246_FN2), \
	PINMUX_DATA(PORT246_SCIFB_RXD_MARK, PORT246_FN3, MSEL4CR_MSEL22_1), \
	PINMUX_DATA(TPU1TO0_MARK, PORT246_FN4),
	PINMUX_DATA(PORT247_SCIFA5_TXD_MARK, PORT247_FN1, MSEL4CR_MSEL21_0,
		MSEL4CR_MSEL20_0), \
	PINMUX_DATA(MFG3_OUT2_MARK, PORT247_FN2), \
	PINMUX_DATA(PORT247_SCIFB_TXD_MARK, PORT247_FN3, MSEL4CR_MSEL22_1), \
	PINMUX_DATA(TPU3TO1_MARK, PORT247_FN4),
	PINMUX_DATA(PORT248_SCIFA5_SCK_MARK, PORT248_FN1, MSEL4CR_MSEL21_0,
		MSEL4CR_MSEL20_0), \
	PINMUX_DATA(MFG2_OUT1_MARK, PORT248_FN2), \
	PINMUX_DATA(PORT248_SCIFB_SCK_MARK, PORT248_FN3, MSEL4CR_MSEL22_1), \
	PINMUX_DATA(TPU2TO0_MARK, PORT248_FN4), \
	PINMUX_DATA(PORT248_I2C_SCL3_MARK, PORT248_FN5, MSEL2CR_MSEL19_0,
		MSEL2CR_MSEL18_0), \
	PINMUX_DATA(MSIOF2R_TSCK_MARK, PORT248_FN7, MSEL4CR_MSEL11_1),
	PINMUX_DATA(PORT249_IROUT_MARK, PORT249_FN1), \
	PINMUX_DATA(MFG4_IN1_MARK, PORT249_FN2), \
	PINMUX_DATA(PORT249_I2C_SDA3_MARK, PORT249_FN5, MSEL2CR_MSEL19_0,
		MSEL2CR_MSEL18_0), \
	PINMUX_DATA(MSIOF2R_TSYNC_MARK, PORT249_FN7, MSEL4CR_MSEL11_1),
	PINMUX_DATA(SDHICLK0_MARK, PORT250_FN1),
	PINMUX_DATA(SDHICD0_MARK, PORT251_FN1),
	PINMUX_DATA(SDHID0_0_MARK, PORT252_FN1),
	PINMUX_DATA(SDHID0_1_MARK, PORT253_FN1),
	PINMUX_DATA(SDHID0_2_MARK, PORT254_FN1),
	PINMUX_DATA(SDHID0_3_MARK, PORT255_FN1),
	PINMUX_DATA(SDHICMD0_MARK, PORT256_FN1),
	PINMUX_DATA(SDHIWP0_MARK, PORT257_FN1),
	PINMUX_DATA(SDHICLK1_MARK, PORT258_FN1),
	PINMUX_DATA(SDHID1_0_MARK, PORT259_FN1), \
	PINMUX_DATA(TS_SPSYNC2_MARK, PORT259_FN3),
	PINMUX_DATA(SDHID1_1_MARK, PORT260_FN1), \
	PINMUX_DATA(TS_SDAT2_MARK, PORT260_FN3),
	PINMUX_DATA(SDHID1_2_MARK, PORT261_FN1), \
	PINMUX_DATA(TS_SDEN2_MARK, PORT261_FN3),
	PINMUX_DATA(SDHID1_3_MARK, PORT262_FN1), \
	PINMUX_DATA(TS_SCK2_MARK, PORT262_FN3),
	PINMUX_DATA(SDHICMD1_MARK, PORT263_FN1),
	PINMUX_DATA(SDHICLK2_MARK, PORT264_FN1),
	PINMUX_DATA(SDHID2_0_MARK, PORT265_FN1), \
	PINMUX_DATA(TS_SPSYNC4_MARK, PORT265_FN3),
	PINMUX_DATA(SDHID2_1_MARK, PORT266_FN1), \
	PINMUX_DATA(TS_SDAT4_MARK, PORT266_FN3),
	PINMUX_DATA(SDHID2_2_MARK, PORT267_FN1), \
	PINMUX_DATA(TS_SDEN4_MARK, PORT267_FN3),
	PINMUX_DATA(SDHID2_3_MARK, PORT268_FN1), \
	PINMUX_DATA(TS_SCK4_MARK, PORT268_FN3),
	PINMUX_DATA(SDHICMD2_MARK, PORT269_FN1),
	PINMUX_DATA(MMCCLK0_MARK, PORT270_FN1, MSEL4CR_MSEL15_0),
	PINMUX_DATA(MMCD0_0_MARK, PORT271_FN1, MSEL4CR_MSEL15_0),
	PINMUX_DATA(MMCD0_1_MARK, PORT272_FN1, MSEL4CR_MSEL15_0),
	PINMUX_DATA(MMCD0_2_MARK, PORT273_FN1, MSEL4CR_MSEL15_0),
	PINMUX_DATA(MMCD0_3_MARK, PORT274_FN1, MSEL4CR_MSEL15_0),
	PINMUX_DATA(MMCD0_4_MARK, PORT275_FN1, MSEL4CR_MSEL15_0),
	PINMUX_DATA(TS_SPSYNC5_MARK, PORT275_FN3),
	PINMUX_DATA(MMCD0_5_MARK, PORT276_FN1, MSEL4CR_MSEL15_0),
	PINMUX_DATA(TS_SDAT5_MARK, PORT276_FN3),
	PINMUX_DATA(MMCD0_6_MARK, PORT277_FN1, MSEL4CR_MSEL15_0),
	PINMUX_DATA(TS_SDEN5_MARK, PORT277_FN3),
	PINMUX_DATA(MMCD0_7_MARK, PORT278_FN1, MSEL4CR_MSEL15_0),
	PINMUX_DATA(TS_SCK5_MARK, PORT278_FN3),
	PINMUX_DATA(MMCCMD0_MARK, PORT279_FN1, MSEL4CR_MSEL15_0),
	PINMUX_DATA(RESETOUTS__MARK, PORT281_FN1), \
	PINMUX_DATA(EXTAL2OUT_MARK, PORT281_FN2),
	PINMUX_DATA(MCP_WAIT__MCP_FRB_MARK, PORT288_FN1),
	PINMUX_DATA(MCP_CKO_MARK, PORT289_FN1), \
	PINMUX_DATA(MMCCLK1_MARK, PORT289_FN2, MSEL4CR_MSEL15_1),
	PINMUX_DATA(MCP_D15_MCP_NAF15_MARK, PORT290_FN1),
	PINMUX_DATA(MCP_D14_MCP_NAF14_MARK, PORT291_FN1),
	PINMUX_DATA(MCP_D13_MCP_NAF13_MARK, PORT292_FN1),
	PINMUX_DATA(MCP_D12_MCP_NAF12_MARK, PORT293_FN1),
	PINMUX_DATA(MCP_D11_MCP_NAF11_MARK, PORT294_FN1),
	PINMUX_DATA(MCP_D10_MCP_NAF10_MARK, PORT295_FN1),
	PINMUX_DATA(MCP_D9_MCP_NAF9_MARK, PORT296_FN1),
	PINMUX_DATA(MCP_D8_MCP_NAF8_MARK, PORT297_FN1), \
	PINMUX_DATA(MMCCMD1_MARK, PORT297_FN2, MSEL4CR_MSEL15_1),
	PINMUX_DATA(MCP_D7_MCP_NAF7_MARK, PORT298_FN1), \
	PINMUX_DATA(MMCD1_7_MARK, PORT298_FN2, MSEL4CR_MSEL15_1),

	PINMUX_DATA(MCP_D6_MCP_NAF6_MARK, PORT299_FN1), \
	PINMUX_DATA(MMCD1_6_MARK, PORT299_FN2, MSEL4CR_MSEL15_1),
	PINMUX_DATA(MCP_D5_MCP_NAF5_MARK, PORT300_FN1), \
	PINMUX_DATA(MMCD1_5_MARK, PORT300_FN2, MSEL4CR_MSEL15_1),
	PINMUX_DATA(MCP_D4_MCP_NAF4_MARK, PORT301_FN1), \
	PINMUX_DATA(MMCD1_4_MARK, PORT301_FN2, MSEL4CR_MSEL15_1),
	PINMUX_DATA(MCP_D3_MCP_NAF3_MARK, PORT302_FN1), \
	PINMUX_DATA(MMCD1_3_MARK, PORT302_FN2, MSEL4CR_MSEL15_1),
	PINMUX_DATA(MCP_D2_MCP_NAF2_MARK, PORT303_FN1), \
	PINMUX_DATA(MMCD1_2_MARK, PORT303_FN2, MSEL4CR_MSEL15_1),
	PINMUX_DATA(MCP_D1_MCP_NAF1_MARK, PORT304_FN1), \
	PINMUX_DATA(MMCD1_1_MARK, PORT304_FN2, MSEL4CR_MSEL15_1),
	PINMUX_DATA(MCP_D0_MCP_NAF0_MARK, PORT305_FN1), \
	PINMUX_DATA(MMCD1_0_MARK, PORT305_FN2, MSEL4CR_MSEL15_1),
	PINMUX_DATA(MCP_NBRSTOUT__MARK, PORT306_FN1),
	PINMUX_DATA(MCP_WE0__MCP_FWE_MARK, PORT309_FN1), \
	PINMUX_DATA(MCP_RDWR_MCP_FWE_MARK, PORT309_FN2),

	/* MSEL2 special cases */
	PINMUX_DATA(TSIF2_TS_XX1_MARK, MSEL2CR_MSEL14_0, MSEL2CR_MSEL13_0,
		MSEL2CR_MSEL12_0),
	PINMUX_DATA(TSIF2_TS_XX2_MARK, MSEL2CR_MSEL14_0, MSEL2CR_MSEL13_0,
		MSEL2CR_MSEL12_1),
	PINMUX_DATA(TSIF2_TS_XX3_MARK, MSEL2CR_MSEL14_0, MSEL2CR_MSEL13_1,
		MSEL2CR_MSEL12_0),
	PINMUX_DATA(TSIF2_TS_XX4_MARK, MSEL2CR_MSEL14_0, MSEL2CR_MSEL13_1,
		MSEL2CR_MSEL12_1),
	PINMUX_DATA(TSIF2_TS_XX5_MARK, MSEL2CR_MSEL14_1, MSEL2CR_MSEL13_0,
		MSEL2CR_MSEL12_0),
	PINMUX_DATA(TSIF1_TS_XX1_MARK, MSEL2CR_MSEL11_0, MSEL2CR_MSEL10_0,
		MSEL2CR_MSEL9_0),
	PINMUX_DATA(TSIF1_TS_XX2_MARK, MSEL2CR_MSEL11_0, MSEL2CR_MSEL10_0,
		MSEL2CR_MSEL9_1),
	PINMUX_DATA(TSIF1_TS_XX3_MARK, MSEL2CR_MSEL11_0, MSEL2CR_MSEL10_1,
		MSEL2CR_MSEL9_0),
	PINMUX_DATA(TSIF1_TS_XX4_MARK, MSEL2CR_MSEL11_0, MSEL2CR_MSEL10_1,
		MSEL2CR_MSEL9_1),
	PINMUX_DATA(TSIF1_TS_XX5_MARK, MSEL2CR_MSEL11_1, MSEL2CR_MSEL10_0,
		MSEL2CR_MSEL9_0),
	PINMUX_DATA(TSIF0_TS_XX1_MARK, MSEL2CR_MSEL8_0, MSEL2CR_MSEL7_0,
		MSEL2CR_MSEL6_0),
	PINMUX_DATA(TSIF0_TS_XX2_MARK, MSEL2CR_MSEL8_0, MSEL2CR_MSEL7_0,
		MSEL2CR_MSEL6_1),
	PINMUX_DATA(TSIF0_TS_XX3_MARK, MSEL2CR_MSEL8_0, MSEL2CR_MSEL7_1,
		MSEL2CR_MSEL6_0),
	PINMUX_DATA(TSIF0_TS_XX4_MARK, MSEL2CR_MSEL8_0, MSEL2CR_MSEL7_1,
		MSEL2CR_MSEL6_1),
	PINMUX_DATA(TSIF0_TS_XX5_MARK, MSEL2CR_MSEL8_1, MSEL2CR_MSEL7_0,
		MSEL2CR_MSEL6_0),
	PINMUX_DATA(MST1_TS_XX1_MARK, MSEL2CR_MSEL5_0, MSEL2CR_MSEL4_0,
		MSEL2CR_MSEL3_0),
	PINMUX_DATA(MST1_TS_XX2_MARK, MSEL2CR_MSEL5_0, MSEL2CR_MSEL4_0,
		MSEL2CR_MSEL3_1),
	PINMUX_DATA(MST1_TS_XX3_MARK, MSEL2CR_MSEL5_0, MSEL2CR_MSEL4_1,
		MSEL2CR_MSEL3_0),
	PINMUX_DATA(MST1_TS_XX4_MARK, MSEL2CR_MSEL5_0, MSEL2CR_MSEL4_1,
		MSEL2CR_MSEL3_1),
	PINMUX_DATA(MST1_TS_XX5_MARK, MSEL2CR_MSEL5_1, MSEL2CR_MSEL4_0,
		MSEL2CR_MSEL3_0),
	PINMUX_DATA(MST0_TS_XX1_MARK, MSEL2CR_MSEL2_0, MSEL2CR_MSEL1_0,
		MSEL2CR_MSEL0_0),
	PINMUX_DATA(MST0_TS_XX2_MARK, MSEL2CR_MSEL2_0, MSEL2CR_MSEL1_0,
		MSEL2CR_MSEL0_1),
	PINMUX_DATA(MST0_TS_XX3_MARK, MSEL2CR_MSEL2_0, MSEL2CR_MSEL1_1,
		MSEL2CR_MSEL0_0),
	PINMUX_DATA(MST0_TS_XX4_MARK, MSEL2CR_MSEL2_0, MSEL2CR_MSEL1_1,
		MSEL2CR_MSEL0_1),
	PINMUX_DATA(MST0_TS_XX5_MARK, MSEL2CR_MSEL2_1, MSEL2CR_MSEL1_0,
		MSEL2CR_MSEL0_0),

	/* MSEL3 special cases */
	PINMUX_DATA(SDHI0_VCCQ_MC0_ON_MARK, MSEL3CR_MSEL28_1),
	PINMUX_DATA(SDHI0_VCCQ_MC0_OFF_MARK, MSEL3CR_MSEL28_0),
	PINMUX_DATA(DEBUG_MON_VIO_MARK, MSEL3CR_MSEL15_0),
	PINMUX_DATA(DEBUG_MON_LCDD_MARK, MSEL3CR_MSEL15_1),
	PINMUX_DATA(LCDC_LCDC0_MARK, MSEL3CR_MSEL6_0),
	PINMUX_DATA(LCDC_LCDC1_MARK, MSEL3CR_MSEL6_1),

	/* MSEL4 special cases */
	PINMUX_DATA(IRQ9_MEM_INT_MARK, MSEL4CR_MSEL29_0),
	PINMUX_DATA(IRQ9_MCP_INT_MARK, MSEL4CR_MSEL29_1),
	PINMUX_DATA(A11_MARK, MSEL4CR_MSEL13_0, MSEL4CR_MSEL12_0),
	PINMUX_DATA(KEYOUT8_MARK, MSEL4CR_MSEL13_0, MSEL4CR_MSEL12_1),
	PINMUX_DATA(TPU4TO3_MARK, MSEL4CR_MSEL13_1, MSEL4CR_MSEL12_0),
	PINMUX_DATA(RESETA_N_PU_ON_MARK, MSEL4CR_MSEL4_0),
	PINMUX_DATA(RESETA_N_PU_OFF_MARK, MSEL4CR_MSEL4_1),
	PINMUX_DATA(EDBGREQ_PD_MARK, MSEL4CR_MSEL1_0),
	PINMUX_DATA(EDBGREQ_PU_MARK, MSEL4CR_MSEL1_1),
};

#define __I		(SH_PFC_PIN_CFG_INPUT)
#define __O		(SH_PFC_PIN_CFG_OUTPUT)
#define __IO		(SH_PFC_PIN_CFG_INPUT | SH_PFC_PIN_CFG_OUTPUT)
#define __PD		(SH_PFC_PIN_CFG_PULL_DOWN)
#define __PU		(SH_PFC_PIN_CFG_PULL_UP)
#define __PUD		(SH_PFC_PIN_CFG_PULL_DOWN | SH_PFC_PIN_CFG_PULL_UP)

#define SH73A0_PIN_I_PD(pin)		SH_PFC_PIN_CFG(pin, __I | __PD)
#define SH73A0_PIN_I_PU(pin)		SH_PFC_PIN_CFG(pin, __I | __PU)
#define SH73A0_PIN_I_PU_PD(pin)		SH_PFC_PIN_CFG(pin, __I | __PUD)
#define SH73A0_PIN_IO(pin)		SH_PFC_PIN_CFG(pin, __IO)
#define SH73A0_PIN_IO_PD(pin)		SH_PFC_PIN_CFG(pin, __IO | __PD)
#define SH73A0_PIN_IO_PU(pin)		SH_PFC_PIN_CFG(pin, __IO | __PU)
#define SH73A0_PIN_IO_PU_PD(pin)	SH_PFC_PIN_CFG(pin, __IO | __PUD)
#define SH73A0_PIN_O(pin)		SH_PFC_PIN_CFG(pin, __O)

/* Pin numbers for pins without a corresponding GPIO port number are computed
 * from the row and column numbers with a 1000 offset to avoid collisions with
 * GPIO port numbers.
 */
#define PIN_NUMBER(row, col)		(1000+((row)-1)*34+(col)-1)

static const struct sh_pfc_pin pinmux_pins[] = {
	/* Table 25-1 (I/O and Pull U/D) */
	SH73A0_PIN_I_PD(0),
	SH73A0_PIN_I_PU(1),
	SH73A0_PIN_I_PU(2),
	SH73A0_PIN_I_PU(3),
	SH73A0_PIN_I_PU(4),
	SH73A0_PIN_I_PU(5),
	SH73A0_PIN_I_PU(6),
	SH73A0_PIN_I_PU(7),
	SH73A0_PIN_I_PU(8),
	SH73A0_PIN_I_PD(9),
	SH73A0_PIN_I_PD(10),
	SH73A0_PIN_I_PU_PD(11),
	SH73A0_PIN_IO_PU_PD(12),
	SH73A0_PIN_IO_PU_PD(13),
	SH73A0_PIN_IO_PU_PD(14),
	SH73A0_PIN_IO_PU_PD(15),
	SH73A0_PIN_IO_PD(16),
	SH73A0_PIN_IO_PD(17),
	SH73A0_PIN_IO_PU(18),
	SH73A0_PIN_IO_PU(19),
	SH73A0_PIN_O(20),
	SH73A0_PIN_O(21),
	SH73A0_PIN_O(22),
	SH73A0_PIN_O(23),
	SH73A0_PIN_O(24),
	SH73A0_PIN_I_PD(25),
	SH73A0_PIN_I_PD(26),
	SH73A0_PIN_IO_PU(27),
	SH73A0_PIN_IO_PU(28),
	SH73A0_PIN_IO_PD(29),
	SH73A0_PIN_IO_PD(30),
	SH73A0_PIN_IO_PU(31),
	SH73A0_PIN_IO_PD(32),
	SH73A0_PIN_I_PU_PD(33),
	SH73A0_PIN_IO_PD(34),
	SH73A0_PIN_I_PU_PD(35),
	SH73A0_PIN_IO_PD(36),
	SH73A0_PIN_IO(37),
	SH73A0_PIN_O(38),
	SH73A0_PIN_I_PU(39),
	SH73A0_PIN_I_PU_PD(40),
	SH73A0_PIN_O(41),
	SH73A0_PIN_IO_PD(42),
	SH73A0_PIN_IO_PU_PD(43),
	SH73A0_PIN_IO_PU_PD(44),
	SH73A0_PIN_IO_PD(45),
	SH73A0_PIN_IO_PD(46),
	SH73A0_PIN_IO_PD(47),
	SH73A0_PIN_I_PD(48),
	SH73A0_PIN_IO_PU_PD(49),
	SH73A0_PIN_IO_PD(50),
	SH73A0_PIN_IO_PD(51),
	SH73A0_PIN_O(52),
	SH73A0_PIN_IO_PU_PD(53),
	SH73A0_PIN_IO_PU_PD(54),
	SH73A0_PIN_IO_PD(55),
	SH73A0_PIN_I_PU_PD(56),
	SH73A0_PIN_IO(57),
	SH73A0_PIN_IO(58),
	SH73A0_PIN_IO(59),
	SH73A0_PIN_IO(60),
	SH73A0_PIN_IO(61),
	SH73A0_PIN_IO_PD(62),
	SH73A0_PIN_IO_PD(63),
	SH73A0_PIN_IO_PU_PD(64),
	SH73A0_PIN_IO_PD(65),
	SH73A0_PIN_IO_PU_PD(66),
	SH73A0_PIN_IO_PU_PD(67),
	SH73A0_PIN_IO_PU_PD(68),
	SH73A0_PIN_IO_PU_PD(69),
	SH73A0_PIN_IO_PU_PD(70),
	SH73A0_PIN_IO_PU_PD(71),
	SH73A0_PIN_IO_PU_PD(72),
	SH73A0_PIN_I_PU_PD(73),
	SH73A0_PIN_IO_PU(74),
	SH73A0_PIN_IO_PU(75),
	SH73A0_PIN_IO_PU(76),
	SH73A0_PIN_IO_PU(77),
	SH73A0_PIN_IO_PU(78),
	SH73A0_PIN_IO_PU(79),
	SH73A0_PIN_IO_PU(80),
	SH73A0_PIN_IO_PU(81),
	SH73A0_PIN_IO_PU(82),
	SH73A0_PIN_IO_PU(83),
	SH73A0_PIN_IO_PU(84),
	SH73A0_PIN_IO_PU(85),
	SH73A0_PIN_IO_PU(86),
	SH73A0_PIN_IO_PU(87),
	SH73A0_PIN_IO_PU(88),
	SH73A0_PIN_IO_PU(89),
	SH73A0_PIN_O(90),
	SH73A0_PIN_IO_PU(91),
	SH73A0_PIN_O(92),
	SH73A0_PIN_IO_PU(93),
	SH73A0_PIN_O(94),
	SH73A0_PIN_I_PU_PD(95),
	SH73A0_PIN_IO(96),
	SH73A0_PIN_IO(97),
	SH73A0_PIN_IO(98),
	SH73A0_PIN_I_PU(99),
	SH73A0_PIN_O(100),
	SH73A0_PIN_O(101),
	SH73A0_PIN_I_PU(102),
	SH73A0_PIN_IO_PD(103),
	SH73A0_PIN_I_PU_PD(104),
	SH73A0_PIN_I_PD(105),
	SH73A0_PIN_I_PD(106),
	SH73A0_PIN_I_PU_PD(107),
	SH73A0_PIN_I_PU_PD(108),
	SH73A0_PIN_IO_PD(109),
	SH73A0_PIN_IO_PD(110),
	SH73A0_PIN_IO_PU_PD(111),
	SH73A0_PIN_IO_PU_PD(112),
	SH73A0_PIN_IO_PU_PD(113),
	SH73A0_PIN_IO_PD(114),
	SH73A0_PIN_IO_PU(115),
	SH73A0_PIN_IO_PU(116),
	SH73A0_PIN_IO_PU_PD(117),
	SH73A0_PIN_IO_PU_PD(118),
	SH73A0_PIN_IO_PD(128),
	SH73A0_PIN_IO_PD(129),
	SH73A0_PIN_IO_PU_PD(130),
	SH73A0_PIN_IO_PD(131),
	SH73A0_PIN_IO_PD(132),
	SH73A0_PIN_IO_PD(133),
	SH73A0_PIN_IO_PU_PD(134),
	SH73A0_PIN_IO_PU_PD(135),
	SH73A0_PIN_IO_PU_PD(136),
	SH73A0_PIN_IO_PU_PD(137),
	SH73A0_PIN_IO_PD(138),
	SH73A0_PIN_IO_PD(139),
	SH73A0_PIN_IO_PD(140),
	SH73A0_PIN_IO_PD(141),
	SH73A0_PIN_IO_PD(142),
	SH73A0_PIN_IO_PD(143),
	SH73A0_PIN_IO_PU_PD(144),
	SH73A0_PIN_IO_PD(145),
	SH73A0_PIN_IO_PU_PD(146),
	SH73A0_PIN_IO_PU_PD(147),
	SH73A0_PIN_IO_PU_PD(148),
	SH73A0_PIN_IO_PU_PD(149),
	SH73A0_PIN_I_PU_PD(150),
	SH73A0_PIN_IO_PU_PD(151),
	SH73A0_PIN_IO_PU_PD(152),
	SH73A0_PIN_IO_PD(153),
	SH73A0_PIN_IO_PD(154),
	SH73A0_PIN_I_PU_PD(155),
	SH73A0_PIN_IO_PU_PD(156),
	SH73A0_PIN_I_PD(157),
	SH73A0_PIN_IO_PD(158),
	SH73A0_PIN_IO_PU_PD(159),
	SH73A0_PIN_IO_PU_PD(160),
	SH73A0_PIN_I_PU_PD(161),
	SH73A0_PIN_I_PU_PD(162),
	SH73A0_PIN_IO_PU_PD(163),
	SH73A0_PIN_I_PU_PD(164),
	SH73A0_PIN_IO_PD(192),
	SH73A0_PIN_IO_PU_PD(193),
	SH73A0_PIN_IO_PD(194),
	SH73A0_PIN_IO_PU_PD(195),
	SH73A0_PIN_IO_PD(196),
	SH73A0_PIN_IO_PD(197),
	SH73A0_PIN_IO_PD(198),
	SH73A0_PIN_IO_PD(199),
	SH73A0_PIN_IO_PU_PD(200),
	SH73A0_PIN_IO_PU_PD(201),
	SH73A0_PIN_IO_PU_PD(202),
	SH73A0_PIN_IO_PU_PD(203),
	SH73A0_PIN_IO_PU_PD(204),
	SH73A0_PIN_IO_PU_PD(205),
	SH73A0_PIN_IO_PU_PD(206),
	SH73A0_PIN_IO_PD(207),
	SH73A0_PIN_IO_PD(208),
	SH73A0_PIN_IO_PD(209),
	SH73A0_PIN_IO_PD(210),
	SH73A0_PIN_IO_PD(211),
	SH73A0_PIN_IO_PD(212),
	SH73A0_PIN_IO_PD(213),
	SH73A0_PIN_IO_PU_PD(214),
	SH73A0_PIN_IO_PU_PD(215),
	SH73A0_PIN_IO_PD(216),
	SH73A0_PIN_IO_PD(217),
	SH73A0_PIN_O(218),
	SH73A0_PIN_IO_PD(219),
	SH73A0_PIN_IO_PD(220),
	SH73A0_PIN_IO_PU_PD(221),
	SH73A0_PIN_IO_PU_PD(222),
	SH73A0_PIN_I_PU_PD(223),
	SH73A0_PIN_I_PU_PD(224),
	SH73A0_PIN_IO_PU_PD(225),
	SH73A0_PIN_O(226),
	SH73A0_PIN_IO_PU_PD(227),
	SH73A0_PIN_I_PU_PD(228),
	SH73A0_PIN_I_PD(229),
	SH73A0_PIN_IO(230),
	SH73A0_PIN_IO_PU_PD(231),
	SH73A0_PIN_IO_PU_PD(232),
	SH73A0_PIN_I_PU_PD(233),
	SH73A0_PIN_IO_PU_PD(234),
	SH73A0_PIN_IO_PU_PD(235),
	SH73A0_PIN_IO_PU_PD(236),
	SH73A0_PIN_IO_PD(237),
	SH73A0_PIN_IO_PU_PD(238),
	SH73A0_PIN_IO_PU_PD(239),
	SH73A0_PIN_IO_PU_PD(240),
	SH73A0_PIN_O(241),
	SH73A0_PIN_I_PD(242),
	SH73A0_PIN_IO_PU_PD(243),
	SH73A0_PIN_IO_PU_PD(244),
	SH73A0_PIN_IO_PU_PD(245),
	SH73A0_PIN_IO_PU_PD(246),
	SH73A0_PIN_IO_PU_PD(247),
	SH73A0_PIN_IO_PU_PD(248),
	SH73A0_PIN_IO_PU_PD(249),
	SH73A0_PIN_IO_PU_PD(250),
	SH73A0_PIN_IO_PU_PD(251),
	SH73A0_PIN_IO_PU_PD(252),
	SH73A0_PIN_IO_PU_PD(253),
	SH73A0_PIN_IO_PU_PD(254),
	SH73A0_PIN_IO_PU_PD(255),
	SH73A0_PIN_IO_PU_PD(256),
	SH73A0_PIN_IO_PU_PD(257),
	SH73A0_PIN_IO_PU_PD(258),
	SH73A0_PIN_IO_PU_PD(259),
	SH73A0_PIN_IO_PU_PD(260),
	SH73A0_PIN_IO_PU_PD(261),
	SH73A0_PIN_IO_PU_PD(262),
	SH73A0_PIN_IO_PU_PD(263),
	SH73A0_PIN_IO_PU_PD(264),
	SH73A0_PIN_IO_PU_PD(265),
	SH73A0_PIN_IO_PU_PD(266),
	SH73A0_PIN_IO_PU_PD(267),
	SH73A0_PIN_IO_PU_PD(268),
	SH73A0_PIN_IO_PU_PD(269),
	SH73A0_PIN_IO_PU_PD(270),
	SH73A0_PIN_IO_PU_PD(271),
	SH73A0_PIN_IO_PU_PD(272),
	SH73A0_PIN_IO_PU_PD(273),
	SH73A0_PIN_IO_PU_PD(274),
	SH73A0_PIN_IO_PU_PD(275),
	SH73A0_PIN_IO_PU_PD(276),
	SH73A0_PIN_IO_PU_PD(277),
	SH73A0_PIN_IO_PU_PD(278),
	SH73A0_PIN_IO_PU_PD(279),
	SH73A0_PIN_IO_PU_PD(280),
	SH73A0_PIN_O(281),
	SH73A0_PIN_O(282),
	SH73A0_PIN_I_PU(288),
	SH73A0_PIN_IO_PU_PD(289),
	SH73A0_PIN_IO_PU_PD(290),
	SH73A0_PIN_IO_PU_PD(291),
	SH73A0_PIN_IO_PU_PD(292),
	SH73A0_PIN_IO_PU_PD(293),
	SH73A0_PIN_IO_PU_PD(294),
	SH73A0_PIN_IO_PU_PD(295),
	SH73A0_PIN_IO_PU_PD(296),
	SH73A0_PIN_IO_PU_PD(297),
	SH73A0_PIN_IO_PU_PD(298),
	SH73A0_PIN_IO_PU_PD(299),
	SH73A0_PIN_IO_PU_PD(300),
	SH73A0_PIN_IO_PU_PD(301),
	SH73A0_PIN_IO_PU_PD(302),
	SH73A0_PIN_IO_PU_PD(303),
	SH73A0_PIN_IO_PU_PD(304),
	SH73A0_PIN_IO_PU_PD(305),
	SH73A0_PIN_O(306),
	SH73A0_PIN_O(307),
	SH73A0_PIN_I_PU(308),
	SH73A0_PIN_O(309),

	/* Pins not associated with a GPIO port */
	SH_PFC_PIN_NAMED(6, 26, F26),
};

/* - BSC -------------------------------------------------------------------- */
static const unsigned int bsc_data_0_7_pins[] = {
	/* D[0:7] */
	74, 75, 76, 77, 78, 79, 80, 81,
};
static const unsigned int bsc_data_0_7_mux[] = {
	D0_NAF0_MARK, D1_NAF1_MARK, D2_NAF2_MARK, D3_NAF3_MARK,
	D4_NAF4_MARK, D5_NAF5_MARK, D6_NAF6_MARK, D7_NAF7_MARK,
};
static const unsigned int bsc_data_8_15_pins[] = {
	/* D[8:15] */
	82, 83, 84, 85, 86, 87, 88, 89,
};
static const unsigned int bsc_data_8_15_mux[] = {
	D8_NAF8_MARK, D9_NAF9_MARK, D10_NAF10_MARK, D11_NAF11_MARK,
	D12_NAF12_MARK, D13_NAF13_MARK, D14_NAF14_MARK, D15_NAF15_MARK,
};
static const unsigned int bsc_cs4_pins[] = {
	/* CS */
	90,
};
static const unsigned int bsc_cs4_mux[] = {
	CS4__MARK,
};
static const unsigned int bsc_cs5_a_pins[] = {
	/* CS */
	91,
};
static const unsigned int bsc_cs5_a_mux[] = {
	CS5A__MARK,
};
static const unsigned int bsc_cs5_b_pins[] = {
	/* CS */
	92,
};
static const unsigned int bsc_cs5_b_mux[] = {
	CS5B__MARK,
};
static const unsigned int bsc_cs6_a_pins[] = {
	/* CS */
	94,
};
static const unsigned int bsc_cs6_a_mux[] = {
	CS6A__MARK,
};
static const unsigned int bsc_cs6_b_pins[] = {
	/* CS */
	93,
};
static const unsigned int bsc_cs6_b_mux[] = {
	CS6B__MARK,
};
static const unsigned int bsc_rd_pins[] = {
	/* RD */
	96,
};
static const unsigned int bsc_rd_mux[] = {
	RD__FSC_MARK,
};
static const unsigned int bsc_rdwr_0_pins[] = {
	/* RDWR */
	91,
};
static const unsigned int bsc_rdwr_0_mux[] = {
	PORT91_RDWR_MARK,
};
static const unsigned int bsc_rdwr_1_pins[] = {
	/* RDWR */
	97,
};
static const unsigned int bsc_rdwr_1_mux[] = {
	RDWR_FWE_MARK,
};
static const unsigned int bsc_rdwr_2_pins[] = {
	/* RDWR */
	149,
};
static const unsigned int bsc_rdwr_2_mux[] = {
	PORT149_RDWR_MARK,
};
static const unsigned int bsc_we0_pins[] = {
	/* WE0 */
	97,
};
static const unsigned int bsc_we0_mux[] = {
	WE0__FWE_MARK,
};
static const unsigned int bsc_we1_pins[] = {
	/* WE1 */
	98,
};
static const unsigned int bsc_we1_mux[] = {
	WE1__MARK,
};
/* - FSIA ------------------------------------------------------------------- */
static const unsigned int fsia_mclk_in_pins[] = {
	/* CK */
	49,
};
static const unsigned int fsia_mclk_in_mux[] = {
	FSIACK_MARK,
};
static const unsigned int fsia_mclk_out_pins[] = {
	/* OMC */
	49,
};
static const unsigned int fsia_mclk_out_mux[] = {
	FSIAOMC_MARK,
};
static const unsigned int fsia_sclk_in_pins[] = {
	/* ILR, IBT */
	50, 51,
};
static const unsigned int fsia_sclk_in_mux[] = {
	FSIAILR_MARK, FSIAIBT_MARK,
};
static const unsigned int fsia_sclk_out_pins[] = {
	/* OLR, OBT */
	50, 51,
};
static const unsigned int fsia_sclk_out_mux[] = {
	FSIAOLR_MARK, FSIAOBT_MARK,
};
static const unsigned int fsia_data_in_pins[] = {
	/* ISLD */
	55,
};
static const unsigned int fsia_data_in_mux[] = {
	FSIAISLD_MARK,
};
static const unsigned int fsia_data_out_pins[] = {
	/* OSLD */
	52,
};
static const unsigned int fsia_data_out_mux[] = {
	FSIAOSLD_MARK,
};
static const unsigned int fsia_spdif_pins[] = {
	/* SPDIF */
	53,
};
static const unsigned int fsia_spdif_mux[] = {
	FSIASPDIF_MARK,
};
/* - FSIB ------------------------------------------------------------------- */
static const unsigned int fsib_mclk_in_pins[] = {
	/* CK */
	54,
};
static const unsigned int fsib_mclk_in_mux[] = {
	FSIBCK_MARK,
};
static const unsigned int fsib_mclk_out_pins[] = {
	/* OMC */
	54,
};
static const unsigned int fsib_mclk_out_mux[] = {
	FSIBOMC_MARK,
};
static const unsigned int fsib_sclk_in_pins[] = {
	/* ILR, IBT */
	37, 36,
};
static const unsigned int fsib_sclk_in_mux[] = {
	FSIBILR_MARK, FSIBIBT_MARK,
};
static const unsigned int fsib_sclk_out_pins[] = {
	/* OLR, OBT */
	37, 36,
};
static const unsigned int fsib_sclk_out_mux[] = {
	FSIBOLR_MARK, FSIBOBT_MARK,
};
static const unsigned int fsib_data_in_pins[] = {
	/* ISLD */
	39,
};
static const unsigned int fsib_data_in_mux[] = {
	FSIBISLD_MARK,
};
static const unsigned int fsib_data_out_pins[] = {
	/* OSLD */
	38,
};
static const unsigned int fsib_data_out_mux[] = {
	FSIBOSLD_MARK,
};
static const unsigned int fsib_spdif_pins[] = {
	/* SPDIF */
	53,
};
static const unsigned int fsib_spdif_mux[] = {
	FSIBSPDIF_MARK,
};
/* - FSIC ------------------------------------------------------------------- */
static const unsigned int fsic_mclk_in_pins[] = {
	/* CK */
	54,
};
static const unsigned int fsic_mclk_in_mux[] = {
	FSICCK_MARK,
};
static const unsigned int fsic_mclk_out_pins[] = {
	/* OMC */
	54,
};
static const unsigned int fsic_mclk_out_mux[] = {
	FSICOMC_MARK,
};
static const unsigned int fsic_sclk_in_pins[] = {
	/* ILR, IBT */
	46, 45,
};
static const unsigned int fsic_sclk_in_mux[] = {
	FSICILR_MARK, FSICIBT_MARK,
};
static const unsigned int fsic_sclk_out_pins[] = {
	/* OLR, OBT */
	46, 45,
};
static const unsigned int fsic_sclk_out_mux[] = {
	FSICOLR_MARK, FSICOBT_MARK,
};
static const unsigned int fsic_data_in_pins[] = {
	/* ISLD */
	48,
};
static const unsigned int fsic_data_in_mux[] = {
	FSICISLD_MARK,
};
static const unsigned int fsic_data_out_pins[] = {
	/* OSLD, OSLDT1, OSLDT2, OSLDT3 */
	47, 44, 42, 16,
};
static const unsigned int fsic_data_out_mux[] = {
	FSICOSLD_MARK, FSICOSLDT1_MARK, FSICOSLDT2_MARK, FSICOSLDT3_MARK,
};
static const unsigned int fsic_spdif_0_pins[] = {
	/* SPDIF */
	53,
};
static const unsigned int fsic_spdif_0_mux[] = {
	PORT53_FSICSPDIF_MARK,
};
static const unsigned int fsic_spdif_1_pins[] = {
	/* SPDIF */
	47,
};
static const unsigned int fsic_spdif_1_mux[] = {
	PORT47_FSICSPDIF_MARK,
};
/* - FSID ------------------------------------------------------------------- */
static const unsigned int fsid_sclk_in_pins[] = {
	/* ILR, IBT */
	46, 45,
};
static const unsigned int fsid_sclk_in_mux[] = {
	FSIDILR_MARK, FSIDIBT_MARK,
};
static const unsigned int fsid_sclk_out_pins[] = {
	/* OLR, OBT */
	46, 45,
};
static const unsigned int fsid_sclk_out_mux[] = {
	FSIDOLR_MARK, FSIDOBT_MARK,
};
static const unsigned int fsid_data_in_pins[] = {
	/* ISLD */
	48,
};
static const unsigned int fsid_data_in_mux[] = {
	FSIDISLD_MARK,
};
/* - I2C2 ------------------------------------------------------------------- */
static const unsigned int i2c2_0_pins[] = {
	/* SCL, SDA */
	237, 236,
};
static const unsigned int i2c2_0_mux[] = {
	PORT237_I2C_SCL2_MARK, PORT236_I2C_SDA2_MARK,
};
static const unsigned int i2c2_1_pins[] = {
	/* SCL, SDA */
	27, 28,
};
static const unsigned int i2c2_1_mux[] = {
	PORT27_I2C_SCL2_MARK, PORT28_I2C_SDA2_MARK,
};
static const unsigned int i2c2_2_pins[] = {
	/* SCL, SDA */
	115, 116,
};
static const unsigned int i2c2_2_mux[] = {
	PORT115_I2C_SCL2_MARK, PORT116_I2C_SDA2_MARK,
};
/* - I2C3 ------------------------------------------------------------------- */
static const unsigned int i2c3_0_pins[] = {
	/* SCL, SDA */
	248, 249,
};
static const unsigned int i2c3_0_mux[] = {
	PORT248_I2C_SCL3_MARK, PORT249_I2C_SDA3_MARK,
};
static const unsigned int i2c3_1_pins[] = {
	/* SCL, SDA */
	27, 28,
};
static const unsigned int i2c3_1_mux[] = {
	PORT27_I2C_SCL3_MARK, PORT28_I2C_SDA3_MARK,
};
static const unsigned int i2c3_2_pins[] = {
	/* SCL, SDA */
	115, 116,
};
static const unsigned int i2c3_2_mux[] = {
	PORT115_I2C_SCL3_MARK, PORT116_I2C_SDA3_MARK,
};
/* - IrDA ------------------------------------------------------------------- */
static const unsigned int irda_0_pins[] = {
	/* OUT, IN, FIRSEL */
	241, 242, 243,
};
static const unsigned int irda_0_mux[] = {
	PORT241_IRDA_OUT_MARK, PORT242_IRDA_IN_MARK, PORT243_IRDA_FIRSEL_MARK,
};
static const unsigned int irda_1_pins[] = {
	/* OUT, IN, FIRSEL */
	49, 53, 54,
};
static const unsigned int irda_1_mux[] = {
	PORT49_IRDA_OUT_MARK, PORT53_IRDA_IN_MARK, PORT54_IRDA_FIRSEL_MARK,
};
/* - KEYSC ------------------------------------------------------------------ */
static const unsigned int keysc_in5_pins[] = {
	/* KEYIN[0:4] */
	66, 67, 68, 69, 70,
};
static const unsigned int keysc_in5_mux[] = {
	KEYIN0_MARK, KEYIN1_MARK, KEYIN2_MARK, KEYIN3_MARK,
	KEYIN4_MARK,
};
static const unsigned int keysc_in6_pins[] = {
	/* KEYIN[0:5] */
	66, 67, 68, 69, 70, 71,
};
static const unsigned int keysc_in6_mux[] = {
	KEYIN0_MARK, KEYIN1_MARK, KEYIN2_MARK, KEYIN3_MARK,
	KEYIN4_MARK, KEYIN5_MARK,
};
static const unsigned int keysc_in7_pins[] = {
	/* KEYIN[0:6] */
	66, 67, 68, 69, 70, 71, 72,
};
static const unsigned int keysc_in7_mux[] = {
	KEYIN0_MARK, KEYIN1_MARK, KEYIN2_MARK, KEYIN3_MARK,
	KEYIN4_MARK, KEYIN5_MARK, KEYIN6_MARK,
};
static const unsigned int keysc_in8_pins[] = {
	/* KEYIN[0:7] */
	66, 67, 68, 69, 70, 71, 72, 73,
};
static const unsigned int keysc_in8_mux[] = {
	KEYIN0_MARK, KEYIN1_MARK, KEYIN2_MARK, KEYIN3_MARK,
	KEYIN4_MARK, KEYIN5_MARK, KEYIN6_MARK, KEYIN7_MARK,
};
static const unsigned int keysc_out04_pins[] = {
	/* KEYOUT[0:4] */
	65, 64, 63, 62, 61,
};
static const unsigned int keysc_out04_mux[] = {
	KEYOUT0_MARK, KEYOUT1_MARK, KEYOUT2_MARK, KEYOUT3_MARK, KEYOUT4_MARK,
};
static const unsigned int keysc_out5_pins[] = {
	/* KEYOUT5 */
	60,
};
static const unsigned int keysc_out5_mux[] = {
	KEYOUT5_MARK,
};
static const unsigned int keysc_out6_0_pins[] = {
	/* KEYOUT6 */
	59,
};
static const unsigned int keysc_out6_0_mux[] = {
	PORT59_KEYOUT6_MARK,
};
static const unsigned int keysc_out6_1_pins[] = {
	/* KEYOUT6 */
	131,
};
static const unsigned int keysc_out6_1_mux[] = {
	PORT131_KEYOUT6_MARK,
};
static const unsigned int keysc_out6_2_pins[] = {
	/* KEYOUT6 */
	143,
};
static const unsigned int keysc_out6_2_mux[] = {
	PORT143_KEYOUT6_MARK,
};
static const unsigned int keysc_out7_0_pins[] = {
	/* KEYOUT7 */
	58,
};
static const unsigned int keysc_out7_0_mux[] = {
	PORT58_KEYOUT7_MARK,
};
static const unsigned int keysc_out7_1_pins[] = {
	/* KEYOUT7 */
	132,
};
static const unsigned int keysc_out7_1_mux[] = {
	PORT132_KEYOUT7_MARK,
};
static const unsigned int keysc_out7_2_pins[] = {
	/* KEYOUT7 */
	144,
};
static const unsigned int keysc_out7_2_mux[] = {
	PORT144_KEYOUT7_MARK,
};
static const unsigned int keysc_out8_0_pins[] = {
	/* KEYOUT8 */
	PIN_NUMBER(6, 26),
};
static const unsigned int keysc_out8_0_mux[] = {
	KEYOUT8_MARK,
};
static const unsigned int keysc_out8_1_pins[] = {
	/* KEYOUT8 */
	136,
};
static const unsigned int keysc_out8_1_mux[] = {
	PORT136_KEYOUT8_MARK,
};
static const unsigned int keysc_out8_2_pins[] = {
	/* KEYOUT8 */
	138,
};
static const unsigned int keysc_out8_2_mux[] = {
	PORT138_KEYOUT8_MARK,
};
static const unsigned int keysc_out9_0_pins[] = {
	/* KEYOUT9 */
	137,
};
static const unsigned int keysc_out9_0_mux[] = {
	PORT137_KEYOUT9_MARK,
};
static const unsigned int keysc_out9_1_pins[] = {
	/* KEYOUT9 */
	139,
};
static const unsigned int keysc_out9_1_mux[] = {
	PORT139_KEYOUT9_MARK,
};
static const unsigned int keysc_out9_2_pins[] = {
	/* KEYOUT9 */
	149,
};
static const unsigned int keysc_out9_2_mux[] = {
	PORT149_KEYOUT9_MARK,
};
static const unsigned int keysc_out10_0_pins[] = {
	/* KEYOUT10 */
	132,
};
static const unsigned int keysc_out10_0_mux[] = {
	PORT132_KEYOUT10_MARK,
};
static const unsigned int keysc_out10_1_pins[] = {
	/* KEYOUT10 */
	142,
};
static const unsigned int keysc_out10_1_mux[] = {
	PORT142_KEYOUT10_MARK,
};
static const unsigned int keysc_out11_0_pins[] = {
	/* KEYOUT11 */
	131,
};
static const unsigned int keysc_out11_0_mux[] = {
	PORT131_KEYOUT11_MARK,
};
static const unsigned int keysc_out11_1_pins[] = {
	/* KEYOUT11 */
	143,
};
static const unsigned int keysc_out11_1_mux[] = {
	PORT143_KEYOUT11_MARK,
};
/* - LCD -------------------------------------------------------------------- */
static const unsigned int lcd_data8_pins[] = {
	/* D[0:7] */
	192, 193, 194, 195, 196, 197, 198, 199,
};
static const unsigned int lcd_data8_mux[] = {
	LCDD0_MARK, LCDD1_MARK, LCDD2_MARK, LCDD3_MARK,
	LCDD4_MARK, LCDD5_MARK, LCDD6_MARK, LCDD7_MARK,
};
static const unsigned int lcd_data9_pins[] = {
	/* D[0:8] */
	192, 193, 194, 195, 196, 197, 198, 199,
	200,
};
static const unsigned int lcd_data9_mux[] = {
	LCDD0_MARK, LCDD1_MARK, LCDD2_MARK, LCDD3_MARK,
	LCDD4_MARK, LCDD5_MARK, LCDD6_MARK, LCDD7_MARK,
	LCDD8_MARK,
};
static const unsigned int lcd_data12_pins[] = {
	/* D[0:11] */
	192, 193, 194, 195, 196, 197, 198, 199,
	200, 201, 202, 203,
};
static const unsigned int lcd_data12_mux[] = {
	LCDD0_MARK, LCDD1_MARK, LCDD2_MARK, LCDD3_MARK,
	LCDD4_MARK, LCDD5_MARK, LCDD6_MARK, LCDD7_MARK,
	LCDD8_MARK, LCDD9_MARK, LCDD10_MARK, LCDD11_MARK,
};
static const unsigned int lcd_data16_pins[] = {
	/* D[0:15] */
	192, 193, 194, 195, 196, 197, 198, 199,
	200, 201, 202, 203, 204, 205, 206, 207,
};
static const unsigned int lcd_data16_mux[] = {
	LCDD0_MARK, LCDD1_MARK, LCDD2_MARK, LCDD3_MARK,
	LCDD4_MARK, LCDD5_MARK, LCDD6_MARK, LCDD7_MARK,
	LCDD8_MARK, LCDD9_MARK, LCDD10_MARK, LCDD11_MARK,
	LCDD12_MARK, LCDD13_MARK, LCDD14_MARK, LCDD15_MARK,
};
static const unsigned int lcd_data18_pins[] = {
	/* D[0:17] */
	192, 193, 194, 195, 196, 197, 198, 199,
	200, 201, 202, 203, 204, 205, 206, 207,
	208, 209,
};
static const unsigned int lcd_data18_mux[] = {
	LCDD0_MARK, LCDD1_MARK, LCDD2_MARK, LCDD3_MARK,
	LCDD4_MARK, LCDD5_MARK, LCDD6_MARK, LCDD7_MARK,
	LCDD8_MARK, LCDD9_MARK, LCDD10_MARK, LCDD11_MARK,
	LCDD12_MARK, LCDD13_MARK, LCDD14_MARK, LCDD15_MARK,
	LCDD16_MARK, LCDD17_MARK,
};
static const unsigned int lcd_data24_pins[] = {
	/* D[0:23] */
	192, 193, 194, 195, 196, 197, 198, 199,
	200, 201, 202, 203, 204, 205, 206, 207,
	208, 209, 210, 211, 212, 213, 214, 215
};
static const unsigned int lcd_data24_mux[] = {
	LCDD0_MARK, LCDD1_MARK, LCDD2_MARK, LCDD3_MARK,
	LCDD4_MARK, LCDD5_MARK, LCDD6_MARK, LCDD7_MARK,
	LCDD8_MARK, LCDD9_MARK, LCDD10_MARK, LCDD11_MARK,
	LCDD12_MARK, LCDD13_MARK, LCDD14_MARK, LCDD15_MARK,
	LCDD16_MARK, LCDD17_MARK, LCDD18_MARK, LCDD19_MARK,
	LCDD20_MARK, LCDD21_MARK, LCDD22_MARK, LCDD23_MARK,
};
static const unsigned int lcd_display_pins[] = {
	/* DON */
	222,
};
static const unsigned int lcd_display_mux[] = {
	LCDDON_MARK,
};
static const unsigned int lcd_lclk_pins[] = {
	/* LCLK */
	221,
};
static const unsigned int lcd_lclk_mux[] = {
	LCDLCLK_MARK,
};
static const unsigned int lcd_sync_pins[] = {
	/* VSYN, HSYN, DCK, DISP */
	220, 218, 216, 219,
};
static const unsigned int lcd_sync_mux[] = {
	LCDVSYN_MARK, LCDHSYN_MARK, LCDDCK_MARK, LCDDISP_MARK,
};
static const unsigned int lcd_sys_pins[] = {
	/* CS, WR, RD, RS */
	218, 216, 217, 219,
};
static const unsigned int lcd_sys_mux[] = {
	LCDCS__MARK, LCDWR__MARK, LCDRD__MARK, LCDRS_MARK,
};
/* - LCD2 ------------------------------------------------------------------- */
static const unsigned int lcd2_data8_pins[] = {
	/* D[0:7] */
	128, 129, 142, 143, 144, 145, 138, 139,
};
static const unsigned int lcd2_data8_mux[] = {
	LCD2D0_MARK, LCD2D1_MARK, LCD2D2_MARK, LCD2D3_MARK,
	LCD2D4_MARK, LCD2D5_MARK, LCD2D6_MARK, LCD2D7_MARK,
};
static const unsigned int lcd2_data9_pins[] = {
	/* D[0:8] */
	128, 129, 142, 143, 144, 145, 138, 139,
	140,
};
static const unsigned int lcd2_data9_mux[] = {
	LCD2D0_MARK, LCD2D1_MARK, LCD2D2_MARK, LCD2D3_MARK,
	LCD2D4_MARK, LCD2D5_MARK, LCD2D6_MARK, LCD2D7_MARK,
	LCD2D8_MARK,
};
static const unsigned int lcd2_data12_pins[] = {
	/* D[0:12] */
	128, 129, 142, 143, 144, 145, 138, 139,
	140, 141, 130, 131,
};
static const unsigned int lcd2_data12_mux[] = {
	LCD2D0_MARK, LCD2D1_MARK, LCD2D2_MARK, LCD2D3_MARK,
	LCD2D4_MARK, LCD2D5_MARK, LCD2D6_MARK, LCD2D7_MARK,
	LCD2D8_MARK, LCD2D9_MARK, LCD2D10_MARK, LCD2D11_MARK,
};
static const unsigned int lcd2_data16_pins[] = {
	/* D[0:15] */
	128, 129, 142, 143, 144, 145, 138, 139,
	140, 141, 130, 131, 132, 133, 134, 135,
};
static const unsigned int lcd2_data16_mux[] = {
	LCD2D0_MARK, LCD2D1_MARK, LCD2D2_MARK, LCD2D3_MARK,
	LCD2D4_MARK, LCD2D5_MARK, LCD2D6_MARK, LCD2D7_MARK,
	LCD2D8_MARK, LCD2D9_MARK, LCD2D10_MARK, LCD2D11_MARK,
	LCD2D12_MARK, LCD2D13_MARK, LCD2D14_MARK, LCD2D15_MARK,
};
static const unsigned int lcd2_data18_pins[] = {
	/* D[0:17] */
	128, 129, 142, 143, 144, 145, 138, 139,
	140, 141, 130, 131, 132, 133, 134, 135,
	136, 137,
};
static const unsigned int lcd2_data18_mux[] = {
	LCD2D0_MARK, LCD2D1_MARK, LCD2D2_MARK, LCD2D3_MARK,
	LCD2D4_MARK, LCD2D5_MARK, LCD2D6_MARK, LCD2D7_MARK,
	LCD2D8_MARK, LCD2D9_MARK, LCD2D10_MARK, LCD2D11_MARK,
	LCD2D12_MARK, LCD2D13_MARK, LCD2D14_MARK, LCD2D15_MARK,
	LCD2D16_MARK, LCD2D17_MARK,
};
static const unsigned int lcd2_data24_pins[] = {
	/* D[0:23] */
	128, 129, 142, 143, 144, 145, 138, 139,
	140, 141, 130, 131, 132, 133, 134, 135,
	136, 137, 146, 147, 234, 235, 238, 239
};
static const unsigned int lcd2_data24_mux[] = {
	LCD2D0_MARK, LCD2D1_MARK, LCD2D2_MARK, LCD2D3_MARK,
	LCD2D4_MARK, LCD2D5_MARK, LCD2D6_MARK, LCD2D7_MARK,
	LCD2D8_MARK, LCD2D9_MARK, LCD2D10_MARK, LCD2D11_MARK,
	LCD2D12_MARK, LCD2D13_MARK, LCD2D14_MARK, LCD2D15_MARK,
	LCD2D16_MARK, LCD2D17_MARK, LCD2D18_MARK, LCD2D19_MARK,
	LCD2D20_MARK, LCD2D21_MARK, LCD2D22_MARK, LCD2D23_MARK,
};
static const unsigned int lcd2_sync_0_pins[] = {
	/* VSYN, HSYN, DCK, DISP */
	128, 129, 146, 145,
};
static const unsigned int lcd2_sync_0_mux[] = {
	PORT128_LCD2VSYN_MARK, PORT129_LCD2HSYN_MARK,
	LCD2DCK_MARK, PORT145_LCD2DISP_MARK,
};
static const unsigned int lcd2_sync_1_pins[] = {
	/* VSYN, HSYN, DCK, DISP */
	222, 221, 219, 217,
};
static const unsigned int lcd2_sync_1_mux[] = {
	PORT222_LCD2VSYN_MARK, PORT221_LCD2HSYN_MARK,
	LCD2DCK_2_MARK, PORT217_LCD2DISP_MARK,
};
static const unsigned int lcd2_sys_0_pins[] = {
	/* CS, WR, RD, RS */
	129, 146, 147, 145,
};
static const unsigned int lcd2_sys_0_mux[] = {
	PORT129_LCD2CS__MARK, PORT146_LCD2WR__MARK,
	LCD2RD__MARK, PORT145_LCD2RS_MARK,
};
static const unsigned int lcd2_sys_1_pins[] = {
	/* CS, WR, RD, RS */
	221, 219, 147, 217,
};
static const unsigned int lcd2_sys_1_mux[] = {
	PORT221_LCD2CS__MARK, PORT219_LCD2WR__MARK,
	LCD2RD__MARK, PORT217_LCD2RS_MARK,
};
/* - MMCIF ------------------------------------------------------------------ */
static const unsigned int mmc0_data1_0_pins[] = {
	/* D[0] */
	271,
};
static const unsigned int mmc0_data1_0_mux[] = {
	MMCD0_0_MARK,
};
static const unsigned int mmc0_data4_0_pins[] = {
	/* D[0:3] */
	271, 272, 273, 274,
};
static const unsigned int mmc0_data4_0_mux[] = {
	MMCD0_0_MARK, MMCD0_1_MARK, MMCD0_2_MARK, MMCD0_3_MARK,
};
static const unsigned int mmc0_data8_0_pins[] = {
	/* D[0:7] */
	271, 272, 273, 274, 275, 276, 277, 278,
};
static const unsigned int mmc0_data8_0_mux[] = {
	MMCD0_0_MARK, MMCD0_1_MARK, MMCD0_2_MARK, MMCD0_3_MARK,
	MMCD0_4_MARK, MMCD0_5_MARK, MMCD0_6_MARK, MMCD0_7_MARK,
};
static const unsigned int mmc0_ctrl_0_pins[] = {
	/* CMD, CLK */
	279, 270,
};
static const unsigned int mmc0_ctrl_0_mux[] = {
	MMCCMD0_MARK, MMCCLK0_MARK,
};

static const unsigned int mmc0_data1_1_pins[] = {
	/* D[0] */
	305,
};
static const unsigned int mmc0_data1_1_mux[] = {
	MMCD1_0_MARK,
};
static const unsigned int mmc0_data4_1_pins[] = {
	/* D[0:3] */
	305, 304, 303, 302,
};
static const unsigned int mmc0_data4_1_mux[] = {
	MMCD1_0_MARK, MMCD1_1_MARK, MMCD1_2_MARK, MMCD1_3_MARK,
};
static const unsigned int mmc0_data8_1_pins[] = {
	/* D[0:7] */
	305, 304, 303, 302, 301, 300, 299, 298,
};
static const unsigned int mmc0_data8_1_mux[] = {
	MMCD1_0_MARK, MMCD1_1_MARK, MMCD1_2_MARK, MMCD1_3_MARK,
	MMCD1_4_MARK, MMCD1_5_MARK, MMCD1_6_MARK, MMCD1_7_MARK,
};
static const unsigned int mmc0_ctrl_1_pins[] = {
	/* CMD, CLK */
	297, 289,
};
static const unsigned int mmc0_ctrl_1_mux[] = {
	MMCCMD1_MARK, MMCCLK1_MARK,
};
/* - SCIFA0 ----------------------------------------------------------------- */
static const unsigned int scifa0_data_pins[] = {
	/* RXD, TXD */
	43, 17,
};
static const unsigned int scifa0_data_mux[] = {
	SCIFA0_RXD_MARK, SCIFA0_TXD_MARK,
};
static const unsigned int scifa0_clk_pins[] = {
	/* SCK */
	16,
};
static const unsigned int scifa0_clk_mux[] = {
	SCIFA0_SCK_MARK,
};
static const unsigned int scifa0_ctrl_pins[] = {
	/* RTS, CTS */
	42, 44,
};
static const unsigned int scifa0_ctrl_mux[] = {
	SCIFA0_RTS__MARK, SCIFA0_CTS__MARK,
};
/* - SCIFA1 ----------------------------------------------------------------- */
static const unsigned int scifa1_data_pins[] = {
	/* RXD, TXD */
	228, 225,
};
static const unsigned int scifa1_data_mux[] = {
	SCIFA1_RXD_MARK, SCIFA1_TXD_MARK,
};
static const unsigned int scifa1_clk_pins[] = {
	/* SCK */
	226,
};
static const unsigned int scifa1_clk_mux[] = {
	SCIFA1_SCK_MARK,
};
static const unsigned int scifa1_ctrl_pins[] = {
	/* RTS, CTS */
	227, 229,
};
static const unsigned int scifa1_ctrl_mux[] = {
	SCIFA1_RTS__MARK, SCIFA1_CTS__MARK,
};
/* - SCIFA2 ----------------------------------------------------------------- */
static const unsigned int scifa2_data_0_pins[] = {
	/* RXD, TXD */
	155, 154,
};
static const unsigned int scifa2_data_0_mux[] = {
	SCIFA2_RXD1_MARK, SCIFA2_TXD1_MARK,
};
static const unsigned int scifa2_clk_0_pins[] = {
	/* SCK */
	158,
};
static const unsigned int scifa2_clk_0_mux[] = {
	SCIFA2_SCK1_MARK,
};
static const unsigned int scifa2_ctrl_0_pins[] = {
	/* RTS, CTS */
	156, 157,
};
static const unsigned int scifa2_ctrl_0_mux[] = {
	SCIFA2_RTS1__MARK, SCIFA2_CTS1__MARK,
};
static const unsigned int scifa2_data_1_pins[] = {
	/* RXD, TXD */
	233, 230,
};
static const unsigned int scifa2_data_1_mux[] = {
	SCIFA2_RXD2_MARK, SCIFA2_TXD2_MARK,
};
static const unsigned int scifa2_clk_1_pins[] = {
	/* SCK */
	232,
};
static const unsigned int scifa2_clk_1_mux[] = {
	SCIFA2_SCK2_MARK,
};
static const unsigned int scifa2_ctrl_1_pins[] = {
	/* RTS, CTS */
	234, 231,
};
static const unsigned int scifa2_ctrl_1_mux[] = {
	SCIFA2_RTS2__MARK, SCIFA2_CTS2__MARK,
};
/* - SCIFA3 ----------------------------------------------------------------- */
static const unsigned int scifa3_data_pins[] = {
	/* RXD, TXD */
	108, 110,
};
static const unsigned int scifa3_data_mux[] = {
	SCIFA3_RXD_MARK, SCIFA3_TXD_MARK,
};
static const unsigned int scifa3_ctrl_pins[] = {
	/* RTS, CTS */
	109, 107,
};
static const unsigned int scifa3_ctrl_mux[] = {
	SCIFA3_RTS__MARK, SCIFA3_CTS__MARK,
};
/* - SCIFA4 ----------------------------------------------------------------- */
static const unsigned int scifa4_data_pins[] = {
	/* RXD, TXD */
	33, 32,
};
static const unsigned int scifa4_data_mux[] = {
	SCIFA4_RXD_MARK, SCIFA4_TXD_MARK,
};
static const unsigned int scifa4_ctrl_pins[] = {
	/* RTS, CTS */
	34, 35,
};
static const unsigned int scifa4_ctrl_mux[] = {
	SCIFA4_RTS__MARK, SCIFA4_CTS__MARK,
};
/* - SCIFA5 ----------------------------------------------------------------- */
static const unsigned int scifa5_data_0_pins[] = {
	/* RXD, TXD */
	246, 247,
};
static const unsigned int scifa5_data_0_mux[] = {
	PORT246_SCIFA5_RXD_MARK, PORT247_SCIFA5_TXD_MARK,
};
static const unsigned int scifa5_clk_0_pins[] = {
	/* SCK */
	248,
};
static const unsigned int scifa5_clk_0_mux[] = {
	PORT248_SCIFA5_SCK_MARK,
};
static const unsigned int scifa5_ctrl_0_pins[] = {
	/* RTS, CTS */
	245, 244,
};
static const unsigned int scifa5_ctrl_0_mux[] = {
	PORT245_SCIFA5_RTS__MARK, PORT244_SCIFA5_CTS__MARK,
};
static const unsigned int scifa5_data_1_pins[] = {
	/* RXD, TXD */
	195, 196,
};
static const unsigned int scifa5_data_1_mux[] = {
	PORT195_SCIFA5_RXD_MARK, PORT196_SCIFA5_TXD_MARK,
};
static const unsigned int scifa5_clk_1_pins[] = {
	/* SCK */
	197,
};
static const unsigned int scifa5_clk_1_mux[] = {
	PORT197_SCIFA5_SCK_MARK,
};
static const unsigned int scifa5_ctrl_1_pins[] = {
	/* RTS, CTS */
	194, 193,
};
static const unsigned int scifa5_ctrl_1_mux[] = {
	PORT194_SCIFA5_RTS__MARK, PORT193_SCIFA5_CTS__MARK,
};
static const unsigned int scifa5_data_2_pins[] = {
	/* RXD, TXD */
	162, 160,
};
static const unsigned int scifa5_data_2_mux[] = {
	PORT162_SCIFA5_RXD_MARK, PORT160_SCIFA5_TXD_MARK,
};
static const unsigned int scifa5_clk_2_pins[] = {
	/* SCK */
	159,
};
static const unsigned int scifa5_clk_2_mux[] = {
	PORT159_SCIFA5_SCK_MARK,
};
static const unsigned int scifa5_ctrl_2_pins[] = {
	/* RTS, CTS */
	163, 161,
};
static const unsigned int scifa5_ctrl_2_mux[] = {
	PORT163_SCIFA5_RTS__MARK, PORT161_SCIFA5_CTS__MARK,
};
/* - SCIFA6 ----------------------------------------------------------------- */
static const unsigned int scifa6_pins[] = {
	/* TXD */
	240,
};
static const unsigned int scifa6_mux[] = {
	SCIFA6_TXD_MARK,
};
/* - SCIFA7 ----------------------------------------------------------------- */
static const unsigned int scifa7_data_pins[] = {
	/* RXD, TXD */
	12, 18,
};
static const unsigned int scifa7_data_mux[] = {
	SCIFA7_RXD_MARK, SCIFA7_TXD_MARK,
};
static const unsigned int scifa7_ctrl_pins[] = {
	/* RTS, CTS */
	19, 13,
};
static const unsigned int scifa7_ctrl_mux[] = {
	SCIFA7_RTS__MARK, SCIFA7_CTS__MARK,
};
/* - SCIFB ------------------------------------------------------------------ */
static const unsigned int scifb_data_0_pins[] = {
	/* RXD, TXD */
	162, 160,
};
static const unsigned int scifb_data_0_mux[] = {
	PORT162_SCIFB_RXD_MARK, PORT160_SCIFB_TXD_MARK,
};
static const unsigned int scifb_clk_0_pins[] = {
	/* SCK */
	159,
};
static const unsigned int scifb_clk_0_mux[] = {
	PORT159_SCIFB_SCK_MARK,
};
static const unsigned int scifb_ctrl_0_pins[] = {
	/* RTS, CTS */
	163, 161,
};
static const unsigned int scifb_ctrl_0_mux[] = {
	PORT163_SCIFB_RTS__MARK, PORT161_SCIFB_CTS__MARK,
};
static const unsigned int scifb_data_1_pins[] = {
	/* RXD, TXD */
	246, 247,
};
static const unsigned int scifb_data_1_mux[] = {
	PORT246_SCIFB_RXD_MARK, PORT247_SCIFB_TXD_MARK,
};
static const unsigned int scifb_clk_1_pins[] = {
	/* SCK */
	248,
};
static const unsigned int scifb_clk_1_mux[] = {
	PORT248_SCIFB_SCK_MARK,
};
static const unsigned int scifb_ctrl_1_pins[] = {
	/* RTS, CTS */
	245, 244,
};
static const unsigned int scifb_ctrl_1_mux[] = {
	PORT245_SCIFB_RTS__MARK, PORT244_SCIFB_CTS__MARK,
};
/* - SDHI0 ------------------------------------------------------------------ */
static const unsigned int sdhi0_data1_pins[] = {
	/* D0 */
	252,
};
static const unsigned int sdhi0_data1_mux[] = {
	SDHID0_0_MARK,
};
static const unsigned int sdhi0_data4_pins[] = {
	/* D[0:3] */
	252, 253, 254, 255,
};
static const unsigned int sdhi0_data4_mux[] = {
	SDHID0_0_MARK, SDHID0_1_MARK, SDHID0_2_MARK, SDHID0_3_MARK,
};
static const unsigned int sdhi0_ctrl_pins[] = {
	/* CMD, CLK */
	256, 250,
};
static const unsigned int sdhi0_ctrl_mux[] = {
	SDHICMD0_MARK, SDHICLK0_MARK,
};
static const unsigned int sdhi0_cd_pins[] = {
	/* CD */
	251,
};
static const unsigned int sdhi0_cd_mux[] = {
	SDHICD0_MARK,
};
static const unsigned int sdhi0_wp_pins[] = {
	/* WP */
	257,
};
static const unsigned int sdhi0_wp_mux[] = {
	SDHIWP0_MARK,
};
/* - SDHI1 ------------------------------------------------------------------ */
static const unsigned int sdhi1_data1_pins[] = {
	/* D0 */
	259,
};
static const unsigned int sdhi1_data1_mux[] = {
	SDHID1_0_MARK,
};
static const unsigned int sdhi1_data4_pins[] = {
	/* D[0:3] */
	259, 260, 261, 262,
};
static const unsigned int sdhi1_data4_mux[] = {
	SDHID1_0_MARK, SDHID1_1_MARK, SDHID1_2_MARK, SDHID1_3_MARK,
};
static const unsigned int sdhi1_ctrl_pins[] = {
	/* CMD, CLK */
	263, 258,
};
static const unsigned int sdhi1_ctrl_mux[] = {
	SDHICMD1_MARK, SDHICLK1_MARK,
};
/* - SDHI2 ------------------------------------------------------------------ */
static const unsigned int sdhi2_data1_pins[] = {
	/* D0 */
	265,
};
static const unsigned int sdhi2_data1_mux[] = {
	SDHID2_0_MARK,
};
static const unsigned int sdhi2_data4_pins[] = {
	/* D[0:3] */
	265, 266, 267, 268,
};
static const unsigned int sdhi2_data4_mux[] = {
	SDHID2_0_MARK, SDHID2_1_MARK, SDHID2_2_MARK, SDHID2_3_MARK,
};
static const unsigned int sdhi2_ctrl_pins[] = {
	/* CMD, CLK */
	269, 264,
};
static const unsigned int sdhi2_ctrl_mux[] = {
	SDHICMD2_MARK, SDHICLK2_MARK,
};
/* - TPU0 ------------------------------------------------------------------- */
static const unsigned int tpu0_to0_pins[] = {
	/* TO */
	55,
};
static const unsigned int tpu0_to0_mux[] = {
	TPU0TO0_MARK,
};
static const unsigned int tpu0_to1_pins[] = {
	/* TO */
	59,
};
static const unsigned int tpu0_to1_mux[] = {
	TPU0TO1_MARK,
};
static const unsigned int tpu0_to2_pins[] = {
	/* TO */
	140,
};
static const unsigned int tpu0_to2_mux[] = {
	TPU0TO2_MARK,
};
static const unsigned int tpu0_to3_pins[] = {
	/* TO */
	141,
};
static const unsigned int tpu0_to3_mux[] = {
	TPU0TO3_MARK,
};
/* - TPU1 ------------------------------------------------------------------- */
static const unsigned int tpu1_to0_pins[] = {
	/* TO */
	246,
};
static const unsigned int tpu1_to0_mux[] = {
	TPU1TO0_MARK,
};
static const unsigned int tpu1_to1_0_pins[] = {
	/* TO */
	28,
};
static const unsigned int tpu1_to1_0_mux[] = {
	PORT28_TPU1TO1_MARK,
};
static const unsigned int tpu1_to1_1_pins[] = {
	/* TO */
	29,
};
static const unsigned int tpu1_to1_1_mux[] = {
	PORT29_TPU1TO1_MARK,
};
static const unsigned int tpu1_to2_pins[] = {
	/* TO */
	153,
};
static const unsigned int tpu1_to2_mux[] = {
	TPU1TO2_MARK,
};
static const unsigned int tpu1_to3_pins[] = {
	/* TO */
	145,
};
static const unsigned int tpu1_to3_mux[] = {
	TPU1TO3_MARK,
};
/* - TPU2 ------------------------------------------------------------------- */
static const unsigned int tpu2_to0_pins[] = {
	/* TO */
	248,
};
static const unsigned int tpu2_to0_mux[] = {
	TPU2TO0_MARK,
};
static const unsigned int tpu2_to1_pins[] = {
	/* TO */
	197,
};
static const unsigned int tpu2_to1_mux[] = {
	TPU2TO1_MARK,
};
static const unsigned int tpu2_to2_pins[] = {
	/* TO */
	50,
};
static const unsigned int tpu2_to2_mux[] = {
	TPU2TO2_MARK,
};
static const unsigned int tpu2_to3_pins[] = {
	/* TO */
	51,
};
static const unsigned int tpu2_to3_mux[] = {
	TPU2TO3_MARK,
};
/* - TPU3 ------------------------------------------------------------------- */
static const unsigned int tpu3_to0_pins[] = {
	/* TO */
	163,
};
static const unsigned int tpu3_to0_mux[] = {
	TPU3TO0_MARK,
};
static const unsigned int tpu3_to1_pins[] = {
	/* TO */
	247,
};
static const unsigned int tpu3_to1_mux[] = {
	TPU3TO1_MARK,
};
static const unsigned int tpu3_to2_pins[] = {
	/* TO */
	54,
};
static const unsigned int tpu3_to2_mux[] = {
	TPU3TO2_MARK,
};
static const unsigned int tpu3_to3_pins[] = {
	/* TO */
	53,
};
static const unsigned int tpu3_to3_mux[] = {
	TPU3TO3_MARK,
};
/* - TPU4 ------------------------------------------------------------------- */
static const unsigned int tpu4_to0_pins[] = {
	/* TO */
	241,
};
static const unsigned int tpu4_to0_mux[] = {
	TPU4TO0_MARK,
};
static const unsigned int tpu4_to1_pins[] = {
	/* TO */
	199,
};
static const unsigned int tpu4_to1_mux[] = {
	TPU4TO1_MARK,
};
static const unsigned int tpu4_to2_pins[] = {
	/* TO */
	58,
};
static const unsigned int tpu4_to2_mux[] = {
	TPU4TO2_MARK,
};
static const unsigned int tpu4_to3_pins[] = {
	/* TO */
};
static const unsigned int tpu4_to3_mux[] = {
	TPU4TO3_MARK,
};
/* - USB -------------------------------------------------------------------- */
static const unsigned int usb_vbus_pins[] = {
	/* VBUS */
	0,
};
static const unsigned int usb_vbus_mux[] = {
	VBUS_0_MARK,
};

static const struct sh_pfc_pin_group pinmux_groups[] = {
	SH_PFC_PIN_GROUP(bsc_data_0_7),
	SH_PFC_PIN_GROUP(bsc_data_8_15),
	SH_PFC_PIN_GROUP(bsc_cs4),
	SH_PFC_PIN_GROUP(bsc_cs5_a),
	SH_PFC_PIN_GROUP(bsc_cs5_b),
	SH_PFC_PIN_GROUP(bsc_cs6_a),
	SH_PFC_PIN_GROUP(bsc_cs6_b),
	SH_PFC_PIN_GROUP(bsc_rd),
	SH_PFC_PIN_GROUP(bsc_rdwr_0),
	SH_PFC_PIN_GROUP(bsc_rdwr_1),
	SH_PFC_PIN_GROUP(bsc_rdwr_2),
	SH_PFC_PIN_GROUP(bsc_we0),
	SH_PFC_PIN_GROUP(bsc_we1),
	SH_PFC_PIN_GROUP(fsia_mclk_in),
	SH_PFC_PIN_GROUP(fsia_mclk_out),
	SH_PFC_PIN_GROUP(fsia_sclk_in),
	SH_PFC_PIN_GROUP(fsia_sclk_out),
	SH_PFC_PIN_GROUP(fsia_data_in),
	SH_PFC_PIN_GROUP(fsia_data_out),
	SH_PFC_PIN_GROUP(fsia_spdif),
	SH_PFC_PIN_GROUP(fsib_mclk_in),
	SH_PFC_PIN_GROUP(fsib_mclk_out),
	SH_PFC_PIN_GROUP(fsib_sclk_in),
	SH_PFC_PIN_GROUP(fsib_sclk_out),
	SH_PFC_PIN_GROUP(fsib_data_in),
	SH_PFC_PIN_GROUP(fsib_data_out),
	SH_PFC_PIN_GROUP(fsib_spdif),
	SH_PFC_PIN_GROUP(fsic_mclk_in),
	SH_PFC_PIN_GROUP(fsic_mclk_out),
	SH_PFC_PIN_GROUP(fsic_sclk_in),
	SH_PFC_PIN_GROUP(fsic_sclk_out),
	SH_PFC_PIN_GROUP(fsic_data_in),
	SH_PFC_PIN_GROUP(fsic_data_out),
	SH_PFC_PIN_GROUP(fsic_spdif_0),
	SH_PFC_PIN_GROUP(fsic_spdif_1),
	SH_PFC_PIN_GROUP(fsid_sclk_in),
	SH_PFC_PIN_GROUP(fsid_sclk_out),
	SH_PFC_PIN_GROUP(fsid_data_in),
	SH_PFC_PIN_GROUP(i2c2_0),
	SH_PFC_PIN_GROUP(i2c2_1),
	SH_PFC_PIN_GROUP(i2c2_2),
	SH_PFC_PIN_GROUP(i2c3_0),
	SH_PFC_PIN_GROUP(i2c3_1),
	SH_PFC_PIN_GROUP(i2c3_2),
	SH_PFC_PIN_GROUP(irda_0),
	SH_PFC_PIN_GROUP(irda_1),
	SH_PFC_PIN_GROUP(keysc_in5),
	SH_PFC_PIN_GROUP(keysc_in6),
	SH_PFC_PIN_GROUP(keysc_in7),
	SH_PFC_PIN_GROUP(keysc_in8),
	SH_PFC_PIN_GROUP(keysc_out04),
	SH_PFC_PIN_GROUP(keysc_out5),
	SH_PFC_PIN_GROUP(keysc_out6_0),
	SH_PFC_PIN_GROUP(keysc_out6_1),
	SH_PFC_PIN_GROUP(keysc_out6_2),
	SH_PFC_PIN_GROUP(keysc_out7_0),
	SH_PFC_PIN_GROUP(keysc_out7_1),
	SH_PFC_PIN_GROUP(keysc_out7_2),
	SH_PFC_PIN_GROUP(keysc_out8_0),
	SH_PFC_PIN_GROUP(keysc_out8_1),
	SH_PFC_PIN_GROUP(keysc_out8_2),
	SH_PFC_PIN_GROUP(keysc_out9_0),
	SH_PFC_PIN_GROUP(keysc_out9_1),
	SH_PFC_PIN_GROUP(keysc_out9_2),
	SH_PFC_PIN_GROUP(keysc_out10_0),
	SH_PFC_PIN_GROUP(keysc_out10_1),
	SH_PFC_PIN_GROUP(keysc_out11_0),
	SH_PFC_PIN_GROUP(keysc_out11_1),
	SH_PFC_PIN_GROUP(lcd_data8),
	SH_PFC_PIN_GROUP(lcd_data9),
	SH_PFC_PIN_GROUP(lcd_data12),
	SH_PFC_PIN_GROUP(lcd_data16),
	SH_PFC_PIN_GROUP(lcd_data18),
	SH_PFC_PIN_GROUP(lcd_data24),
	SH_PFC_PIN_GROUP(lcd_display),
	SH_PFC_PIN_GROUP(lcd_lclk),
	SH_PFC_PIN_GROUP(lcd_sync),
	SH_PFC_PIN_GROUP(lcd_sys),
	SH_PFC_PIN_GROUP(lcd2_data8),
	SH_PFC_PIN_GROUP(lcd2_data9),
	SH_PFC_PIN_GROUP(lcd2_data12),
	SH_PFC_PIN_GROUP(lcd2_data16),
	SH_PFC_PIN_GROUP(lcd2_data18),
	SH_PFC_PIN_GROUP(lcd2_data24),
	SH_PFC_PIN_GROUP(lcd2_sync_0),
	SH_PFC_PIN_GROUP(lcd2_sync_1),
	SH_PFC_PIN_GROUP(lcd2_sys_0),
	SH_PFC_PIN_GROUP(lcd2_sys_1),
	SH_PFC_PIN_GROUP(mmc0_data1_0),
	SH_PFC_PIN_GROUP(mmc0_data4_0),
	SH_PFC_PIN_GROUP(mmc0_data8_0),
	SH_PFC_PIN_GROUP(mmc0_ctrl_0),
	SH_PFC_PIN_GROUP(mmc0_data1_1),
	SH_PFC_PIN_GROUP(mmc0_data4_1),
	SH_PFC_PIN_GROUP(mmc0_data8_1),
	SH_PFC_PIN_GROUP(mmc0_ctrl_1),
	SH_PFC_PIN_GROUP(scifa0_data),
	SH_PFC_PIN_GROUP(scifa0_clk),
	SH_PFC_PIN_GROUP(scifa0_ctrl),
	SH_PFC_PIN_GROUP(scifa1_data),
	SH_PFC_PIN_GROUP(scifa1_clk),
	SH_PFC_PIN_GROUP(scifa1_ctrl),
	SH_PFC_PIN_GROUP(scifa2_data_0),
	SH_PFC_PIN_GROUP(scifa2_clk_0),
	SH_PFC_PIN_GROUP(scifa2_ctrl_0),
	SH_PFC_PIN_GROUP(scifa2_data_1),
	SH_PFC_PIN_GROUP(scifa2_clk_1),
	SH_PFC_PIN_GROUP(scifa2_ctrl_1),
	SH_PFC_PIN_GROUP(scifa3_data),
	SH_PFC_PIN_GROUP(scifa3_ctrl),
	SH_PFC_PIN_GROUP(scifa4_data),
	SH_PFC_PIN_GROUP(scifa4_ctrl),
	SH_PFC_PIN_GROUP(scifa5_data_0),
	SH_PFC_PIN_GROUP(scifa5_clk_0),
	SH_PFC_PIN_GROUP(scifa5_ctrl_0),
	SH_PFC_PIN_GROUP(scifa5_data_1),
	SH_PFC_PIN_GROUP(scifa5_clk_1),
	SH_PFC_PIN_GROUP(scifa5_ctrl_1),
	SH_PFC_PIN_GROUP(scifa5_data_2),
	SH_PFC_PIN_GROUP(scifa5_clk_2),
	SH_PFC_PIN_GROUP(scifa5_ctrl_2),
	SH_PFC_PIN_GROUP(scifa6),
	SH_PFC_PIN_GROUP(scifa7_data),
	SH_PFC_PIN_GROUP(scifa7_ctrl),
	SH_PFC_PIN_GROUP(scifb_data_0),
	SH_PFC_PIN_GROUP(scifb_clk_0),
	SH_PFC_PIN_GROUP(scifb_ctrl_0),
	SH_PFC_PIN_GROUP(scifb_data_1),
	SH_PFC_PIN_GROUP(scifb_clk_1),
	SH_PFC_PIN_GROUP(scifb_ctrl_1),
	SH_PFC_PIN_GROUP(sdhi0_data1),
	SH_PFC_PIN_GROUP(sdhi0_data4),
	SH_PFC_PIN_GROUP(sdhi0_ctrl),
	SH_PFC_PIN_GROUP(sdhi0_cd),
	SH_PFC_PIN_GROUP(sdhi0_wp),
	SH_PFC_PIN_GROUP(sdhi1_data1),
	SH_PFC_PIN_GROUP(sdhi1_data4),
	SH_PFC_PIN_GROUP(sdhi1_ctrl),
	SH_PFC_PIN_GROUP(sdhi2_data1),
	SH_PFC_PIN_GROUP(sdhi2_data4),
	SH_PFC_PIN_GROUP(sdhi2_ctrl),
	SH_PFC_PIN_GROUP(tpu0_to0),
	SH_PFC_PIN_GROUP(tpu0_to1),
	SH_PFC_PIN_GROUP(tpu0_to2),
	SH_PFC_PIN_GROUP(tpu0_to3),
	SH_PFC_PIN_GROUP(tpu1_to0),
	SH_PFC_PIN_GROUP(tpu1_to1_0),
	SH_PFC_PIN_GROUP(tpu1_to1_1),
	SH_PFC_PIN_GROUP(tpu1_to2),
	SH_PFC_PIN_GROUP(tpu1_to3),
	SH_PFC_PIN_GROUP(tpu2_to0),
	SH_PFC_PIN_GROUP(tpu2_to1),
	SH_PFC_PIN_GROUP(tpu2_to2),
	SH_PFC_PIN_GROUP(tpu2_to3),
	SH_PFC_PIN_GROUP(tpu3_to0),
	SH_PFC_PIN_GROUP(tpu3_to1),
	SH_PFC_PIN_GROUP(tpu3_to2),
	SH_PFC_PIN_GROUP(tpu3_to3),
	SH_PFC_PIN_GROUP(tpu4_to0),
	SH_PFC_PIN_GROUP(tpu4_to1),
	SH_PFC_PIN_GROUP(tpu4_to2),
	SH_PFC_PIN_GROUP(tpu4_to3),
	SH_PFC_PIN_GROUP(usb_vbus),
};

static const char * const bsc_groups[] = {
	"bsc_data_0_7",
	"bsc_data_8_15",
	"bsc_cs4",
	"bsc_cs5_a",
	"bsc_cs5_b",
	"bsc_cs6_a",
	"bsc_cs6_b",
	"bsc_rd",
	"bsc_rdwr_0",
	"bsc_rdwr_1",
	"bsc_rdwr_2",
	"bsc_we0",
	"bsc_we1",
};

static const char * const fsia_groups[] = {
	"fsia_mclk_in",
	"fsia_mclk_out",
	"fsia_sclk_in",
	"fsia_sclk_out",
	"fsia_data_in",
	"fsia_data_out",
	"fsia_spdif",
};

static const char * const fsib_groups[] = {
	"fsib_mclk_in",
	"fsib_mclk_out",
	"fsib_sclk_in",
	"fsib_sclk_out",
	"fsib_data_in",
	"fsib_data_out",
	"fsib_spdif",
};

static const char * const fsic_groups[] = {
	"fsic_mclk_in",
	"fsic_mclk_out",
	"fsic_sclk_in",
	"fsic_sclk_out",
	"fsic_data_in",
	"fsic_data_out",
	"fsic_spdif",
};

static const char * const fsid_groups[] = {
	"fsid_sclk_in",
	"fsid_sclk_out",
	"fsid_data_in",
};

static const char * const i2c2_groups[] = {
	"i2c2_0",
	"i2c2_1",
	"i2c2_2",
};

static const char * const i2c3_groups[] = {
	"i2c3_0",
	"i2c3_1",
	"i2c3_2",
};

static const char * const irda_groups[] = {
	"irda_0",
	"irda_1",
};

static const char * const keysc_groups[] = {
	"keysc_in5",
	"keysc_in6",
	"keysc_in7",
	"keysc_in8",
	"keysc_out04",
	"keysc_out5",
	"keysc_out6_0",
	"keysc_out6_1",
	"keysc_out6_2",
	"keysc_out7_0",
	"keysc_out7_1",
	"keysc_out7_2",
	"keysc_out8_0",
	"keysc_out8_1",
	"keysc_out8_2",
	"keysc_out9_0",
	"keysc_out9_1",
	"keysc_out9_2",
	"keysc_out10_0",
	"keysc_out10_1",
	"keysc_out11_0",
	"keysc_out11_1",
};

static const char * const lcd_groups[] = {
	"lcd_data8",
	"lcd_data9",
	"lcd_data12",
	"lcd_data16",
	"lcd_data18",
	"lcd_data24",
	"lcd_display",
	"lcd_lclk",
	"lcd_sync",
	"lcd_sys",
};

static const char * const lcd2_groups[] = {
	"lcd2_data8",
	"lcd2_data9",
	"lcd2_data12",
	"lcd2_data16",
	"lcd2_data18",
	"lcd2_data24",
	"lcd2_sync_0",
	"lcd2_sync_1",
	"lcd2_sys_0",
	"lcd2_sys_1",
};

static const char * const mmc0_groups[] = {
	"mmc0_data1_0",
	"mmc0_data4_0",
	"mmc0_data8_0",
	"mmc0_ctrl_0",
	"mmc0_data1_1",
	"mmc0_data4_1",
	"mmc0_data8_1",
	"mmc0_ctrl_1",
};

static const char * const scifa0_groups[] = {
	"scifa0_data",
	"scifa0_clk",
	"scifa0_ctrl",
};

static const char * const scifa1_groups[] = {
	"scifa1_data",
	"scifa1_clk",
	"scifa1_ctrl",
};

static const char * const scifa2_groups[] = {
	"scifa2_data_0",
	"scifa2_clk_0",
	"scifa2_ctrl_0",
	"scifa2_data_1",
	"scifa2_clk_1",
	"scifa2_ctrl_1",
};

static const char * const scifa3_groups[] = {
	"scifa3_data",
	"scifa3_ctrl",
};

static const char * const scifa4_groups[] = {
	"scifa4_data",
	"scifa4_ctrl",
};

static const char * const scifa5_groups[] = {
	"scifa5_data_0",
	"scifa5_clk_0",
	"scifa5_ctrl_0",
	"scifa5_data_1",
	"scifa5_clk_1",
	"scifa5_ctrl_1",
	"scifa5_data_2",
	"scifa5_clk_2",
	"scifa5_ctrl_2",
};

static const char * const scifa6_groups[] = {
	"scifa6",
};

static const char * const scifa7_groups[] = {
	"scifa7_data",
	"scifa7_ctrl",
};

static const char * const scifb_groups[] = {
	"scifb_data_0",
	"scifb_clk_0",
	"scifb_ctrl_0",
	"scifb_data_1",
	"scifb_clk_1",
	"scifb_ctrl_1",
};

static const char * const sdhi0_groups[] = {
	"sdhi0_data1",
	"sdhi0_data4",
	"sdhi0_ctrl",
	"sdhi0_cd",
	"sdhi0_wp",
};

static const char * const sdhi1_groups[] = {
	"sdhi1_data1",
	"sdhi1_data4",
	"sdhi1_ctrl",
};

static const char * const sdhi2_groups[] = {
	"sdhi2_data1",
	"sdhi2_data4",
	"sdhi2_ctrl",
};

static const char * const usb_groups[] = {
	"usb_vbus",
};

static const char * const tpu0_groups[] = {
	"tpu0_to0",
	"tpu0_to1",
	"tpu0_to2",
	"tpu0_to3",
};

static const char * const tpu1_groups[] = {
	"tpu1_to0",
	"tpu1_to1_0",
	"tpu1_to1_1",
	"tpu1_to2",
	"tpu1_to3",
};

static const char * const tpu2_groups[] = {
	"tpu2_to0",
	"tpu2_to1",
	"tpu2_to2",
	"tpu2_to3",
};

static const char * const tpu3_groups[] = {
	"tpu3_to0",
	"tpu3_to1",
	"tpu3_to2",
	"tpu3_to3",
};

static const char * const tpu4_groups[] = {
	"tpu4_to0",
	"tpu4_to1",
	"tpu4_to2",
	"tpu4_to3",
};

static const struct sh_pfc_function pinmux_functions[] = {
	SH_PFC_FUNCTION(bsc),
	SH_PFC_FUNCTION(fsia),
	SH_PFC_FUNCTION(fsib),
	SH_PFC_FUNCTION(fsic),
	SH_PFC_FUNCTION(fsid),
	SH_PFC_FUNCTION(i2c2),
	SH_PFC_FUNCTION(i2c3),
	SH_PFC_FUNCTION(irda),
	SH_PFC_FUNCTION(keysc),
	SH_PFC_FUNCTION(lcd),
	SH_PFC_FUNCTION(lcd2),
	SH_PFC_FUNCTION(mmc0),
	SH_PFC_FUNCTION(scifa0),
	SH_PFC_FUNCTION(scifa1),
	SH_PFC_FUNCTION(scifa2),
	SH_PFC_FUNCTION(scifa3),
	SH_PFC_FUNCTION(scifa4),
	SH_PFC_FUNCTION(scifa5),
	SH_PFC_FUNCTION(scifa6),
	SH_PFC_FUNCTION(scifa7),
	SH_PFC_FUNCTION(scifb),
	SH_PFC_FUNCTION(sdhi0),
	SH_PFC_FUNCTION(sdhi1),
	SH_PFC_FUNCTION(sdhi2),
	SH_PFC_FUNCTION(tpu0),
	SH_PFC_FUNCTION(tpu1),
	SH_PFC_FUNCTION(tpu2),
	SH_PFC_FUNCTION(tpu3),
	SH_PFC_FUNCTION(tpu4),
	SH_PFC_FUNCTION(usb),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	PORTCR(0, 0xe6050000), /* PORT0CR */
	PORTCR(1, 0xe6050001), /* PORT1CR */
	PORTCR(2, 0xe6050002), /* PORT2CR */
	PORTCR(3, 0xe6050003), /* PORT3CR */
	PORTCR(4, 0xe6050004), /* PORT4CR */
	PORTCR(5, 0xe6050005), /* PORT5CR */
	PORTCR(6, 0xe6050006), /* PORT6CR */
	PORTCR(7, 0xe6050007), /* PORT7CR */
	PORTCR(8, 0xe6050008), /* PORT8CR */
	PORTCR(9, 0xe6050009), /* PORT9CR */

	PORTCR(10, 0xe605000a), /* PORT10CR */
	PORTCR(11, 0xe605000b), /* PORT11CR */
	PORTCR(12, 0xe605000c), /* PORT12CR */
	PORTCR(13, 0xe605000d), /* PORT13CR */
	PORTCR(14, 0xe605000e), /* PORT14CR */
	PORTCR(15, 0xe605000f), /* PORT15CR */
	PORTCR(16, 0xe6050010), /* PORT16CR */
	PORTCR(17, 0xe6050011), /* PORT17CR */
	PORTCR(18, 0xe6050012), /* PORT18CR */
	PORTCR(19, 0xe6050013), /* PORT19CR */

	PORTCR(20, 0xe6050014), /* PORT20CR */
	PORTCR(21, 0xe6050015), /* PORT21CR */
	PORTCR(22, 0xe6050016), /* PORT22CR */
	PORTCR(23, 0xe6050017), /* PORT23CR */
	PORTCR(24, 0xe6050018), /* PORT24CR */
	PORTCR(25, 0xe6050019), /* PORT25CR */
	PORTCR(26, 0xe605001a), /* PORT26CR */
	PORTCR(27, 0xe605001b), /* PORT27CR */
	PORTCR(28, 0xe605001c), /* PORT28CR */
	PORTCR(29, 0xe605001d), /* PORT29CR */

	PORTCR(30, 0xe605001e), /* PORT30CR */
	PORTCR(31, 0xe605001f), /* PORT31CR */
	PORTCR(32, 0xe6051020), /* PORT32CR */
	PORTCR(33, 0xe6051021), /* PORT33CR */
	PORTCR(34, 0xe6051022), /* PORT34CR */
	PORTCR(35, 0xe6051023), /* PORT35CR */
	PORTCR(36, 0xe6051024), /* PORT36CR */
	PORTCR(37, 0xe6051025), /* PORT37CR */
	PORTCR(38, 0xe6051026), /* PORT38CR */
	PORTCR(39, 0xe6051027), /* PORT39CR */

	PORTCR(40, 0xe6051028), /* PORT40CR */
	PORTCR(41, 0xe6051029), /* PORT41CR */
	PORTCR(42, 0xe605102a), /* PORT42CR */
	PORTCR(43, 0xe605102b), /* PORT43CR */
	PORTCR(44, 0xe605102c), /* PORT44CR */
	PORTCR(45, 0xe605102d), /* PORT45CR */
	PORTCR(46, 0xe605102e), /* PORT46CR */
	PORTCR(47, 0xe605102f), /* PORT47CR */
	PORTCR(48, 0xe6051030), /* PORT48CR */
	PORTCR(49, 0xe6051031), /* PORT49CR */

	PORTCR(50, 0xe6051032), /* PORT50CR */
	PORTCR(51, 0xe6051033), /* PORT51CR */
	PORTCR(52, 0xe6051034), /* PORT52CR */
	PORTCR(53, 0xe6051035), /* PORT53CR */
	PORTCR(54, 0xe6051036), /* PORT54CR */
	PORTCR(55, 0xe6051037), /* PORT55CR */
	PORTCR(56, 0xe6051038), /* PORT56CR */
	PORTCR(57, 0xe6051039), /* PORT57CR */
	PORTCR(58, 0xe605103a), /* PORT58CR */
	PORTCR(59, 0xe605103b), /* PORT59CR */

	PORTCR(60, 0xe605103c), /* PORT60CR */
	PORTCR(61, 0xe605103d), /* PORT61CR */
	PORTCR(62, 0xe605103e), /* PORT62CR */
	PORTCR(63, 0xe605103f), /* PORT63CR */
	PORTCR(64, 0xe6051040), /* PORT64CR */
	PORTCR(65, 0xe6051041), /* PORT65CR */
	PORTCR(66, 0xe6051042), /* PORT66CR */
	PORTCR(67, 0xe6051043), /* PORT67CR */
	PORTCR(68, 0xe6051044), /* PORT68CR */
	PORTCR(69, 0xe6051045), /* PORT69CR */

	PORTCR(70, 0xe6051046), /* PORT70CR */
	PORTCR(71, 0xe6051047), /* PORT71CR */
	PORTCR(72, 0xe6051048), /* PORT72CR */
	PORTCR(73, 0xe6051049), /* PORT73CR */
	PORTCR(74, 0xe605104a), /* PORT74CR */
	PORTCR(75, 0xe605104b), /* PORT75CR */
	PORTCR(76, 0xe605104c), /* PORT76CR */
	PORTCR(77, 0xe605104d), /* PORT77CR */
	PORTCR(78, 0xe605104e), /* PORT78CR */
	PORTCR(79, 0xe605104f), /* PORT79CR */

	PORTCR(80, 0xe6051050), /* PORT80CR */
	PORTCR(81, 0xe6051051), /* PORT81CR */
	PORTCR(82, 0xe6051052), /* PORT82CR */
	PORTCR(83, 0xe6051053), /* PORT83CR */
	PORTCR(84, 0xe6051054), /* PORT84CR */
	PORTCR(85, 0xe6051055), /* PORT85CR */
	PORTCR(86, 0xe6051056), /* PORT86CR */
	PORTCR(87, 0xe6051057), /* PORT87CR */
	PORTCR(88, 0xe6051058), /* PORT88CR */
	PORTCR(89, 0xe6051059), /* PORT89CR */

	PORTCR(90, 0xe605105a), /* PORT90CR */
	PORTCR(91, 0xe605105b), /* PORT91CR */
	PORTCR(92, 0xe605105c), /* PORT92CR */
	PORTCR(93, 0xe605105d), /* PORT93CR */
	PORTCR(94, 0xe605105e), /* PORT94CR */
	PORTCR(95, 0xe605105f), /* PORT95CR */
	PORTCR(96, 0xe6052060), /* PORT96CR */
	PORTCR(97, 0xe6052061), /* PORT97CR */
	PORTCR(98, 0xe6052062), /* PORT98CR */
	PORTCR(99, 0xe6052063), /* PORT99CR */

	PORTCR(100, 0xe6052064), /* PORT100CR */
	PORTCR(101, 0xe6052065), /* PORT101CR */
	PORTCR(102, 0xe6052066), /* PORT102CR */
	PORTCR(103, 0xe6052067), /* PORT103CR */
	PORTCR(104, 0xe6052068), /* PORT104CR */
	PORTCR(105, 0xe6052069), /* PORT105CR */
	PORTCR(106, 0xe605206a), /* PORT106CR */
	PORTCR(107, 0xe605206b), /* PORT107CR */
	PORTCR(108, 0xe605206c), /* PORT108CR */
	PORTCR(109, 0xe605206d), /* PORT109CR */

	PORTCR(110, 0xe605206e), /* PORT110CR */
	PORTCR(111, 0xe605206f), /* PORT111CR */
	PORTCR(112, 0xe6052070), /* PORT112CR */
	PORTCR(113, 0xe6052071), /* PORT113CR */
	PORTCR(114, 0xe6052072), /* PORT114CR */
	PORTCR(115, 0xe6052073), /* PORT115CR */
	PORTCR(116, 0xe6052074), /* PORT116CR */
	PORTCR(117, 0xe6052075), /* PORT117CR */
	PORTCR(118, 0xe6052076), /* PORT118CR */

	PORTCR(128, 0xe6052080), /* PORT128CR */
	PORTCR(129, 0xe6052081), /* PORT129CR */

	PORTCR(130, 0xe6052082), /* PORT130CR */
	PORTCR(131, 0xe6052083), /* PORT131CR */
	PORTCR(132, 0xe6052084), /* PORT132CR */
	PORTCR(133, 0xe6052085), /* PORT133CR */
	PORTCR(134, 0xe6052086), /* PORT134CR */
	PORTCR(135, 0xe6052087), /* PORT135CR */
	PORTCR(136, 0xe6052088), /* PORT136CR */
	PORTCR(137, 0xe6052089), /* PORT137CR */
	PORTCR(138, 0xe605208a), /* PORT138CR */
	PORTCR(139, 0xe605208b), /* PORT139CR */

	PORTCR(140, 0xe605208c), /* PORT140CR */
	PORTCR(141, 0xe605208d), /* PORT141CR */
	PORTCR(142, 0xe605208e), /* PORT142CR */
	PORTCR(143, 0xe605208f), /* PORT143CR */
	PORTCR(144, 0xe6052090), /* PORT144CR */
	PORTCR(145, 0xe6052091), /* PORT145CR */
	PORTCR(146, 0xe6052092), /* PORT146CR */
	PORTCR(147, 0xe6052093), /* PORT147CR */
	PORTCR(148, 0xe6052094), /* PORT148CR */
	PORTCR(149, 0xe6052095), /* PORT149CR */

	PORTCR(150, 0xe6052096), /* PORT150CR */
	PORTCR(151, 0xe6052097), /* PORT151CR */
	PORTCR(152, 0xe6052098), /* PORT152CR */
	PORTCR(153, 0xe6052099), /* PORT153CR */
	PORTCR(154, 0xe605209a), /* PORT154CR */
	PORTCR(155, 0xe605209b), /* PORT155CR */
	PORTCR(156, 0xe605209c), /* PORT156CR */
	PORTCR(157, 0xe605209d), /* PORT157CR */
	PORTCR(158, 0xe605209e), /* PORT158CR */
	PORTCR(159, 0xe605209f), /* PORT159CR */

	PORTCR(160, 0xe60520a0), /* PORT160CR */
	PORTCR(161, 0xe60520a1), /* PORT161CR */
	PORTCR(162, 0xe60520a2), /* PORT162CR */
	PORTCR(163, 0xe60520a3), /* PORT163CR */
	PORTCR(164, 0xe60520a4), /* PORT164CR */

	PORTCR(192, 0xe60520c0), /* PORT192CR */
	PORTCR(193, 0xe60520c1), /* PORT193CR */
	PORTCR(194, 0xe60520c2), /* PORT194CR */
	PORTCR(195, 0xe60520c3), /* PORT195CR */
	PORTCR(196, 0xe60520c4), /* PORT196CR */
	PORTCR(197, 0xe60520c5), /* PORT197CR */
	PORTCR(198, 0xe60520c6), /* PORT198CR */
	PORTCR(199, 0xe60520c7), /* PORT199CR */

	PORTCR(200, 0xe60520c8), /* PORT200CR */
	PORTCR(201, 0xe60520c9), /* PORT201CR */
	PORTCR(202, 0xe60520ca), /* PORT202CR */
	PORTCR(203, 0xe60520cb), /* PORT203CR */
	PORTCR(204, 0xe60520cc), /* PORT204CR */
	PORTCR(205, 0xe60520cd), /* PORT205CR */
	PORTCR(206, 0xe60520ce), /* PORT206CR */
	PORTCR(207, 0xe60520cf), /* PORT207CR */
	PORTCR(208, 0xe60520d0), /* PORT208CR */
	PORTCR(209, 0xe60520d1), /* PORT209CR */

	PORTCR(210, 0xe60520d2), /* PORT210CR */
	PORTCR(211, 0xe60520d3), /* PORT211CR */
	PORTCR(212, 0xe60520d4), /* PORT212CR */
	PORTCR(213, 0xe60520d5), /* PORT213CR */
	PORTCR(214, 0xe60520d6), /* PORT214CR */
	PORTCR(215, 0xe60520d7), /* PORT215CR */
	PORTCR(216, 0xe60520d8), /* PORT216CR */
	PORTCR(217, 0xe60520d9), /* PORT217CR */
	PORTCR(218, 0xe60520da), /* PORT218CR */
	PORTCR(219, 0xe60520db), /* PORT219CR */

	PORTCR(220, 0xe60520dc), /* PORT220CR */
	PORTCR(221, 0xe60520dd), /* PORT221CR */
	PORTCR(222, 0xe60520de), /* PORT222CR */
	PORTCR(223, 0xe60520df), /* PORT223CR */
	PORTCR(224, 0xe60530e0), /* PORT224CR */
	PORTCR(225, 0xe60530e1), /* PORT225CR */
	PORTCR(226, 0xe60530e2), /* PORT226CR */
	PORTCR(227, 0xe60530e3), /* PORT227CR */
	PORTCR(228, 0xe60530e4), /* PORT228CR */
	PORTCR(229, 0xe60530e5), /* PORT229CR */

	PORTCR(230, 0xe60530e6), /* PORT230CR */
	PORTCR(231, 0xe60530e7), /* PORT231CR */
	PORTCR(232, 0xe60530e8), /* PORT232CR */
	PORTCR(233, 0xe60530e9), /* PORT233CR */
	PORTCR(234, 0xe60530ea), /* PORT234CR */
	PORTCR(235, 0xe60530eb), /* PORT235CR */
	PORTCR(236, 0xe60530ec), /* PORT236CR */
	PORTCR(237, 0xe60530ed), /* PORT237CR */
	PORTCR(238, 0xe60530ee), /* PORT238CR */
	PORTCR(239, 0xe60530ef), /* PORT239CR */

	PORTCR(240, 0xe60530f0), /* PORT240CR */
	PORTCR(241, 0xe60530f1), /* PORT241CR */
	PORTCR(242, 0xe60530f2), /* PORT242CR */
	PORTCR(243, 0xe60530f3), /* PORT243CR */
	PORTCR(244, 0xe60530f4), /* PORT244CR */
	PORTCR(245, 0xe60530f5), /* PORT245CR */
	PORTCR(246, 0xe60530f6), /* PORT246CR */
	PORTCR(247, 0xe60530f7), /* PORT247CR */
	PORTCR(248, 0xe60530f8), /* PORT248CR */
	PORTCR(249, 0xe60530f9), /* PORT249CR */

	PORTCR(250, 0xe60530fa), /* PORT250CR */
	PORTCR(251, 0xe60530fb), /* PORT251CR */
	PORTCR(252, 0xe60530fc), /* PORT252CR */
	PORTCR(253, 0xe60530fd), /* PORT253CR */
	PORTCR(254, 0xe60530fe), /* PORT254CR */
	PORTCR(255, 0xe60530ff), /* PORT255CR */
	PORTCR(256, 0xe6053100), /* PORT256CR */
	PORTCR(257, 0xe6053101), /* PORT257CR */
	PORTCR(258, 0xe6053102), /* PORT258CR */
	PORTCR(259, 0xe6053103), /* PORT259CR */

	PORTCR(260, 0xe6053104), /* PORT260CR */
	PORTCR(261, 0xe6053105), /* PORT261CR */
	PORTCR(262, 0xe6053106), /* PORT262CR */
	PORTCR(263, 0xe6053107), /* PORT263CR */
	PORTCR(264, 0xe6053108), /* PORT264CR */
	PORTCR(265, 0xe6053109), /* PORT265CR */
	PORTCR(266, 0xe605310a), /* PORT266CR */
	PORTCR(267, 0xe605310b), /* PORT267CR */
	PORTCR(268, 0xe605310c), /* PORT268CR */
	PORTCR(269, 0xe605310d), /* PORT269CR */

	PORTCR(270, 0xe605310e), /* PORT270CR */
	PORTCR(271, 0xe605310f), /* PORT271CR */
	PORTCR(272, 0xe6053110), /* PORT272CR */
	PORTCR(273, 0xe6053111), /* PORT273CR */
	PORTCR(274, 0xe6053112), /* PORT274CR */
	PORTCR(275, 0xe6053113), /* PORT275CR */
	PORTCR(276, 0xe6053114), /* PORT276CR */
	PORTCR(277, 0xe6053115), /* PORT277CR */
	PORTCR(278, 0xe6053116), /* PORT278CR */
	PORTCR(279, 0xe6053117), /* PORT279CR */

	PORTCR(280, 0xe6053118), /* PORT280CR */
	PORTCR(281, 0xe6053119), /* PORT281CR */
	PORTCR(282, 0xe605311a), /* PORT282CR */

	PORTCR(288, 0xe6052120), /* PORT288CR */
	PORTCR(289, 0xe6052121), /* PORT289CR */

	PORTCR(290, 0xe6052122), /* PORT290CR */
	PORTCR(291, 0xe6052123), /* PORT291CR */
	PORTCR(292, 0xe6052124), /* PORT292CR */
	PORTCR(293, 0xe6052125), /* PORT293CR */
	PORTCR(294, 0xe6052126), /* PORT294CR */
	PORTCR(295, 0xe6052127), /* PORT295CR */
	PORTCR(296, 0xe6052128), /* PORT296CR */
	PORTCR(297, 0xe6052129), /* PORT297CR */
	PORTCR(298, 0xe605212a), /* PORT298CR */
	PORTCR(299, 0xe605212b), /* PORT299CR */

	PORTCR(300, 0xe605212c), /* PORT300CR */
	PORTCR(301, 0xe605212d), /* PORT301CR */
	PORTCR(302, 0xe605212e), /* PORT302CR */
	PORTCR(303, 0xe605212f), /* PORT303CR */
	PORTCR(304, 0xe6052130), /* PORT304CR */
	PORTCR(305, 0xe6052131), /* PORT305CR */
	PORTCR(306, 0xe6052132), /* PORT306CR */
	PORTCR(307, 0xe6052133), /* PORT307CR */
	PORTCR(308, 0xe6052134), /* PORT308CR */
	PORTCR(309, 0xe6052135), /* PORT309CR */

	{ PINMUX_CFG_REG("MSEL2CR", 0xe605801c, 32, 1) {
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			MSEL2CR_MSEL19_0, MSEL2CR_MSEL19_1,
			MSEL2CR_MSEL18_0, MSEL2CR_MSEL18_1,
			MSEL2CR_MSEL17_0, MSEL2CR_MSEL17_1,
			MSEL2CR_MSEL16_0, MSEL2CR_MSEL16_1,
			0, 0,
			MSEL2CR_MSEL14_0, MSEL2CR_MSEL14_1,
			MSEL2CR_MSEL13_0, MSEL2CR_MSEL13_1,
			MSEL2CR_MSEL12_0, MSEL2CR_MSEL12_1,
			MSEL2CR_MSEL11_0, MSEL2CR_MSEL11_1,
			MSEL2CR_MSEL10_0, MSEL2CR_MSEL10_1,
			MSEL2CR_MSEL9_0, MSEL2CR_MSEL9_1,
			MSEL2CR_MSEL8_0, MSEL2CR_MSEL8_1,
			MSEL2CR_MSEL7_0, MSEL2CR_MSEL7_1,
			MSEL2CR_MSEL6_0, MSEL2CR_MSEL6_1,
			MSEL2CR_MSEL5_0, MSEL2CR_MSEL5_1,
			MSEL2CR_MSEL4_0, MSEL2CR_MSEL4_1,
			MSEL2CR_MSEL3_0, MSEL2CR_MSEL3_1,
			MSEL2CR_MSEL2_0, MSEL2CR_MSEL2_1,
			MSEL2CR_MSEL1_0, MSEL2CR_MSEL1_1,
			MSEL2CR_MSEL0_0, MSEL2CR_MSEL0_1,
		}
	},
	{ PINMUX_CFG_REG("MSEL3CR", 0xe6058020, 32, 1) {
			0, 0,
			0, 0,
			0, 0,
			MSEL3CR_MSEL28_0, MSEL3CR_MSEL28_1,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			MSEL3CR_MSEL15_0, MSEL3CR_MSEL15_1,
			0, 0,
			0, 0,
			0, 0,
			MSEL3CR_MSEL11_0, MSEL3CR_MSEL11_1,
			0, 0,
			MSEL3CR_MSEL9_0, MSEL3CR_MSEL9_1,
			0, 0,
			0, 0,
			MSEL3CR_MSEL6_0, MSEL3CR_MSEL6_1,
			0, 0,
			0, 0,
			0, 0,
			MSEL3CR_MSEL2_0, MSEL3CR_MSEL2_1,
			0, 0,
			0, 0,
		}
	},
	{ PINMUX_CFG_REG("MSEL4CR", 0xe6058024, 32, 1) {
			0, 0,
			0, 0,
			MSEL4CR_MSEL29_0, MSEL4CR_MSEL29_1,
			0, 0,
			MSEL4CR_MSEL27_0, MSEL4CR_MSEL27_1,
			MSEL4CR_MSEL26_0, MSEL4CR_MSEL26_1,
			0, 0,
			0, 0,
			0, 0,
			MSEL4CR_MSEL22_0, MSEL4CR_MSEL22_1,
			MSEL4CR_MSEL21_0, MSEL4CR_MSEL21_1,
			MSEL4CR_MSEL20_0, MSEL4CR_MSEL20_1,
			MSEL4CR_MSEL19_0, MSEL4CR_MSEL19_1,
			0, 0,
			0, 0,
			0, 0,
			MSEL4CR_MSEL15_0, MSEL4CR_MSEL15_1,
			0, 0,
			MSEL4CR_MSEL13_0, MSEL4CR_MSEL13_1,
			MSEL4CR_MSEL12_0, MSEL4CR_MSEL12_1,
			MSEL4CR_MSEL11_0, MSEL4CR_MSEL11_1,
			MSEL4CR_MSEL10_0, MSEL4CR_MSEL10_1,
			MSEL4CR_MSEL9_0, MSEL4CR_MSEL9_1,
			MSEL4CR_MSEL8_0, MSEL4CR_MSEL8_1,
			MSEL4CR_MSEL7_0, MSEL4CR_MSEL7_1,
			0, 0,
			0, 0,
			MSEL4CR_MSEL4_0, MSEL4CR_MSEL4_1,
			0, 0,
			0, 0,
			MSEL4CR_MSEL1_0, MSEL4CR_MSEL1_1,
			0, 0,
		}
	},
	{ },
};

static const struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PORTL031_000DR", 0xe6054000, 32) {
			PORT31_DATA, PORT30_DATA, PORT29_DATA, PORT28_DATA,
			PORT27_DATA, PORT26_DATA, PORT25_DATA, PORT24_DATA,
			PORT23_DATA, PORT22_DATA, PORT21_DATA, PORT20_DATA,
			PORT19_DATA, PORT18_DATA, PORT17_DATA, PORT16_DATA,
			PORT15_DATA, PORT14_DATA, PORT13_DATA, PORT12_DATA,
			PORT11_DATA, PORT10_DATA, PORT9_DATA, PORT8_DATA,
			PORT7_DATA, PORT6_DATA, PORT5_DATA, PORT4_DATA,
			PORT3_DATA, PORT2_DATA, PORT1_DATA, PORT0_DATA }
	},
	{ PINMUX_DATA_REG("PORTD063_032DR", 0xe6055000, 32) {
			PORT63_DATA, PORT62_DATA, PORT61_DATA, PORT60_DATA,
			PORT59_DATA, PORT58_DATA, PORT57_DATA, PORT56_DATA,
			PORT55_DATA, PORT54_DATA, PORT53_DATA, PORT52_DATA,
			PORT51_DATA, PORT50_DATA, PORT49_DATA, PORT48_DATA,
			PORT47_DATA, PORT46_DATA, PORT45_DATA, PORT44_DATA,
			PORT43_DATA, PORT42_DATA, PORT41_DATA, PORT40_DATA,
			PORT39_DATA, PORT38_DATA, PORT37_DATA, PORT36_DATA,
			PORT35_DATA, PORT34_DATA, PORT33_DATA, PORT32_DATA }
	},
	{ PINMUX_DATA_REG("PORTD095_064DR", 0xe6055004, 32) {
			PORT95_DATA, PORT94_DATA, PORT93_DATA, PORT92_DATA,
			PORT91_DATA, PORT90_DATA, PORT89_DATA, PORT88_DATA,
			PORT87_DATA, PORT86_DATA, PORT85_DATA, PORT84_DATA,
			PORT83_DATA, PORT82_DATA, PORT81_DATA, PORT80_DATA,
			PORT79_DATA, PORT78_DATA, PORT77_DATA, PORT76_DATA,
			PORT75_DATA, PORT74_DATA, PORT73_DATA, PORT72_DATA,
			PORT71_DATA, PORT70_DATA, PORT69_DATA, PORT68_DATA,
			PORT67_DATA, PORT66_DATA, PORT65_DATA, PORT64_DATA }
	},
	{ PINMUX_DATA_REG("PORTR127_096DR", 0xe6056000, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, PORT118_DATA, PORT117_DATA, PORT116_DATA,
			PORT115_DATA, PORT114_DATA, PORT113_DATA, PORT112_DATA,
			PORT111_DATA, PORT110_DATA, PORT109_DATA, PORT108_DATA,
			PORT107_DATA, PORT106_DATA, PORT105_DATA, PORT104_DATA,
			PORT103_DATA, PORT102_DATA, PORT101_DATA, PORT100_DATA,
			PORT99_DATA, PORT98_DATA, PORT97_DATA, PORT96_DATA }
	},
	{ PINMUX_DATA_REG("PORTR159_128DR", 0xe6056004, 32) {
			PORT159_DATA, PORT158_DATA, PORT157_DATA, PORT156_DATA,
			PORT155_DATA, PORT154_DATA, PORT153_DATA, PORT152_DATA,
			PORT151_DATA, PORT150_DATA, PORT149_DATA, PORT148_DATA,
			PORT147_DATA, PORT146_DATA, PORT145_DATA, PORT144_DATA,
			PORT143_DATA, PORT142_DATA, PORT141_DATA, PORT140_DATA,
			PORT139_DATA, PORT138_DATA, PORT137_DATA, PORT136_DATA,
			PORT135_DATA, PORT134_DATA, PORT133_DATA, PORT132_DATA,
			PORT131_DATA, PORT130_DATA, PORT129_DATA, PORT128_DATA }
	},
	{ PINMUX_DATA_REG("PORTR191_160DR", 0xe6056008, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, PORT164_DATA,
			PORT163_DATA, PORT162_DATA, PORT161_DATA, PORT160_DATA }
	},
	{ PINMUX_DATA_REG("PORTR223_192DR", 0xe605600C, 32) {
			PORT223_DATA, PORT222_DATA, PORT221_DATA, PORT220_DATA,
			PORT219_DATA, PORT218_DATA, PORT217_DATA, PORT216_DATA,
			PORT215_DATA, PORT214_DATA, PORT213_DATA, PORT212_DATA,
			PORT211_DATA, PORT210_DATA, PORT209_DATA, PORT208_DATA,
			PORT207_DATA, PORT206_DATA, PORT205_DATA, PORT204_DATA,
			PORT203_DATA, PORT202_DATA, PORT201_DATA, PORT200_DATA,
			PORT199_DATA, PORT198_DATA, PORT197_DATA, PORT196_DATA,
			PORT195_DATA, PORT194_DATA, PORT193_DATA, PORT192_DATA }
	},
	{ PINMUX_DATA_REG("PORTU255_224DR", 0xe6057000, 32) {
			PORT255_DATA, PORT254_DATA, PORT253_DATA, PORT252_DATA,
			PORT251_DATA, PORT250_DATA, PORT249_DATA, PORT248_DATA,
			PORT247_DATA, PORT246_DATA, PORT245_DATA, PORT244_DATA,
			PORT243_DATA, PORT242_DATA, PORT241_DATA, PORT240_DATA,
			PORT239_DATA, PORT238_DATA, PORT237_DATA, PORT236_DATA,
			PORT235_DATA, PORT234_DATA, PORT233_DATA, PORT232_DATA,
			PORT231_DATA, PORT230_DATA, PORT229_DATA, PORT228_DATA,
			PORT227_DATA, PORT226_DATA, PORT225_DATA, PORT224_DATA }
	},
	{ PINMUX_DATA_REG("PORTU287_256DR", 0xe6057004, 32) {
			0, 0, 0, 0,
			0, PORT282_DATA, PORT281_DATA, PORT280_DATA,
			PORT279_DATA, PORT278_DATA, PORT277_DATA, PORT276_DATA,
			PORT275_DATA, PORT274_DATA, PORT273_DATA, PORT272_DATA,
			PORT271_DATA, PORT270_DATA, PORT269_DATA, PORT268_DATA,
			PORT267_DATA, PORT266_DATA, PORT265_DATA, PORT264_DATA,
			PORT263_DATA, PORT262_DATA, PORT261_DATA, PORT260_DATA,
			PORT259_DATA, PORT258_DATA, PORT257_DATA, PORT256_DATA }
	},
	{ PINMUX_DATA_REG("PORTR319_288DR", 0xe6056010, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, PORT309_DATA, PORT308_DATA,
			PORT307_DATA, PORT306_DATA, PORT305_DATA, PORT304_DATA,
			PORT303_DATA, PORT302_DATA, PORT301_DATA, PORT300_DATA,
			PORT299_DATA, PORT298_DATA, PORT297_DATA, PORT296_DATA,
			PORT295_DATA, PORT294_DATA, PORT293_DATA, PORT292_DATA,
			PORT291_DATA, PORT290_DATA, PORT289_DATA, PORT288_DATA }
	},
	{ },
};

static const struct pinmux_irq pinmux_irqs[] = {
	PINMUX_IRQ(irq_pin(0), 11),
	PINMUX_IRQ(irq_pin(1), 10),
	PINMUX_IRQ(irq_pin(2), 149),
	PINMUX_IRQ(irq_pin(3), 224),
	PINMUX_IRQ(irq_pin(4), 159),
	PINMUX_IRQ(irq_pin(5), 227),
	PINMUX_IRQ(irq_pin(6), 147),
	PINMUX_IRQ(irq_pin(7), 150),
	PINMUX_IRQ(irq_pin(8), 223),
	PINMUX_IRQ(irq_pin(9), 56, 308),
	PINMUX_IRQ(irq_pin(10), 54),
	PINMUX_IRQ(irq_pin(11), 238),
	PINMUX_IRQ(irq_pin(12), 156),
	PINMUX_IRQ(irq_pin(13), 239),
	PINMUX_IRQ(irq_pin(14), 251),
	PINMUX_IRQ(irq_pin(15), 0),
	PINMUX_IRQ(irq_pin(16), 249),
	PINMUX_IRQ(irq_pin(17), 234),
	PINMUX_IRQ(irq_pin(18), 13),
	PINMUX_IRQ(irq_pin(19), 9),
	PINMUX_IRQ(irq_pin(20), 14),
	PINMUX_IRQ(irq_pin(21), 15),
	PINMUX_IRQ(irq_pin(22), 40),
	PINMUX_IRQ(irq_pin(23), 53),
	PINMUX_IRQ(irq_pin(24), 118),
	PINMUX_IRQ(irq_pin(25), 164),
	PINMUX_IRQ(irq_pin(26), 115),
	PINMUX_IRQ(irq_pin(27), 116),
	PINMUX_IRQ(irq_pin(28), 117),
	PINMUX_IRQ(irq_pin(29), 28),
	PINMUX_IRQ(irq_pin(30), 27),
	PINMUX_IRQ(irq_pin(31), 26),
};

/* -----------------------------------------------------------------------------
 * VCCQ MC0 regulator
 */

static void sh73a0_vccq_mc0_endisable(struct regulator_dev *reg, bool enable)
{
	struct sh_pfc *pfc = reg->reg_data;
	void __iomem *addr = pfc->windows[1].virt + 4;
	unsigned long flags;
	u32 value;

	spin_lock_irqsave(&pfc->lock, flags);

	value = ioread32(addr);

	if (enable)
		value |= BIT(28);
	else
		value &= ~BIT(28);

	iowrite32(value, addr);

	spin_unlock_irqrestore(&pfc->lock, flags);
}

static int sh73a0_vccq_mc0_enable(struct regulator_dev *reg)
{
	sh73a0_vccq_mc0_endisable(reg, true);
	return 0;
}

static int sh73a0_vccq_mc0_disable(struct regulator_dev *reg)
{
	sh73a0_vccq_mc0_endisable(reg, false);
	return 0;
}

static int sh73a0_vccq_mc0_is_enabled(struct regulator_dev *reg)
{
	struct sh_pfc *pfc = reg->reg_data;
	void __iomem *addr = pfc->windows[1].virt + 4;
	unsigned long flags;
	u32 value;

	spin_lock_irqsave(&pfc->lock, flags);
	value = ioread32(addr);
	spin_unlock_irqrestore(&pfc->lock, flags);

	return !!(value & BIT(28));
}

static int sh73a0_vccq_mc0_get_voltage(struct regulator_dev *reg)
{
	return 3300000;
}

static struct regulator_ops sh73a0_vccq_mc0_ops = {
	.enable = sh73a0_vccq_mc0_enable,
	.disable = sh73a0_vccq_mc0_disable,
	.is_enabled = sh73a0_vccq_mc0_is_enabled,
	.get_voltage = sh73a0_vccq_mc0_get_voltage,
};

static const struct regulator_desc sh73a0_vccq_mc0_desc = {
	.owner = THIS_MODULE,
	.name = "vccq_mc0",
	.type = REGULATOR_VOLTAGE,
	.ops = &sh73a0_vccq_mc0_ops,
};

static struct regulator_consumer_supply sh73a0_vccq_mc0_consumers[] = {
	REGULATOR_SUPPLY("vqmmc", "sh_mobile_sdhi.0"),
	REGULATOR_SUPPLY("vqmmc", "ee100000.sdhi"),
};

static const struct regulator_init_data sh73a0_vccq_mc0_init_data = {
	.constraints = {
		.valid_ops_mask = REGULATOR_CHANGE_STATUS,
	},
	.num_consumer_supplies = ARRAY_SIZE(sh73a0_vccq_mc0_consumers),
	.consumer_supplies = sh73a0_vccq_mc0_consumers,
};

/* -----------------------------------------------------------------------------
 * Pin bias
 */

#define PORTnCR_PULMD_OFF	(0 << 6)
#define PORTnCR_PULMD_DOWN	(2 << 6)
#define PORTnCR_PULMD_UP	(3 << 6)
#define PORTnCR_PULMD_MASK	(3 << 6)

static const unsigned int sh73a0_portcr_offsets[] = {
	0x00000000, 0x00001000, 0x00001000, 0x00002000, 0x00002000,
	0x00002000, 0x00002000, 0x00003000, 0x00003000, 0x00002000,
};

static unsigned int sh73a0_pinmux_get_bias(struct sh_pfc *pfc, unsigned int pin)
{
	void __iomem *addr = pfc->windows->virt
			   + sh73a0_portcr_offsets[pin >> 5] + pin;
	u32 value = ioread8(addr) & PORTnCR_PULMD_MASK;

	switch (value) {
	case PORTnCR_PULMD_UP:
		return PIN_CONFIG_BIAS_PULL_UP;
	case PORTnCR_PULMD_DOWN:
		return PIN_CONFIG_BIAS_PULL_DOWN;
	case PORTnCR_PULMD_OFF:
	default:
		return PIN_CONFIG_BIAS_DISABLE;
	}
}

static void sh73a0_pinmux_set_bias(struct sh_pfc *pfc, unsigned int pin,
				   unsigned int bias)
{
	void __iomem *addr = pfc->windows->virt
			   + sh73a0_portcr_offsets[pin >> 5] + pin;
	u32 value = ioread8(addr) & ~PORTnCR_PULMD_MASK;

	switch (bias) {
	case PIN_CONFIG_BIAS_PULL_UP:
		value |= PORTnCR_PULMD_UP;
		break;
	case PIN_CONFIG_BIAS_PULL_DOWN:
		value |= PORTnCR_PULMD_DOWN;
		break;
	}

	iowrite8(value, addr);
}

/* -----------------------------------------------------------------------------
 * SoC information
 */

struct sh73a0_pinmux_data {
	struct regulator_dev *vccq_mc0;
};

static int sh73a0_pinmux_soc_init(struct sh_pfc *pfc)
{
	struct sh73a0_pinmux_data *data;
	struct regulator_config cfg = { };
	int ret;

	data = devm_kzalloc(pfc->dev, sizeof(*data), GFP_KERNEL);
	if (data == NULL)
		return -ENOMEM;

	cfg.dev = pfc->dev;
	cfg.init_data = &sh73a0_vccq_mc0_init_data;
	cfg.driver_data = pfc;

	data->vccq_mc0 = devm_regulator_register(pfc->dev,
						 &sh73a0_vccq_mc0_desc, &cfg);
	if (IS_ERR(data->vccq_mc0)) {
		ret = PTR_ERR(data->vccq_mc0);
		dev_err(pfc->dev, "Failed to register VCCQ MC0 regulator: %d\n",
			ret);
		return ret;
	}

	pfc->soc_data = data;

	return 0;
}

static const struct sh_pfc_soc_operations sh73a0_pinmux_ops = {
	.init = sh73a0_pinmux_soc_init,
	.get_bias = sh73a0_pinmux_get_bias,
	.set_bias = sh73a0_pinmux_set_bias,
};

const struct sh_pfc_soc_info sh73a0_pinmux_info = {
	.name = "sh73a0_pfc",
	.ops = &sh73a0_pinmux_ops,

	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.groups = pinmux_groups,
	.nr_groups = ARRAY_SIZE(pinmux_groups),
	.functions = pinmux_functions,
	.nr_functions = ARRAY_SIZE(pinmux_functions),

	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),

	.gpio_irq = pinmux_irqs,
	.gpio_irq_size = ARRAY_SIZE(pinmux_irqs),
};
