/*
 * linux/mm/slab.h
 * Written by Mark Hemment, 1996.
 * (markhe@nextd.demon.co.uk)
 */

#if	!defined(_LINUX_SLAB_H)
#define	_LINUX_SLAB_H

#if	defined(__KERNEL__)

typedef struct kmem_cache_s kmem_cache_t;

#include	<linux/mm.h>
#include	<asm/cache.h>

/* flags for kmem_cache_alloc() */
#define	SLAB_BUFFER		GFP_BUFFER	/* 0x00 */
#define	SLAB_ATOMIC		GFP_ATOMIC	/* 0x01 */
#define	SLAB_USER		GFP_USER	/* 0x02 */
#define	SLAB_KERNEL		GFP_KERNEL	/* 0x03 */
#define	SLAB_NOBUFFER		GFP_NOBUFFER	/* 0x04 */
#define	SLAB_NFS		GFP_NFS		/* 0x05 */
#define	SLAB_DMA		GFP_DMA		/* 0x08 */
#define	SLAB_LEVEL_MASK		GFP_LEVEL_MASK	/* 0x0f */
#define	SLAB_NO_GROW		0x00001000UL	/* don't grow a cache */

/* flags to pass to kmem_cache_create().
 * The first 3 are only valid when the allocator as been build
 * SLAB_DEBUG_SUPPORT.
 */
#define	SLAB_DEBUG_FREE		0x00000100UL	/* Peform (expensive) checks on free */
#define	SLAB_DEBUG_INITIAL	0x00000200UL	/* Call constructor (as verifier) */
#define	SLAB_RED_ZONE		0x00000400UL	/* Red zone objs in a cache */
#define	SLAB_POISION		0x00000800UL	/* Poision objects */
#define	SLAB_NO_REAP		0x00001000UL	/* never reap from the cache */
#define	SLAB_HWCACHE_ALIGN	0x00002000UL	/* align objs on a h/w cache lines */
#if	0
#define	SLAB_HIGH_PACK		0x00004000UL	/* XXX */
#endif

/* flags passed to a constructor func */
#define	SLAB_CTOR_CONSTRUCTOR	0x001UL		/* if not set, then deconstructor */
#define SLAB_CTOR_ATOMIC	0x002UL		/* tell constructor it can't sleep */
#define	SLAB_CTOR_VERIFY	0x004UL		/* tell constructor it's a verify call */

/* prototypes */
extern long kmem_cache_init(long, long);
extern void kmem_cache_sizes_init(void);
extern kmem_cache_t *kmem_find_general_cachep(size_t);
extern kmem_cache_t *kmem_cache_create(const char *, size_t, size_t, unsigned long,
				       void (*)(void *, kmem_cache_t *, unsigned long),
				       void (*)(void *, kmem_cache_t *, unsigned long));
extern int kmem_cache_shrink(kmem_cache_t *);
extern void *kmem_cache_alloc(kmem_cache_t *, int);
extern void kmem_cache_free(kmem_cache_t *, void *);

extern void *kmalloc(size_t, int);
extern void kfree(void *);
extern void kfree_s(void *, size_t);

extern int kmem_cache_reap(int, int, int);
extern int get_slabinfo(char *);

/* System wide caches */
extern kmem_cache_t	*vm_area_cachep;
extern kmem_cache_t	*mm_cachep;

#endif	/* __KERNEL__ */

#endif	/* _LINUX_SLAB_H */
