/*
 * Example USB mouse driver.
 *
 * This is horrible, it knows about the UHCI driver
 * internals, but it's just meant as a rough example,
 * let's do the virtualization later when this works.
 *
 * (C) Copyright 1999 Linus Torvalds
 */

#include <linux/kernel.h>

#include "usb.h"
#include "uhci.h"

/*
 * A irq handler returns non-zero to indicate to
 * the low-level driver that it wants to be re-activated,
 * or zero to say "I'm done".
 *
 * This just prints the first ten interrupts, and then
 * no more..
 */
static int mouse_irq(int state, void *__data)
{
	static int count = 100;
	unsigned char *data = __data;

	printk("%x %02x %02x %02x %02x\n", state, 
		data[0], data[1], data[2], data[3]);
	if (--count)
		return 1;
	return 0;
}

static int mouse_probe(struct usb_device *dev)
{
	struct usb_interface_descriptor *interface;
	struct usb_endpoint_descriptor *endpoint;

	/* We don't handle multi-config mice */
	if (dev->descriptor.bNumConfigurations != 1)
		return -1;

	/* We don't handle multi-interface mice */
	if (dev->config[0].bNumInterfaces != 1)
		return -1;

	/* Is it a mouse interface? */
	interface = &dev->config[0].interface[0];
	if (interface->bInterfaceClass != 3)
		return -1;
	if (interface->bInterfaceSubClass != 1)
		return -1;

	/* Multiple endpoints? What kind of mutant ninja-mouse is this? */
	if (interface->bNumEndpoints != 1)
		return -1;

	endpoint = &interface->endpoint[0];

	/* Output endpoint? Curiousier and curiousier.. */
	if (!(endpoint->bEndpointAddress & 0x80))
		return -1;

	/* If it's not an interrupt endpoint, we'd better punt! */
	if ((endpoint->bmAttributes & 3) != 3)
		return -1;

	usb_set_configuration(dev, dev->config[0].bConfigurationValue);

	usb_request_irq(dev, usb_rcvctrlpipe(dev, endpoint->bEndpointAddress), mouse_irq, endpoint->bInterval);
	return 0;
}

static void mouse_disconnect(struct usb_device *dev)
{
	printk("Somebody ate my mouse!\n");
}

static struct usb_driver mouse_driver = {
	"mouse",
	mouse_probe,
	mouse_disconnect,
	{ NULL, NULL }
};

/*
 * This should be a separate module.
 */
int init_mouse(void)
{
	usb_register(&mouse_driver);
	return 0;
}
