# Usage
#
#   dump_cmake_variables(<var_regex> [<val_regex>])
#
# For example, to show all variables names matching '[A-Z]+':
#
#   dump_cmake_variables([A-Z]+)
#
function(dump_cmake_variables)
  string(ASCII 27 _escape)
  get_cmake_property(_variableNames VARIABLES)
  list(SORT _variableNames)
  unset(_var_regex)
  unset(_val_regex)
  if (ARGC GREATER 0)
    if (NOT ARGV0 STREQUAL "")
      set(_var_regex "${ARGV0}")
    endif ()
    if ((ARGC GREATER 1) AND NOT ARGV1 STREQUAL "")
      set(_val_regex "${ARGV1}")
    endif ()
  endif ()
  foreach (_variableName ${_variableNames})
    if (_var_regex)
      unset(_matched)
      string(REGEX MATCH "${_var_regex}" _matched ${_variableName})
      if (NOT _matched)
	continue()
      endif ()
    endif ()
    if (_val_regex)
      unset(_matched)
      string(REGEX MATCH "${_val_regex}" _matched "${${_variableName}}")
      if (NOT _matched)
	continue()
      endif ()
    endif ()
    string(REGEX REPLACE "(${_escape})" "\\\\e" _escaped_value1 "${${_variableName}}")
    string(REGEX REPLACE "(\n)" "\\\\n" _escaped_value2 "${_escaped_value1}")
    message(STATUS "${_variableName}=${_escaped_value2}")
  endforeach ()
endfunction()
